/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SentenceFragment {
    public final List<CoreLabel> words = new ArrayList<CoreLabel>();
    public final SemanticGraph parseTree;
    public double score = 1.0;

    public SentenceFragment(SemanticGraph tree, boolean copy) {
        this.parseTree = copy ? new SemanticGraph(tree) : tree;
        this.words.addAll(this.parseTree.vertexListSorted().stream().map(IndexedWord::backingLabel).collect(Collectors.toList()));
    }

    public int length() {
        return this.words.size();
    }

    public SentenceFragment changeScore(double score) {
        this.score = score;
        return this;
    }

    public List<CoreLabel> paddedWords() {
        int maxIndex = -1;
        for (IndexedWord vertex : this.parseTree.vertexSet()) {
            maxIndex = Math.max(maxIndex, vertex.index());
        }
        ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>(maxIndex);
        for (int i = 0; i < maxIndex; ++i) {
            tokens.add(null);
        }
        for (CoreLabel token : this.words) {
            tokens.set(token.index() - 1, token);
        }
        return tokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SentenceFragment)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SentenceFragment that = (SentenceFragment)o;
        return this.parseTree.equals(that.parseTree);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.parseTree.hashCode();
        return result;
    }

    public String toString() {
        return StringUtils.join(this.words.stream().map(CoreLabel::word), " ");
    }
}

