/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.naturalli;

import edu.stanford.nlp.dcoref.CorefChain;
import edu.stanford.nlp.dcoref.CorefCoreAnnotations;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.naturalli.ClauseSplitter;
import edu.stanford.nlp.naturalli.ClauseSplitterSearchProblem;
import edu.stanford.nlp.naturalli.ForwardEntailer;
import edu.stanford.nlp.naturalli.ForwardEntailerSearchProblem;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.NaturalLogicWeights;
import edu.stanford.nlp.naturalli.SentenceFragment;
import edu.stanford.nlp.naturalli.Util;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Execution;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OpenIE
implements Annotator {
    private static SemgrexPattern adjectivePattern = SemgrexPattern.compile("{}=obj >nsubj {}=subj >cop {}=be >det {word:/an?/} >amod {}=adj ?>/prep_.*/=prep {}=pobj");
    @Execution.Option(name="optimizefor", gloss="{General, KB}: Optimize the system for particular tasks (e.g., knowledge base completion tasks -- try to make the subject and object coherent named entities).")
    private Optimization optimizeFor = Optimization.GENERAL;
    @Execution.Option(name="splitter.model", gloss="The location of the clause splitting model.")
    private String splitterModel = "edu/stanford/nlp/naturalli/clauseSplitterModel.ser.gz";
    @Execution.Option(name="splitter.nomodel", gloss="If true, don't load a clause splitter model. This is primarily useful for training.")
    private boolean noModel = false;
    @Execution.Option(name="splitter.threshold", gloss="The minimum threshold for accepting a clause.")
    private double splitterThreshold = 0.5;
    @Execution.Option(name="max_entailments_per_clause", gloss="The maximum number of entailments allowed per sentence of input.")
    private int entailmentsPerSentence = 100;
    @Execution.Option(name="ignoreaffinity", gloss="If true, don't use the affinity models for dobj and pp attachment.")
    private boolean ignoreAffinity = false;
    @Execution.Option(name="affinity_models", gloss="The directory (or classpath directory) containing the affinity models for pp/obj attachments.")
    private String affinityModels = "edu/stanford/nlp/naturalli/";
    @Execution.Option(name="affinity_probability_cap", gloss="The affinity to consider 1.0")
    private double affinityProbabilityCap = 0.3333333333333333;
    @Execution.Option(name="triple.strict", gloss="If true, only generate triples if the entire fragment has been consumed.")
    private boolean consumeAll = true;
    private final NaturalLogicWeights weights;
    public final Function<SemanticGraph, ClauseSplitterSearchProblem> clauseSplitter;
    public final Function<SemanticGraph, ForwardEntailerSearchProblem> forwardEntailer;

    public OpenIE() {
        this(new Properties());
    }

    public OpenIE(Properties props) {
        Execution.fillOptions((Object)this, props);
        try {
            this.weights = this.ignoreAffinity ? new NaturalLogicWeights(this.affinityProbabilityCap) : new NaturalLogicWeights(this.affinityModels, this.affinityProbabilityCap);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Could not load affinity model at " + this.affinityModels + ": " + e.getMessage());
        }
        try {
            if (this.noModel) {
                System.err.println("Not loading a splitter model");
                this.clauseSplitter = new ClauseSplitter(){

                    @Override
                    public ClauseSplitterSearchProblem apply(SemanticGraph semanticGraph) {
                        return new ClauseSplitterSearchProblem(semanticGraph);
                    }
                };
            } else {
                this.clauseSplitter = ClauseSplitter.load(this.splitterModel);
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException("Could not load clause splitter model at " + this.splitterModel + ": " + e.getMessage());
        }
        this.forwardEntailer = new ForwardEntailer(this.entailmentsPerSentence, this.weights);
    }

    public List<SentenceFragment> clausesInSentence(SemanticGraph tree) {
        return this.clauseSplitter.apply(tree).topClauses(this.splitterThreshold);
    }

    public List<SentenceFragment> clausesInSentence(CoreMap sentence) {
        return this.clausesInSentence((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class));
    }

    public List<SentenceFragment> entailmentsFromClause(SentenceFragment clause) {
        if (clause.parseTree.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        List<SentenceFragment> list = this.forwardEntailer.apply(clause.parseTree).search().stream().map(x -> x.changeScore(x.score * sentenceFragment.score)).collect(Collectors.toList());
        list.add(clause);
        ArrayList<SentenceFragment> adjFragments = new ArrayList<SentenceFragment>();
        SemgrexMatcher matcher = adjectivePattern.matcher(clause.parseTree);
        block0: while (matcher.find()) {
            IndexedWord subj = matcher.getNode("subj");
            IndexedWord be = matcher.getNode("be");
            IndexedWord adj = matcher.getNode("adj");
            IndexedWord obj = matcher.getNode("obj");
            IndexedWord pobj = matcher.getNode("pobj");
            String prep = matcher.getRelnString("prep");
            for (SemanticGraphEdge edge : clause.parseTree.outgoingEdgeIterable(obj)) {
                if (!"amod".equals(edge.getRelation().toString()) || edge.getDependent().index() > adj.index() || !Util.PRIVATIVE_ADJECTIVES.contains(edge.getDependent().word().toLowerCase())) continue;
                continue block0;
            }
            SemanticGraph tree = new SemanticGraph();
            tree.addRoot(adj);
            tree.addVertex(subj);
            tree.addVertex(be);
            tree.addEdge(adj, be, GrammaticalRelation.valueOf(Language.English, "cop"), Double.NEGATIVE_INFINITY, false);
            tree.addEdge(adj, subj, GrammaticalRelation.valueOf(Language.English, "nsubj"), Double.NEGATIVE_INFINITY, false);
            if (pobj != null) {
                assert (prep != null);
                tree.addEdge(adj, pobj, GrammaticalRelation.valueOf(Language.English, prep), Double.NEGATIVE_INFINITY, false);
            }
            adjFragments.add(new SentenceFragment(tree, false));
        }
        list.addAll(adjFragments);
        return list;
    }

    public List<SentenceFragment> entailmentsFromClauses(Collection<SentenceFragment> clauses) {
        ArrayList<SentenceFragment> entailments = new ArrayList<SentenceFragment>();
        for (SentenceFragment clause : clauses) {
            entailments.addAll(this.entailmentsFromClause(clause));
        }
        return entailments;
    }

    public Optional<RelationTriple> relationInFragment(SentenceFragment fragment) {
        return RelationTriple.segment(fragment.parseTree, Optional.of(fragment.score), this.consumeAll).map(rel -> {
            switch (this.optimizeFor) {
                case GENERAL: {
                    return rel;
                }
                case KB: {
                    throw new IllegalStateException("Cannot optimize for KB with this function -- use the annotate() method instead");
                }
            }
            throw new IllegalStateException("Unknown enum constant: " + (Object)((Object)this.optimizeFor));
        });
    }

    public List<RelationTriple> relationsInFragments(Collection<SentenceFragment> fragments) {
        return fragments.stream().map(this::relationInFragment).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<RelationTriple> relationInFragment(SentenceFragment fragment, CoreMap sentence, Map<CoreLabel, List<CoreLabel>> canonicalMentionMap) {
        return RelationTriple.segment(fragment.parseTree, Optional.of(fragment.score), this.consumeAll).flatMap(rel -> {
            switch (this.optimizeFor) {
                case GENERAL: {
                    return Optional.of(rel);
                }
                case KB: {
                    return RelationTriple.optimizeForKB(rel, Optional.of(sentence), canonicalMentionMap);
                }
            }
            throw new IllegalStateException("Unknown enum constant: " + (Object)((Object)this.optimizeFor));
        });
    }

    private List<RelationTriple> relationsInFragments(Collection<SentenceFragment> fragments, CoreMap sentence, Map<CoreLabel, List<CoreLabel>> canonicalMentionMap) {
        return fragments.stream().map(x -> this.relationInFragment((SentenceFragment)x, sentence, canonicalMentionMap)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public List<RelationTriple> relationsInClause(SentenceFragment clause) {
        return this.relationsInFragments(this.entailmentsFromClause(clause));
    }

    public List<RelationTriple> relationsInSentence(CoreMap sentence) {
        return this.relationsInFragments(this.entailmentsFromClauses(this.clausesInSentence(sentence)));
    }

    public void annotateSentence(CoreMap sentence, Map<CoreLabel, List<CoreLabel>> canonicalMentionMap) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        if (tokens.size() < 2) {
            System.err.println("Very short sentence (<2 tokens); " + this.getClass().getSimpleName() + " is skipping it.");
            sentence.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, Collections.EMPTY_LIST);
            sentence.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, Collections.EMPTY_LIST);
        } else {
            SemanticGraph parse = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
            if (parse == null) {
                parse = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            }
            if (parse == null) {
                throw new IllegalStateException("Cannot run OpenIE without a parse tree!");
            }
            List<RelationTriple> extractions = RelationTriple.extract(parse, tokens);
            if (tokens.size() > 63) {
                System.err.println("Very long sentence (>63 tokens); " + this.getClass().getSimpleName() + " is not attempting to extract clauses.");
                sentence.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, Collections.EMPTY_LIST);
                sentence.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, Collections.EMPTY_LIST);
            } else {
                List<SentenceFragment> clauses = this.clausesInSentence(sentence);
                List<SentenceFragment> fragments = this.entailmentsFromClauses(clauses);
                fragments.add(new SentenceFragment((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class), false));
                extractions.addAll(this.relationsInFragments(fragments, sentence, canonicalMentionMap));
                sentence.set(NaturalLogicAnnotations.EntailedSentencesAnnotation.class, fragments);
                sentence.set(NaturalLogicAnnotations.RelationTriplesAnnotation.class, extractions);
            }
        }
    }

    @Override
    public void annotate(Annotation annotation) {
        Map corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        IdentityHashMap<CoreLabel, List> canonicalMentionMap = new IdentityHashMap<CoreLabel, List>();
        if (corefChains != null) {
            for (CorefChain chain : corefChains.values()) {
                List canonicalMention = null;
                double canonicalMentionScore = Double.NEGATIVE_INFINITY;
                HashSet tokensToMark = new HashSet();
                List<CorefChain.CorefMention> mentions = chain.getMentionsInTextualOrder();
                for (int i = 0; i < mentions.size(); ++i) {
                    Pair<List<CoreLabel>, Double> info = OpenIE.grokCorefMention(annotation, mentions.get(i));
                    double score = (Double)info.second + (double)i / (double)mentions.size() + (mentions.get(i) == chain.getRepresentativeMention() ? 1.0 : 0.0);
                    if (canonicalMention == null || score > canonicalMentionScore) {
                        canonicalMention = (List)info.first;
                        canonicalMentionScore = score;
                    }
                    tokensToMark.addAll((Collection)info.first);
                }
                assert (canonicalMention != null);
                for (CoreLabel token : tokensToMark) {
                    canonicalMentionMap.put(token, canonicalMention);
                }
            }
        }
        ((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).forEach(x -> this.annotateSentence((CoreMap)x, (Map<CoreLabel, List<CoreLabel>>)canonicalMentionMap));
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return Collections.singleton(Annotator.NATLOG_REQUIREMENT);
    }

    private static Pair<List<CoreLabel>, Double> grokCorefMention(Annotation doc, CorefChain.CorefMention mention) {
        List tokens = (List)((CoreMap)((List)doc.get(CoreAnnotations.SentencesAnnotation.class)).get(mention.sentNum - 1)).get(CoreAnnotations.TokensAnnotation.class);
        List mentionAsTokens = tokens.subList(mention.startIndex - 1, mention.endIndex - 1);
        ClassicCounter nerVotes = new ClassicCounter();
        mentionAsTokens.stream().filter(token -> token.ner() != null && !"O".equals(token.ner())).forEach(token -> nerVotes.incrementCount(token.ner()));
        String ner = (String)Counters.argmax(nerVotes, (o1, o2) -> o1 == null ? 0 : o1.compareTo((String)o2));
        double nerCount = nerVotes.getCount(ner);
        double nerScore = nerCount * nerCount / (double)mentionAsTokens.size();
        return Pair.makePair(mentionAsTokens, nerScore);
    }

    public static void main(String[] args) {
        Properties props = StringUtils.argsToProperties(args);
        props.setProperty("annotators", "tokenize,ssplit,pos,depparse,natlog,openie");
        props.setProperty("depparse.extradependencies", "ref_only_uncollapsed");
        props.setProperty("ssplit.isOneSentence", "true");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        Scanner in = new Scanner(System.in);
        while (in.hasNext()) {
            String line = in.nextLine();
            Annotation ann = new Annotation(line);
            pipeline.annotate(ann);
            Collection extractions = (Collection)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(0)).get(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
            if (extractions.isEmpty()) {
                System.err.println("No extractions for: " + line);
            }
            extractions.forEach(System.out::println);
        }
    }

    private static enum Optimization {
        GENERAL,
        KB;

    }
}

