/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.spanish;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.util.Pair;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SpanishVerbStripper
implements Serializable {
    private static final Map<String, SpanishVerbStripper> instances = new HashMap<String, SpanishVerbStripper>();
    private HashMap<String, String> dict;
    private static final String DEFAULT_DICT = "edu/stanford/nlp/international/spanish/enclitic-inflections.data";
    private static final String PATTERN_ATTACHED_PRONOUNS = "(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$";
    private static final Pattern pTwoAttachedPronouns = Pattern.compile("(?:([mts]e|n?os|les?)(l[eoa]s?)?)$");
    private static final Pattern pOneAttachedPronoun = Pattern.compile("([mts]e|n?os|les?|l[oa]s?)$");
    private static final Pattern pStrippable = Pattern.compile("(?:[aei\u00e1\u00e9\u00ed]r|[\u00e1\u00e9]ndo|[ae\u00e1\u00e9]n?|[ae\u00e1\u00e9]mos?|[aei\u00e1\u00e9\u00ed](?:d(?!os)|(?=os)))(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$");
    private static final Pattern pIrregulars = Pattern.compile("^(?:d[i\u00ed]|h[a\u00e1]z|v[e\u00e9]|p[o\u00f3]n|s[a\u00e1]l|s\u00e9|t[e\u00e9]n|v[e\u00e9]n|(?:id(?=os$)))(?:(?:(?:[mts]e|n?os|les?)(?:l[oa]s?)?)|l[oa]s?)$");
    private static final Pair<Pattern, String>[] accentFixes = new Pair[]{new Pair<Pattern, String>(Pattern.compile("\u00e1"), "a"), new Pair<Pattern, String>(Pattern.compile("\u00e9"), "e"), new Pair<Pattern, String>(Pattern.compile("\u00ed"), "i"), new Pair<Pattern, String>(Pattern.compile("\u00f3"), "o"), new Pair<Pattern, String>(Pattern.compile("\u00fa"), "u")};
    private static final Set<String> accentedInfinitives = new HashSet<String>(Arrays.asList("desle\u00edr", "deso\u00edr", "emba\u00edr", "engre\u00edr", "entreo\u00edr", "fre\u00edr", "o\u00edr", "refre\u00edr", "re\u00edr", "sofre\u00edr", "sonre\u00edr"));
    private static final long serialVersionUID = -4780144226395772354L;

    private void setupDictionary(String dictPath) {
        try {
            String line;
            this.dict = new HashMap();
            BufferedReader br = IOUtils.readerFromString(dictPath);
            while ((line = br.readLine()) != null) {
                String[] words = line.trim().split("\\s");
                if (words.length < 3) {
                    System.err.printf("SpanishVerbStripper: addings words to dict, missing word, ignoring line%n", new Object[0]);
                    continue;
                }
                this.dict.put(words[0], words[2]);
            }
            IOUtils.closeIgnoringExceptions(br);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not load Spanish data file " + dictPath);
        }
        catch (IOException e) {
            System.err.println("Could not load Spanish data file " + dictPath);
        }
    }

    private SpanishVerbStripper() {
        this(DEFAULT_DICT);
    }

    private SpanishVerbStripper(String dictPath) {
        this.setupDictionary(dictPath);
    }

    public static SpanishVerbStripper getInstance() {
        return SpanishVerbStripper.getInstance(DEFAULT_DICT);
    }

    public static SpanishVerbStripper getInstance(String dictPath) {
        SpanishVerbStripper svs = instances.get(dictPath);
        if (svs == null) {
            svs = new SpanishVerbStripper(dictPath);
            instances.put(dictPath, svs);
        }
        return svs;
    }

    public static boolean isStrippable(String word) {
        return pStrippable.matcher(word).find() || pIrregulars.matcher(word).find();
    }

    private static String removeAccents(String word) {
        if (accentedInfinitives.contains(word)) {
            return word;
        }
        String stripped = word;
        for (Pair<Pattern, String> accentFix : accentFixes) {
            stripped = accentFix.first().matcher(stripped).replaceAll(accentFix.second());
        }
        return stripped;
    }

    private static char getCase(String original, char letter) {
        if (Character.isUpperCase(original.charAt(original.length() - 1))) {
            return Character.toUpperCase(letter);
        }
        return Character.toLowerCase(letter);
    }

    private boolean validateVerbPair(Pair<String, List<String>> pair) {
        String stripped = pair.first().toLowerCase();
        String firstPron = pair.second().get(0).toLowerCase();
        String pos = this.dict.get(stripped);
        if (pos != null) {
            return !pos.equals("VMM02P0") || !firstPron.equalsIgnoreCase("os");
        }
        if (firstPron.equalsIgnoreCase("os") && this.dict.containsKey(stripped + 'd')) {
            pair.setFirst(pair.first() + SpanishVerbStripper.getCase(pair.first(), 'd'));
            return true;
        }
        if (firstPron.matches("nos|se") && this.dict.containsKey(stripped + 's')) {
            pair.setFirst(pair.first() + SpanishVerbStripper.getCase(pair.first(), 's'));
            return true;
        }
        return false;
    }

    private static Pair<String, List<String>> stripSuffix(String word, Pattern pSuffix) {
        Matcher m = pSuffix.matcher(word);
        if (m.find()) {
            String stripped = word.substring(0, m.start());
            stripped = SpanishVerbStripper.removeAccents(stripped);
            ArrayList<String> attached = new ArrayList<String>();
            for (int i = 0; i < m.groupCount(); ++i) {
                attached.add(m.group(i + 1));
            }
            return new Pair<String, List<String>>(stripped, attached);
        }
        return null;
    }

    public Pair<String, List<String>> separatePronouns(String verb) {
        Pair<String, List<String>> separated = SpanishVerbStripper.stripSuffix(verb, pOneAttachedPronoun);
        if (separated != null && this.validateVerbPair(separated)) {
            return separated;
        }
        separated = SpanishVerbStripper.stripSuffix(verb, pTwoAttachedPronouns);
        if (separated != null && this.validateVerbPair(separated)) {
            return separated;
        }
        return null;
    }

    public String stripVerb(String verb) {
        Pair<String, List<String>> separated = this.separatePronouns(verb);
        if (separated != null) {
            return separated.first();
        }
        return null;
    }
}

