/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.sieve;

import edu.stanford.nlp.hcoref.CorefPrinter;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.Rules;
import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.sieve.DcorefSieveOptions;
import edu.stanford.nlp.hcoref.sieve.Sieve;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class DeterministicCorefSieve
extends Sieve {
    public final DcorefSieveOptions flags;

    public DeterministicCorefSieve() {
        this.classifierType = Sieve.ClassifierType.RULE;
        this.flags = new DcorefSieveOptions();
    }

    public DeterministicCorefSieve(Properties props) {
        super(props);
        this.classifierType = Sieve.ClassifierType.RULE;
        this.flags = new DcorefSieveOptions();
    }

    @Override
    public void findCoreferentAntecedent(Mention m, int mIdx, Document document, Dictionaries dict, Properties props, StringBuilder sbLog) throws Exception {
        if (!(this.flags.USE_SPEAKERMATCH || this.flags.USE_DISCOURSEMATCH || this.flags.USE_APPOSITION || this.flags.USE_PREDICATENOMINATIVES || !this.skipThisMention(document, m, document.corefClusters.get(m.corefClusterID), dict))) {
            return;
        }
        Set<Mention> roleSet = document.roleSet;
        for (int sentJ = m.sentNum; sentJ >= 0; --sentJ) {
            List<Mention> l = Sieve.getOrderedAntecedents(m, sentJ, mIdx, document.predictedMentions, dict);
            if (this.maxSentDist != -1 && m.sentNum - sentJ > this.maxSentDist) continue;
            for (int i = 0; i < l.size(); ++i) {
                for (int j = 0; j < l.size(); ++j) {
                    if (!l.get((int)i).headString.equals(l.get((int)j).headString) || l.get((int)i).startIndex != l.get((int)j).startIndex || !l.get(i).sameSentence(l.get(j)) || j <= i || l.get(i).spanToString().length() <= l.get(j).spanToString().length()) continue;
                    l.set(j, l.set(i, l.get(j)));
                }
            }
            for (Mention ant : l) {
                if (DeterministicCorefSieve.skipForAnalysis(ant, m, props) || m.isSingleton && m.mentionType != Dictionaries.MentionType.PROPER && ant.isSingleton && ant.mentionType != Dictionaries.MentionType.PROPER || m.corefClusterID == ant.corefClusterID || !this.mType.contains((Object)m.mentionType) || !this.aType.contains((Object)ant.mentionType) || m.mentionType == Dictionaries.MentionType.PRONOMINAL && (!DeterministicCorefSieve.matchedMentionType(m, this.mTypeStr) || !DeterministicCorefSieve.matchedMentionType(ant, this.aTypeStr))) continue;
                CorefCluster c1 = document.corefClusters.get(m.corefClusterID);
                CorefCluster c2 = document.corefClusters.get(ant.corefClusterID);
                assert (c1 != null);
                assert (c2 != null);
                if (this.useRoleSkip()) {
                    if (m.isRoleAppositive(ant, dict)) {
                        roleSet.add(m);
                        continue;
                    }
                    if (!ant.isRoleAppositive(m, dict)) continue;
                    roleSet.add(ant);
                    continue;
                }
                if (!this.coreferent(document, c1, c2, m, ant, dict, roleSet)) continue;
                if (CorefProperties.debug(props)) {
                    sbLog.append(CorefPrinter.printErrorLogDcoref(m, ant, document, dict, mIdx, this.getClass().getName()));
                }
                int removeID = c1.clusterID;
                CorefCluster.mergeClusters(c2, c1);
                document.mergeIncompatibles(c2, c1);
                document.mergeAcronymCache(c2, c1);
                document.corefClusters.remove(removeID);
                return;
            }
        }
    }

    public String flagsToString() {
        return this.flags.toString();
    }

    public boolean useRoleSkip() {
        return this.flags.USE_ROLE_SKIP;
    }

    public boolean skipThisMention(Document document, Mention m1, CorefCluster c, Dictionaries dict) {
        boolean skip = false;
        if (!(this.flags.USE_ROLEAPPOSITION || this.flags.USE_PREDICATENOMINATIVES || this.flags.USE_ACRONYM || this.flags.USE_APPOSITION || this.flags.USE_RELATIVEPRONOUN || c.getFirstMention().equals(m1))) {
            return true;
        }
        if (m1.appositions == null && m1.predicateNominatives == null && (m1.lowercaseNormalizedSpanString().startsWith("a ") || m1.lowercaseNormalizedSpanString().startsWith("an ")) && !this.flags.USE_EXACTSTRINGMATCH) {
            skip = true;
        }
        if (dict.indefinitePronouns.contains(m1.lowercaseNormalizedSpanString())) {
            skip = true;
        }
        for (String indef : dict.indefinitePronouns) {
            if (!m1.lowercaseNormalizedSpanString().startsWith(indef + " ")) continue;
            skip = true;
            break;
        }
        return skip;
    }

    public boolean checkEntityMatch(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Dictionaries dict, Set<Mention> roleSet) {
        return false;
    }

    public boolean coreferent(Document document, CorefCluster mentionCluster, CorefCluster potentialAntecedent, Mention mention2, Mention ant, Dictionaries dict, Set<Mention> roleSet) throws Exception {
        boolean ret = false;
        Mention mention = mentionCluster.getRepresentativeMention();
        if (this.flags.USE_INCOMPATIBLES && document.isIncompatible(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (this.flags.DO_PRONOUN && Math.abs(mention2.sentNum - ant.sentNum) > 3 && mention2.person != Dictionaries.Person.I && mention2.person != Dictionaries.Person.YOU) {
            return false;
        }
        if (mention2.lowercaseNormalizedSpanString().equals("this") && Math.abs(mention2.sentNum - ant.sentNum) > 3) {
            return false;
        }
        if (mention2.person == Dictionaries.Person.YOU && document.docType == Document.DocType.ARTICLE && ((String)mention2.headWord.get(CoreAnnotations.SpeakerAnnotation.class)).equals("PER0")) {
            return false;
        }
        if (document.conllDoc != null) {
            if (ant.generic && ant.person == Dictionaries.Person.YOU) {
                return false;
            }
            if (mention2.generic) {
                return false;
            }
        }
        if (!(this.lang == Locale.CHINESE && document.docInfo != null && document.docInfo.getOrDefault("DOC_ID", "").contains("nw") || !mention2.insideIn(ant) && !ant.insideIn(mention2))) {
            return false;
        }
        if (this.flags.USE_SPEAKERMATCH) {
            String mSpeaker = (String)mention2.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
            String aSpeaker = (String)ant.headWord.get(CoreAnnotations.SpeakerAnnotation.class);
            if (mention2.person == Dictionaries.Person.I && ant.person == Dictionaries.Person.I) {
                return mSpeaker.equals(aSpeaker);
            }
            if (mention2.person == Dictionaries.Person.I && mSpeaker.equals(Integer.toString(ant.mentionID)) || ant.person == Dictionaries.Person.I && aSpeaker.equals(Integer.toString(mention2.mentionID))) {
                return true;
            }
        }
        if (this.flags.USE_DISCOURSEMATCH) {
            Iterator<Mention> mString = mention.lowercaseNormalizedSpanString();
            String antString = ant.lowercaseNormalizedSpanString();
            if (mention.speakerInfo != null && mention.speakerInfo == ant.speakerInfo) {
                return true;
            }
            if (mention.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(mString) && ant.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(antString) && Rules.entitySameSpeaker(document, mention, ant)) {
                return true;
            }
            if (mention.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(mString) && Rules.antecedentIsMentionSpeaker(document, mention, ant, dict)) {
                if (mention.speakerInfo == null && ant.speakerInfo != null) {
                    mention.speakerInfo = ant.speakerInfo;
                }
                return true;
            }
            if (ant.number == Dictionaries.Number.SINGULAR && dict.firstPersonPronouns.contains(antString) && Rules.antecedentIsMentionSpeaker(document, ant, mention, dict)) {
                if (ant.speakerInfo == null && mention.speakerInfo != null) {
                    ant.speakerInfo = mention.speakerInfo;
                }
                return true;
            }
            if (dict.secondPersonPronouns.contains(mString) && dict.secondPersonPronouns.contains(antString) && Rules.entitySameSpeaker(document, mention, ant)) {
                return true;
            }
            if ((mention.person == Dictionaries.Person.I && ant.person == Dictionaries.Person.YOU || mention.person == Dictionaries.Person.YOU && ant.person == Dictionaries.Person.I) && (Integer)mention.headWord.get(CoreAnnotations.UtteranceAnnotation.class) - (Integer)ant.headWord.get(CoreAnnotations.UtteranceAnnotation.class) == 1 && document.docType == Document.DocType.CONVERSATION) {
                return true;
            }
            if (dict.reflexivePronouns.contains(mention.headString) && Rules.entitySubjectObject(mention, ant)) {
                return true;
            }
        }
        if (!(this.flags.USE_EXACTSTRINGMATCH || this.flags.USE_RELAXED_EXACTSTRINGMATCH || this.flags.USE_APPOSITION || this.flags.USE_WORDS_INCLUSION)) {
            for (Mention m : mentionCluster.getCorefMentions()) {
                for (Mention a : potentialAntecedent.getCorefMentions()) {
                    if (m.person != Dictionaries.Person.I && a.person != Dictionaries.Person.I && (Rules.antecedentIsMentionSpeaker(document, m, a, dict) || Rules.antecedentIsMentionSpeaker(document, a, m, dict))) {
                        document.addIncompatible(m, a);
                        return false;
                    }
                    int dist = Math.abs((Integer)m.headWord.get(CoreAnnotations.UtteranceAnnotation.class) - (Integer)a.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
                    if (document.docType == Document.DocType.ARTICLE || dist != 1 || Rules.entitySameSpeaker(document, m, a)) continue;
                    String mSpeaker = document.speakers.get(m.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
                    String aSpeaker = document.speakers.get(a.headWord.get(CoreAnnotations.UtteranceAnnotation.class));
                    if (m.person == Dictionaries.Person.I && a.person == Dictionaries.Person.I) {
                        document.addIncompatible(m, a);
                        return false;
                    }
                    if (m.person == Dictionaries.Person.YOU && a.person == Dictionaries.Person.YOU) {
                        document.addIncompatible(m, a);
                        return false;
                    }
                    if (m.person != Dictionaries.Person.WE || a.person != Dictionaries.Person.WE) continue;
                    document.addIncompatible(m, a);
                    return false;
                }
            }
            if (document.docType == Document.DocType.ARTICLE) {
                for (Mention m : mentionCluster.getCorefMentions()) {
                    for (Mention a : potentialAntecedent.getCorefMentions()) {
                        if (!Rules.entitySubjectObject(m, a)) continue;
                        document.addIncompatible(m, a);
                        return false;
                    }
                }
            }
        }
        if (this.flags.USE_iwithini && Rules.entityIWithinI(mention, ant, dict)) {
            document.addIncompatible(mention, ant);
            return false;
        }
        if (this.flags.USE_EXACTSTRINGMATCH && Rules.entityExactStringMatch(mention, ant, dict, roleSet)) {
            return true;
        }
        if (this.flags.USE_NAME_MATCH && this.checkEntityMatch(document, mentionCluster, potentialAntecedent, dict, roleSet)) {
            ret = true;
        }
        if (this.flags.USE_RELAXED_EXACTSTRINGMATCH && Rules.entityRelaxedExactStringMatch(mentionCluster, potentialAntecedent, mention, ant, dict, roleSet)) {
            return true;
        }
        if (this.flags.USE_APPOSITION && Rules.entityIsApposition(mentionCluster, potentialAntecedent, mention, ant)) {
            return true;
        }
        if (this.flags.USE_PREDICATENOMINATIVES && Rules.entityIsPredicateNominatives(mentionCluster, potentialAntecedent, mention, ant)) {
            return true;
        }
        if (this.flags.USE_ACRONYM && Rules.entityIsAcronym(document, mentionCluster, potentialAntecedent)) {
            return true;
        }
        if (this.flags.USE_RELATIVEPRONOUN && Rules.entityIsRelativePronoun(mention, ant)) {
            return true;
        }
        if (this.flags.USE_DEMONYM && mention.isDemonym(ant, dict)) {
            return true;
        }
        if (this.flags.USE_ROLEAPPOSITION) {
            if (this.lang == Locale.CHINESE) {
                ret = false;
            } else if (Rules.entityIsRoleAppositive(mentionCluster, potentialAntecedent, mention, ant, dict)) {
                ret = true;
            }
        }
        if (this.flags.USE_INCLUSION_HEADMATCH && Rules.entityHeadsAgree(mentionCluster, potentialAntecedent, mention, ant, dict)) {
            ret = true;
        }
        if (this.flags.USE_RELAXED_HEADMATCH && Rules.entityRelaxedHeadsAgreeBetweenMentions(mentionCluster, potentialAntecedent, mention, ant)) {
            ret = true;
        }
        if (this.flags.USE_WORDS_INCLUSION && ret && !Rules.entityWordsIncluded(mentionCluster, potentialAntecedent, mention, ant)) {
            return false;
        }
        if (this.flags.USE_INCOMPATIBLE_MODIFIER && ret && Rules.entityHaveIncompatibleModifier(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (this.flags.USE_PROPERHEAD_AT_LAST && ret && !Rules.entitySameProperHeadLastWord(mentionCluster, potentialAntecedent, mention, ant)) {
            return false;
        }
        if (this.flags.USE_ATTRIBUTES_AGREE && !Rules.entityAttributesAgree(mentionCluster, potentialAntecedent)) {
            return false;
        }
        if (this.flags.USE_DIFFERENT_LOCATION && Rules.entityHaveDifferentLocation(mention, ant, dict)) {
            if (!this.flags.USE_PROPERHEAD_AT_LAST || !ret || mention.goldCorefClusterID != ant.goldCorefClusterID) {
                // empty if block
            }
            return false;
        }
        if (this.flags.USE_NUMBER_IN_MENTION && Rules.entityNumberInLaterMention(mention, ant)) {
            if (!this.flags.USE_PROPERHEAD_AT_LAST || !ret || mention.goldCorefClusterID != ant.goldCorefClusterID) {
                // empty if block
            }
            return false;
        }
        if (this.flags.USE_DISTANCE && Rules.entityTokenDistance(mention2, ant)) {
            return false;
        }
        if (this.flags.USE_COREF_DICT) {
            if (ant.headWord.lemma().equals(mention2.headWord.lemma())) {
                return false;
            }
            if (ant.mentionType != Dictionaries.MentionType.PROPER && (((String)mention2.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).startsWith("NNP") || !mention2.headWord.word().substring(1).equals(mention2.headWord.word().substring(1).toLowerCase()))) {
                return false;
            }
            if (((String)ant.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("NNS") && ((String)mention2.headWord.get(CoreAnnotations.PartOfSpeechAnnotation.class)).equals("NNS")) {
                return false;
            }
            if (dict.indefinitePronouns.contains(ant.originalSpan.get(0).lemma()) || dict.indefinitePronouns.contains(mention2.originalSpan.get(0).lemma())) {
                return false;
            }
            if (ant.isCoordinated() || mention2.isCoordinated()) {
                return false;
            }
            if (Rules.contextIncompatible(mention2, ant, dict)) {
                return false;
            }
            if (Rules.sentenceContextIncompatible(mention2, ant, dict)) {
                return false;
            }
            if (Rules.entityClusterAllCorefDictionary(mentionCluster, potentialAntecedent, dict, 1, 8)) {
                return true;
            }
            if (Rules.entityCorefDictionary(mention, ant, dict, 2, 2)) {
                return true;
            }
            if (Rules.entityCorefDictionary(mention, ant, dict, 3, 2)) {
                return true;
            }
            if (Rules.entityCorefDictionary(mention, ant, dict, 4, 2)) {
                return true;
            }
        }
        if (this.flags.DO_PRONOUN) {
            boolean mIsPronoun;
            Mention m = mention.predicateNominatives != null && mention.predicateNominatives.contains(mention2) ? mention2 : mention;
            boolean bl = mIsPronoun = m.isPronominal() || dict.allPronouns.contains(m.toString());
            if (mIsPronoun && Rules.entityAttributesAgree(mentionCluster, potentialAntecedent, this.lang)) {
                if (dict.demonymSet.contains(ant.lowercaseNormalizedSpanString()) && dict.notOrganizationPRP.contains(m.headString)) {
                    document.addIncompatible(m, ant);
                    return false;
                }
                if (Rules.entityPersonDisagree(document, mentionCluster, potentialAntecedent, dict)) {
                    document.addIncompatible(m, ant);
                    return false;
                }
                return true;
            }
        }
        if (this.flags.USE_CHINESE_HEAD_MATCH && mention2.headWord == ant.headWord && mention2.insideIn(ant)) {
            if (!document.isCoref(mention2, ant)) {
                System.err.println("error in chinese head match: " + mention2.spanToString() + "\t" + ant.spanToString());
            }
            return true;
        }
        return ret;
    }

    public List<Mention> getOrderedAntecedents(int antecedentSentence, int mySentence, List<Mention> orderedMentions, List<List<Mention>> orderedMentionsBySentence, Mention m1, int m1Position, Map<Integer, CorefCluster> corefClusters, Dictionaries dict) {
        List<Mention> orderedAntecedents = new ArrayList<Mention>();
        if (antecedentSentence == mySentence) {
            orderedAntecedents.addAll(orderedMentions.subList(0, m1Position));
            if (this.flags.DO_PRONOUN && m1.isPronominal()) {
                orderedAntecedents = DeterministicCorefSieve.sortMentionsForPronoun(orderedAntecedents, m1);
            }
            if (dict.relativePronouns.contains(m1.spanToString())) {
                Collections.reverse(orderedAntecedents);
            }
        } else {
            orderedAntecedents.addAll((Collection)orderedMentionsBySentence.get(antecedentSentence));
        }
        return orderedAntecedents;
    }

    private static List<Mention> sortMentionsForPronoun(List<Mention> l, Mention m1) {
        ArrayList<Mention> sorted = new ArrayList();
        Tree tree = m1.contextParseTree;
        Tree current = m1.mentionSubTree;
        if (tree == null || current == null) {
            return l;
        }
        do {
            if (!(current = current.ancestor(1, tree)).label().value().startsWith("S")) continue;
            for (Mention m : l) {
                if (sorted.contains(m) || !current.dominates(m.mentionSubTree)) continue;
                sorted.add(m);
            }
        } while (current.ancestor(1, tree) != null);
        if (l.size() != sorted.size()) {
            sorted = l;
        } else if (!l.equals(sorted)) {
            for (int i = 0; i < l.size(); ++i) {
                Mention ml = l.get(i);
                Mention msorted = (Mention)sorted.get(i);
            }
        }
        return sorted;
    }
}

