/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref.data;

import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeMap;

public class CorefCluster
implements Serializable {
    private static final long serialVersionUID = 8655265337578515592L;
    public final Set<Mention> corefMentions;
    public final int clusterID;
    public final Set<Dictionaries.Number> numbers;
    public final Set<Dictionaries.Gender> genders;
    public final Set<Dictionaries.Animacy> animacies;
    public final Set<String> nerStrings;
    public final Set<String> heads;
    public final Set<String> words;
    protected Mention firstMention;
    public Mention representative;

    public int getClusterID() {
        return this.clusterID;
    }

    public Set<Mention> getCorefMentions() {
        return this.corefMentions;
    }

    public Mention getFirstMention() {
        return this.firstMention;
    }

    public Mention getRepresentativeMention() {
        return this.representative;
    }

    public CorefCluster(int ID) {
        this.clusterID = ID;
        this.corefMentions = Generics.newHashSet();
        this.numbers = EnumSet.noneOf(Dictionaries.Number.class);
        this.genders = EnumSet.noneOf(Dictionaries.Gender.class);
        this.animacies = EnumSet.noneOf(Dictionaries.Animacy.class);
        this.nerStrings = Generics.newHashSet();
        this.heads = Generics.newHashSet();
        this.words = Generics.newHashSet();
        this.firstMention = null;
        this.representative = null;
    }

    public CorefCluster(int ID, Set<Mention> mentions) {
        this(ID);
        this.corefMentions.addAll(mentions);
        ArrayList<Mention> sortedMentions = new ArrayList<Mention>(mentions.size());
        sortedMentions.addAll(mentions);
        Collections.sort(sortedMentions, new CorefChain.MentionComparator());
        if (sortedMentions.size() > 0) {
            this.firstMention = (Mention)sortedMentions.get(0);
            this.representative = (Mention)sortedMentions.get(0);
        }
        for (Mention m : sortedMentions) {
            this.animacies.add(m.animacy);
            this.genders.add(m.gender);
            this.numbers.add(m.number);
            this.nerStrings.add(m.nerString);
            this.heads.add(m.headString);
            if (!m.isPronominal()) {
                for (CoreLabel w : m.originalSpan) {
                    this.words.add(((String)w.get(CoreAnnotations.TextAnnotation.class)).toLowerCase());
                }
            }
            if (m == this.representative || !m.moreRepresentativeThan(this.representative)) continue;
            assert (!this.representative.moreRepresentativeThan(m));
            this.representative = m;
        }
    }

    public static void mergeClusters(CorefCluster to, CorefCluster from) {
        int toID = to.clusterID;
        for (Mention m : from.corefMentions) {
            m.corefClusterID = toID;
        }
        to.numbers.addAll(from.numbers);
        if (to.numbers.size() > 1 && to.numbers.contains((Object)Dictionaries.Number.UNKNOWN)) {
            to.numbers.remove((Object)Dictionaries.Number.UNKNOWN);
        }
        to.genders.addAll(from.genders);
        if (to.genders.size() > 1 && to.genders.contains((Object)Dictionaries.Gender.UNKNOWN)) {
            to.genders.remove((Object)Dictionaries.Gender.UNKNOWN);
        }
        to.animacies.addAll(from.animacies);
        if (to.animacies.size() > 1 && to.animacies.contains((Object)Dictionaries.Animacy.UNKNOWN)) {
            to.animacies.remove((Object)Dictionaries.Animacy.UNKNOWN);
        }
        to.nerStrings.addAll(from.nerStrings);
        if (to.nerStrings.size() > 1 && to.nerStrings.contains("O")) {
            to.nerStrings.remove("O");
        }
        if (to.nerStrings.size() > 1 && to.nerStrings.contains("MISC")) {
            to.nerStrings.remove("MISC");
        }
        to.heads.addAll(from.heads);
        to.corefMentions.addAll(from.corefMentions);
        to.words.addAll(from.words);
        if (from.firstMention.appearEarlierThan(to.firstMention) && !from.firstMention.isPronominal()) {
            assert (!to.firstMention.appearEarlierThan(from.firstMention));
            to.firstMention = from.firstMention;
        }
        if (from.representative.moreRepresentativeThan(to.representative)) {
            to.representative = from.representative;
        }
        Redwood.log("debug-cluster", "merged clusters: " + toID + " += " + from.clusterID);
        to.printCorefCluster();
        from.printCorefCluster();
    }

    public void printCorefCluster() {
        Redwood.log("debug-cluster", "Cluster ID: " + this.clusterID + "\tNumbers: " + this.numbers + "\tGenders: " + this.genders + "\tanimacies: " + this.animacies);
        Redwood.log("debug-cluster", "NE: " + this.nerStrings + "\tfirst Mention's ID: " + this.firstMention.mentionID + "\tHeads: " + this.heads + "\twords: " + this.words);
        TreeMap<Integer, Mention> forSortedPrint = new TreeMap<Integer, Mention>();
        for (Mention m : this.corefMentions) {
            forSortedPrint.put(m.mentionID, m);
        }
        for (Mention m : forSortedPrint.values()) {
            String rep;
            String string = rep = this.representative == m ? "*" : "";
            if (m.goldCorefClusterID == -1) {
                Redwood.log("debug-cluster", rep + "mention-> id:" + m.mentionID + "\toriginalRef: " + m.originalRef + "\t" + m.spanToString() + "\tsentNum: " + m.sentNum + "\tstartIndex: " + m.startIndex + "\tType: " + (Object)((Object)m.mentionType) + "\tNER: " + m.nerString);
                continue;
            }
            Redwood.log("debug-cluster", rep + "mention-> id:" + m.mentionID + "\toriginalClusterID: " + m.goldCorefClusterID + "\t" + m.spanToString() + "\tsentNum: " + m.sentNum + "\tstartIndex: " + m.startIndex + "\toriginalRef: " + m.originalRef + "\tType: " + (Object)((Object)m.mentionType) + "\tNER: " + m.nerString);
        }
    }

    public boolean isSinglePronounCluster(Dictionaries dict) {
        if (this.corefMentions.size() > 1) {
            return false;
        }
        for (Mention m : this.corefMentions) {
            if (!m.isPronominal() && !dict.allPronouns.contains(m.spanToString().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.corefMentions.toString() + "=" + this.clusterID;
    }
}

