/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.hcoref;

import edu.stanford.nlp.hcoref.CorefDocMaker;
import edu.stanford.nlp.hcoref.CorefPrinter;
import edu.stanford.nlp.hcoref.CorefProperties;
import edu.stanford.nlp.hcoref.Scorer;
import edu.stanford.nlp.hcoref.data.CorefChain;
import edu.stanford.nlp.hcoref.data.CorefCluster;
import edu.stanford.nlp.hcoref.data.Dictionaries;
import edu.stanford.nlp.hcoref.data.Document;
import edu.stanford.nlp.hcoref.data.Mention;
import edu.stanford.nlp.hcoref.sieve.Sieve;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class CorefSystem {
    public Properties props;
    public List<Sieve> sieves;
    public Dictionaries dictionaries;
    public CorefDocMaker docMaker = null;

    public CorefSystem(Properties props) throws Exception {
        this.props = props;
        this.sieves = Sieve.loadSieves(props);
        for (Sieve sieve : this.sieves) {
            if (sieve.classifierType == Sieve.ClassifierType.RULE || !CorefProperties.useWordEmbedding(props, sieve.sievename)) continue;
            props.setProperty("hcoref.loadWordEmbedding", "true");
        }
        this.dictionaries = new Dictionaries(props);
        this.docMaker = new CorefDocMaker(props, this.dictionaries);
    }

    public Dictionaries dictionaries() {
        return this.dictionaries;
    }

    public static void runCoref(String[] args) throws Exception {
        Document document;
        Redwood.hideChannelsEverywhere("debug-cluster", "debug-mention", "debug-preprocessor", "debug-docreader", "debug-mergethres", "debug-featureselection", "debug-md");
        Properties props = StringUtils.argsToProperties(args);
        int nThreads = CorefProperties.getThreadCounts(props);
        String timeStamp = Calendar.getInstance().getTime().toString().replaceAll("\\s", "-").replaceAll(":", "-");
        props.put("hcoref.path.input", CorefProperties.getPathEvalData(props));
        Logger logger = Logger.getLogger(CorefSystem.class.getName());
        if (props.containsKey("hcoref.logFile")) {
            File logFile = new File(props.getProperty("hcoref.logFile"));
            RedwoodConfiguration.current().handlers(RedwoodConfiguration.Handlers.file(logFile)).apply();
            Redwood.log("Starting coref log");
        }
        System.err.println(props.toString());
        if (CorefProperties.checkMemory(props)) {
            CorefSystem.checkMemoryUsage();
        }
        CorefSystem cs = new CorefSystem(props);
        String goldOutput = null;
        String beforeCorefOutput = null;
        String afterCorefOutput = null;
        PrintWriter writerGold = null;
        PrintWriter writerBeforeCoref = null;
        PrintWriter writerAfterCoref = null;
        if (CorefProperties.doScore(props)) {
            String pathOutput = CorefProperties.getPathOutput(props);
            new File(pathOutput).mkdir();
            goldOutput = pathOutput + "output-" + timeStamp + ".gold.txt";
            beforeCorefOutput = pathOutput + "output-" + timeStamp + ".predicted.txt";
            afterCorefOutput = pathOutput + "output-" + timeStamp + ".coref.predicted.txt";
            writerGold = new PrintWriter(new FileOutputStream(goldOutput));
            writerBeforeCoref = new PrintWriter(new FileOutputStream(beforeCorefOutput));
            writerAfterCoref = new PrintWriter(new FileOutputStream(afterCorefOutput));
        }
        MulticoreWrapper<Pair<Document, CorefSystem>, StringBuilder[]> wrapper = new MulticoreWrapper<Pair<Document, CorefSystem>, StringBuilder[]>(nThreads, new ThreadsafeProcessor<Pair<Document, CorefSystem>, StringBuilder[]>(){

            @Override
            public StringBuilder[] process(Pair<Document, CorefSystem> input) {
                try {
                    Document document = (Document)input.first;
                    CorefSystem cs = (CorefSystem)input.second;
                    StringBuilder[] outputs = new StringBuilder[4];
                    cs.coref(document, outputs);
                    return outputs;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public ThreadsafeProcessor<Pair<Document, CorefSystem>, StringBuilder[]> newInstance() {
                return this;
            }
        });
        Date startTime = null;
        if (CorefProperties.checkTime(props)) {
            startTime = new Date();
            System.err.printf("END-TO-END COREF Start time: %s\n", startTime);
        }
        int docCnt = 0;
        while ((document = cs.docMaker.nextDoc()) != null) {
            wrapper.put(Pair.makePair(document, cs));
            docCnt = CorefSystem.logOutput(wrapper, writerGold, writerBeforeCoref, writerAfterCoref, docCnt);
        }
        wrapper.join();
        docCnt = CorefSystem.logOutput(wrapper, writerGold, writerBeforeCoref, writerAfterCoref, docCnt);
        writerGold.close();
        writerBeforeCoref.close();
        writerAfterCoref.close();
        if (CorefProperties.checkTime(props)) {
            System.err.printf("END-TO-END COREF Elapsed time: %.3f seconds\n", Float.valueOf((float)(new Date().getTime() - startTime.getTime()) / 1000.0f));
        }
        if (CorefProperties.checkMemory(props)) {
            CorefSystem.checkMemoryUsage();
        }
        if (CorefProperties.doScore(props)) {
            String summary = Scorer.getEvalSummary(CorefProperties.getPathScorer(props), goldOutput, beforeCorefOutput);
            CorefPrinter.printScoreSummary(summary, logger, false);
            summary = Scorer.getEvalSummary(CorefProperties.getPathScorer(props), goldOutput, afterCorefOutput);
            CorefPrinter.printScoreSummary(summary, logger, true);
            CorefPrinter.printFinalConllScore(summary);
        }
    }

    private static int logOutput(MulticoreWrapper<Pair<Document, CorefSystem>, StringBuilder[]> wrapper, PrintWriter writerGold, PrintWriter writerBeforeCoref, PrintWriter writerAfterCoref, int docCnt) {
        while (wrapper.peek()) {
            StringBuilder[] output = wrapper.poll();
            writerGold.print(output[0]);
            writerBeforeCoref.print(output[1]);
            writerAfterCoref.print(output[2]);
            System.err.println(output[3]);
            if (docCnt++ % 10 != 0) continue;
            System.err.println(docCnt + " document(s) processed");
        }
        return docCnt;
    }

    public Map<Integer, CorefChain> coref(Document document, StringBuilder[] output) throws Exception {
        if (CorefProperties.printMDLog(this.props)) {
            Redwood.log(CorefPrinter.printMentionDetectionLog(document));
        }
        if (CorefProperties.doScore(this.props)) {
            output[0] = new StringBuilder().append(CorefPrinter.printConllOutput(document, true));
            output[1] = new StringBuilder().append(CorefPrinter.printConllOutput(document, false));
        }
        output[3] = new StringBuilder();
        for (Sieve sieve : this.sieves) {
            output[3].append(sieve.resolveMention(document, this.dictionaries, this.props));
        }
        if (CorefProperties.doPostProcessing(this.props)) {
            this.postProcessing(document);
        }
        if (CorefProperties.doScore(this.props)) {
            output[2] = new StringBuilder().append(CorefPrinter.printConllOutput(document, false, true));
        }
        return this.makeCorefOutput(document);
    }

    public Map<Integer, CorefChain> coref(Document document) throws Exception {
        return this.coref(document, new StringBuilder[4]);
    }

    public Map<Integer, CorefChain> coref(Annotation anno) throws Exception {
        return this.coref(this.docMaker.makeDocument(anno));
    }

    public Map<Integer, CorefChain> makeCorefOutput(Document document) {
        Map<Integer, CorefChain> result = Generics.newHashMap();
        for (CorefCluster c : document.corefClusters.values()) {
            result.put(c.clusterID, new CorefChain(c, document.positions));
        }
        return result;
    }

    public void postProcessing(Document document) {
        Set<Mention> removeSet = Generics.newHashSet();
        Set<Integer> removeClusterSet = Generics.newHashSet();
        for (CorefCluster c : document.corefClusters.values()) {
            Set<Mention> removeMentions = Generics.newHashSet();
            for (Mention m : c.getCorefMentions()) {
                if (!(m.appositions != null && m.appositions.size() > 0 || m.predicateNominatives != null && m.predicateNominatives.size() > 0) && (m.relativePronouns == null || m.relativePronouns.size() <= 0)) continue;
                removeMentions.add(m);
                removeSet.add(m);
                m.corefClusterID = m.mentionID;
            }
            c.corefMentions.removeAll(removeMentions);
            if (c.getCorefMentions().size() != 1) continue;
            removeClusterSet.add(c.clusterID);
        }
        Iterator<CorefCluster> iterator = removeClusterSet.iterator();
        while (iterator.hasNext()) {
            int removeId = (Integer)((Object)iterator.next());
            document.corefClusters.remove(removeId);
        }
        for (Mention m : removeSet) {
            document.positions.remove(m);
        }
    }

    private static void checkMemoryUsage() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long memory = runtime.totalMemory() - runtime.freeMemory();
        System.err.println("USED MEMORY (bytes): " + memory);
    }

    public static List<List<Mention>> filterMentionsWithSingletonClusters(Document document, List<List<Mention>> mentions) {
        ArrayList<List<Mention>> res = new ArrayList<List<Mention>>(mentions.size());
        for (List<Mention> ml : mentions) {
            ArrayList<Mention> filtered = new ArrayList<Mention>();
            for (Mention m : ml) {
                CorefCluster cluster = document.corefClusters.get(m.corefClusterID);
                if (cluster == null || cluster.getCorefMentions().size() <= 1) continue;
                filtered.add(m);
            }
            res.add(filtered);
        }
        return res;
    }

    public static void main(String[] args) throws Exception {
        Date startTime = new Date();
        System.err.printf("Start time: %s\n", startTime);
        CorefSystem.runCoref(args);
        System.err.printf("Elapsed time: %.3f seconds\n", Float.valueOf((float)(new Date().getTime() - startTime.getTime()) / 1000.0f));
    }
}

