/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.memcached.config;

import de.flapdoodle.embed.memcached.Command;
import de.flapdoodle.embed.memcached.config.SupportConfig;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.runtime.Network;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class MemcachedConfig
extends ExecutableProcessConfig {
    protected final Net network;
    protected final Storage storage;
    protected final Timeout timeout;

    public static MemcachedConfig getConfigInstance(IVersion version, Net network) {
        return new MemcachedConfig(version, network, new Storage(), new Timeout());
    }

    public MemcachedConfig(IVersion version, Net networt, Storage storage, Timeout timeout) {
        super(version, (ISupportConfig)new SupportConfig(Command.MemcacheD));
        this.network = networt;
        this.timeout = timeout;
        this.storage = storage;
    }

    public MemcachedConfig(IVersion version) throws UnknownHostException, IOException {
        this(version, new Net(), new Storage(), new Timeout());
    }

    public MemcachedConfig(IVersion version, int port) {
        this(version, new Net(port), new Storage(), new Timeout());
    }

    public Net net() {
        return this.network;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public static class Timeout {
        private final long startupTimeout;

        public Timeout() {
            this(5000L);
        }

        public Timeout(long startupTimeout) {
            this.startupTimeout = startupTimeout;
        }

        public long getStartupTimeout() {
            return this.startupTimeout;
        }
    }

    public static class Net {
        private final int port;

        public Net() throws UnknownHostException, IOException {
            this(Network.getFreeServerPort());
        }

        public Net(int port) {
            this.port = port;
        }

        public int getPort() {
            return this.port;
        }

        public InetAddress getServerAddress() throws UnknownHostException {
            return Network.getLocalHost();
        }
    }

    public static class Storage {
        private final String pidFile;

        public Storage() {
            this(null);
        }

        public Storage(String pidFile) {
            this.pidFile = pidFile;
        }

        public String getPidFile() {
            return this.pidFile;
        }
    }
}

