/*
 * Decompiled with CFR 0.152.
 */
package com.mg.swagger.controller.param;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class HttpRequestParam {
    private String url;
    private String method;
    private String header;
    private String form;
    private String body;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getForm() {
        return this.form;
    }

    public void setForm(String form) {
        this.form = form;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Map<String, String> getHeaderMap() {
        if (StringUtils.isBlank((String)this.header)) {
            return null;
        }
        Map headerMap = (Map)JSON.parseObject((String)this.header, (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
        return headerMap;
    }

    public Map<String, Object> getFormMap() {
        if (StringUtils.isBlank((String)this.form)) {
            return null;
        }
        Map formMap = (Map)JSON.parseObject((String)this.form, (TypeReference)new TypeReference<HashMap<String, Object>>(){}, (Feature[])new Feature[0]);
        return formMap;
    }

    public void createHttpRequest(HttpRequest request) {
        Map<String, Object> formMap;
        Map<String, String> headerMap = this.getHeaderMap();
        if (headerMap != null) {
            request.addHeaders(headerMap);
        }
        if ((formMap = this.getFormMap()) != null) {
            request.form(formMap);
        }
        if (StringUtils.isNotBlank((String)this.body) && request.getMethod() != Method.GET) {
            request.body(this.body);
        }
    }

    public HttpRequest createRequest() {
        if ("get".equalsIgnoreCase(this.method)) {
            return this.get();
        }
        if ("post".equalsIgnoreCase(this.method)) {
            return this.post();
        }
        if ("head".equalsIgnoreCase(this.method)) {
            return this.head();
        }
        if ("options".equalsIgnoreCase(this.method)) {
            return this.options();
        }
        if ("put".equalsIgnoreCase(this.method)) {
            return this.put();
        }
        if ("patch".equalsIgnoreCase(this.method)) {
            return this.patch();
        }
        if ("delete".equalsIgnoreCase(this.method)) {
            return this.delete();
        }
        if ("trace".equalsIgnoreCase(this.method)) {
            return this.trace();
        }
        return this.get();
    }

    public HttpRequest post() {
        HttpRequest request = HttpRequest.post((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest get() {
        HttpRequest request = HttpRequest.get((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest head() {
        HttpRequest request = HttpRequest.head((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest options() {
        HttpRequest request = HttpRequest.options((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest put() {
        HttpRequest request = HttpRequest.put((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest patch() {
        HttpRequest request = HttpRequest.patch((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest delete() {
        HttpRequest request = HttpRequest.delete((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public HttpRequest trace() {
        HttpRequest request = HttpRequest.trace((String)this.getUrl());
        this.createHttpRequest(request);
        return request;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

