/*
 * Decompiled with CFR 0.152.
 */
package com.verhas.licensor;

import com.verhas.utils.Sugar;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.jcajce.JcaPGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

public class License {
    protected Properties licenseProperties = null;
    private boolean verified = false;
    private PGPSecretKey key = null;
    private int hashAlgorithm = 10;
    private byte[] publicKeyRing = null;
    private Long decodeKeyId = null;

    public void setFeature(String key, String value) {
        if (this.licenseProperties == null) {
            this.licenseProperties = new Properties();
        }
        this.licenseProperties.put(key, value);
    }

    public String getFeature(String key) {
        String feature = this.licenseProperties != null && this.licenseProperties.containsKey(key) ? this.licenseProperties.getProperty(key) : null;
        return feature;
    }

    public void setLicense(InputStream is) throws IOException {
        this.verified = false;
        this.licenseProperties = new Properties();
        this.licenseProperties.load(is);
    }

    public License setLicense(File file) throws IOException {
        this.setLicense(new FileInputStream(file));
        return this;
    }

    public void setLicense(String licenseString) throws IOException {
        this.setLicense(new ByteArrayInputStream(licenseString.getBytes()));
    }

    public String getLicenseString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.licenseProperties != null) {
                this.licenseProperties.store(baos, "-- license file");
            }
            baos.close();
            return new String(baos.toByteArray());
        }
        catch (IOException ex) {
            return "";
        }
    }

    public void dumpLicense(String fileName) throws IOException {
        this.dumpLicense(new File(fileName));
    }

    public void dumpLicense(File file) throws IOException {
        this.dumpLicense(new FileOutputStream(file));
    }

    public void dumpLicense(OutputStream os) throws IOException {
        if (this.licenseProperties != null) {
            this.licenseProperties.store(os, "");
        }
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setHashAlgorithm(int hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public License loadKey(String fn, String keyId) throws IOException, PGPException {
        this.loadKey(new File(fn), keyId);
        return this;
    }

    public void loadKeyRingFromResource(String resourceName, byte[] digest) throws IOException {
        this.loadKeyRing(this.getClass().getClassLoader().getResourceAsStream(resourceName), digest);
    }

    public License loadKeyRing(String fileName, byte[] digest) throws FileNotFoundException, IOException {
        this.loadKeyRing(new File(fileName), digest);
        return this;
    }

    public License loadKeyRing(File file, byte[] digest) throws FileNotFoundException, IOException {
        this.loadKeyRing(new FileInputStream(file), digest);
        return this;
    }

    public License loadKeyRing(InputStream in, byte[] digest) throws IOException {
        int ch;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0) {
            baos.write(ch);
        }
        this.publicKeyRing = baos.toByteArray();
        if (digest != null) {
            byte[] calculatedDigest = this.calculatePublicKeyRingDigest();
            for (int i = 0; i < calculatedDigest.length; ++i) {
                if (calculatedDigest[i] == digest[i]) continue;
                this.publicKeyRing = null;
                throw new IllegalArgumentException("Key ring digest does not match.");
            }
        }
        return this;
    }

    public byte[] calculatePublicKeyRingDigest() {
        SHA512Digest dig = new SHA512Digest();
        dig.reset();
        dig.update(this.publicKeyRing, 0, this.publicKeyRing.length);
        byte[] digest = new byte[dig.getDigestSize()];
        dig.doFinal(digest, 0);
        return digest;
    }

    private static int convertByteToInt(byte b) {
        return b & 0xFF;
    }

    public String dumpPublicKeyRingDigest() {
        byte[] calculatedDigest = this.calculatePublicKeyRingDigest();
        String retval = "byte [] digest = new byte[] {\n";
        for (int i = 0; i < calculatedDigest.length; ++i) {
            int intVal = License.convertByteToInt(calculatedDigest[i]);
            retval = retval + String.format("(byte)0x%02X, ", intVal);
            if (i % 8 != 0) continue;
            retval = retval + "\n";
        }
        retval = retval + "\n};\n";
        return retval;
    }

    public License loadKey(File fin, String userId) throws IOException, PGPException {
        this.loadKey(new FileInputStream(fin), userId);
        return this;
    }

    private boolean keyIsAppropriate(String userId, String keyUserId, PGPSecretKey k) {
        return k.isSigningKey() && (userId == null || userId.equals(keyUserId));
    }

    public License loadKey(InputStream inputStream, String userId) throws IOException, PGPException {
        InputStream decoderInputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
        JcaPGPSecretKeyRingCollection pgpSec = new JcaPGPSecretKeyRingCollection(decoderInputStream);
        this.key = null;
        for (PGPSecretKeyRing kRing : Sugar.in(pgpSec.getKeyRings())) {
            for (PGPSecretKey k : Sugar.in(kRing.getSecretKeys())) {
                for (String keyUserId : Sugar.in(k.getUserIDs())) {
                    if (!this.keyIsAppropriate(userId, keyUserId, k)) continue;
                    this.key = k;
                    return this;
                }
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }

    private PGPSignatureGenerator createPGPSignatureGenerator(char[] keyPassPhrase) throws PGPException {
        JcaPGPContentSignerBuilder csBuilder = new JcaPGPContentSignerBuilder(this.key.getPublicKey().getAlgorithm(), this.hashAlgorithm);
        PGPSignatureGenerator generator = new PGPSignatureGenerator((PGPContentSignerBuilder)csBuilder);
        PGPPrivateKey privateKey = this.extractPGPPrivateKey(keyPassPhrase);
        this.init(generator, privateKey);
        return generator;
    }

    private PGPPrivateKey extractPGPPrivateKey(char[] keyPassPhrase) throws PGPException {
        PGPDigestCalculatorProvider calcProvider = new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build();
        PBESecretKeyDecryptor decryptor = new JcePBESecretKeyDecryptorBuilder(calcProvider).setProvider("BC").build(keyPassPhrase);
        PGPPrivateKey pgpPrivKey = this.key.extractPrivateKey(decryptor);
        return pgpPrivKey;
    }

    private void setHashedSubpackets(PGPSignatureGenerator signatureGenerator) {
        Iterator it = this.key.getPublicKey().getUserIDs();
        if (it.hasNext()) {
            PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
            generator.setSignerUserID(false, (String)it.next());
            signatureGenerator.setHashedSubpackets(generator.generate());
        }
    }

    private void init(PGPSignatureGenerator signatureGenerator, PGPPrivateKey pgpPrivKey) throws PGPException {
        signatureGenerator.init(0, pgpPrivKey);
        this.setHashedSubpackets(signatureGenerator);
    }

    private PGPCompressedDataGenerator createZlibCompressedDataGenerator() {
        return new PGPCompressedDataGenerator(2);
    }

    private void encode(String licensePlain, PGPSignatureGenerator signatureGenerator, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator();
        OutputStream literalDataStream = literalDataGenerator.open(outputStream, 'b', "licenseFileName-Ignored", new Date(), new byte[1024]);
        ByteArrayInputStream fIn = new ByteArrayInputStream(licensePlain.getBytes("utf-8"));
        int ch = 0;
        while ((ch = ((InputStream)fIn).read()) >= 0) {
            literalDataStream.write(ch);
            signatureGenerator.update((byte)ch);
        }
        literalDataGenerator.close();
    }

    public String encodeLicense(String keyPassPhraseString) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, PGPException, SignatureException {
        String licensePlain = this.getLicenseString();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ArmoredOutputStream armoredOutputStream = new ArmoredOutputStream((OutputStream)byteArrayOutputStream);
        PGPSignatureGenerator signatureGenerator = this.createPGPSignatureGenerator(keyPassPhraseString.toCharArray());
        PGPCompressedDataGenerator generator = this.createZlibCompressedDataGenerator();
        BCPGOutputStream outputStream = new BCPGOutputStream(generator.open((OutputStream)armoredOutputStream));
        signatureGenerator.generateOnePassVersion(false).encode((OutputStream)outputStream);
        this.encode(licensePlain, Sugar.using(signatureGenerator), (OutputStream)Sugar.to(outputStream));
        signatureGenerator.generate().encode((OutputStream)outputStream);
        generator.close();
        armoredOutputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public License setLicenseEncoded(String licenseStringEncoded) throws UnsupportedEncodingException, IOException, PGPException {
        this.setLicenseEncoded(new ByteArrayInputStream(licenseStringEncoded.getBytes("utf-8")));
        return this;
    }

    public License setLicenseEncodedFromResource(String resourceName) throws IOException, PGPException {
        this.setLicenseEncoded(License.class.getClassLoader().getResourceAsStream(resourceName));
        return this;
    }

    public License setLicenseEncodedFromFile(String fileName) throws FileNotFoundException, IOException, PGPException {
        this.setLicenseEncoded(new File(fileName));
        return this;
    }

    @Deprecated
    public void setLicenseEncodedFromFile(File file) throws FileNotFoundException, IOException, PGPException {
        this.setLicenseEncoded(file);
    }

    public void setLicenseEncoded(File file) throws FileNotFoundException, IOException, PGPException {
        this.setLicenseEncoded(new FileInputStream(file));
    }

    public Long getDecodeKeyId() {
        return this.decodeKeyId;
    }

    private static void pgpAssertNotNull(Object o) throws PGPException {
        if (o == null) {
            throw new PGPException("can not decode");
        }
    }

    public void setLicenseEncoded(InputStream inputStream) throws IOException, PGPException {
        ByteArrayInputStream keyIn = new ByteArrayInputStream(this.publicKeyRing);
        InputStream decoderInputStream = PGPUtil.getDecoderStream((InputStream)inputStream);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(decoderInputStream);
        PGPCompressedData c1 = (PGPCompressedData)pgpFact.nextObject();
        License.pgpAssertNotNull(c1);
        pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
        PGPOnePassSignatureList p1 = (PGPOnePassSignatureList)pgpFact.nextObject();
        License.pgpAssertNotNull(p1);
        PGPOnePassSignature ops = p1.get(0);
        PGPLiteralData p2 = (PGPLiteralData)pgpFact.nextObject();
        License.pgpAssertNotNull(p2);
        InputStream dIn = p2.getInputStream();
        License.pgpAssertNotNull(dIn);
        BcPGPPublicKeyRingCollection pgpRing = new BcPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn));
        License.pgpAssertNotNull(ops);
        this.decodeKeyId = ops.getKeyID();
        if (this.decodeKeyId == null) {
            this.verified = false;
            this.licenseProperties = null;
        } else {
            PGPPublicKey decodeKey = pgpRing.getPublicKey(this.decodeKeyId.longValue());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int ch;
                JcaPGPContentVerifierBuilderProvider cvBuilder = new JcaPGPContentVerifierBuilderProvider();
                ops.init((PGPContentVerifierBuilderProvider)cvBuilder, decodeKey);
                while ((ch = dIn.read()) >= 0) {
                    ops.update((byte)ch);
                    out.write(ch);
                }
                PGPSignatureList p3 = (PGPSignatureList)pgpFact.nextObject();
                if (ops.verify(p3.get(0))) {
                    this.setLicense(new String(out.toByteArray()));
                    this.verified = true;
                } else {
                    this.verified = false;
                    this.licenseProperties = null;
                }
            }
            catch (Exception e) {
                this.verified = false;
                this.licenseProperties = null;
            }
        }
    }

    public static String fromResource(String resourceName) {
        return License.class.getClassLoader().getResource(resourceName).getFile();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

