/*
 * Decompiled with CFR 0.152.
 */
package sbt.classpath;

import java.io.BufferedInputStream;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import sbt.IO$;
import sbt.Path$;
import sbt.PathFinder;
import sbt.ScalaInstance;
import sbt.Using;
import sbt.Using$;
import sbt.classpath.ClasspathFilter;
import sbt.classpath.FixedResources$class;
import sbt.classpath.NativeCopyConfig;
import sbt.classpath.NativeCopyLoader$class;
import sbt.classpath.RawResources;
import sbt.classpath.RawResources$class;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import xsbti.Launcher;

public final class ClasspathUtilities$ {
    public static final ClasspathUtilities$ MODULE$;
    private ClassLoader rootLoader;
    private ClassLoader xsbtiLoader;
    private final String AppClassPath;
    private final String BootClassPath;
    private volatile byte bitmap$0;

    static {
        new ClasspathUtilities$();
    }

    private ClassLoader rootLoader$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
                this.rootLoader = systemLoader != null ? this.parent$1(systemLoader) : this.parent$1(this.getClass().getClassLoader());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.rootLoader;
        }
    }

    private ClassLoader xsbtiLoader$lzycompute() {
        ClasspathUtilities$ classpathUtilities$ = this;
        synchronized (classpathUtilities$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.xsbtiLoader = Launcher.class.getClassLoader();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.xsbtiLoader;
        }
    }

    public ClassLoader toLoader(PathFinder finder) {
        return this.toLoader(finder, this.rootLoader());
    }

    public ClassLoader toLoader(PathFinder finder, ClassLoader parent) {
        return new URLClassLoader(finder.getURLs(), parent);
    }

    public ClassLoader toLoader(Seq<File> paths) {
        return this.toLoader(paths, this.rootLoader());
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent) {
        return new URLClassLoader(Path$.MODULE$.toURLs(paths), parent);
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap) {
        return new RawResources(paths, parent, resourceMap){
            private final Map resourceMap$2;
            private final Map<String, URL> resourceURL;

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$classpath$RawResources$_setter_$resourceURL_$eq(Map x$1) {
                this.resourceURL = x$1;
            }

            public URL sbt$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public Enumeration sbt$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources$class.findResource(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources$class.findResources(this, s);
            }

            public Map<String, String> resources() {
                return this.resourceMap$2;
            }
            {
                this.resourceMap$2 = resourceMap$2;
                super(Path$.MODULE$.toURLs((Seq<File>)paths$2), parent$3);
                FixedResources$class.$init$(this);
                RawResources$class.$init$(this);
            }
        };
    }

    public ClassLoader toLoader(Seq<File> paths, ClassLoader parent, Map<String, String> resourceMap, File nativeTemp) {
        return new RawResources(paths, parent, resourceMap, nativeTemp){
            private final NativeCopyConfig config;
            private final Map resourceMap$1;
            private final HashMap sbt$classpath$NativeCopyLoader$$mapped;
            private final Map<String, URL> resourceURL;

            public HashMap sbt$classpath$NativeCopyLoader$$mapped() {
                return this.sbt$classpath$NativeCopyLoader$$mapped;
            }

            public void sbt$classpath$NativeCopyLoader$_setter_$sbt$classpath$NativeCopyLoader$$mapped_$eq(HashMap x$1) {
                this.sbt$classpath$NativeCopyLoader$$mapped = x$1;
            }

            public String findLibrary(String name) {
                return NativeCopyLoader$class.findLibrary(this, name);
            }

            public final Map<String, URL> resourceURL() {
                return this.resourceURL;
            }

            public final void sbt$classpath$RawResources$_setter_$resourceURL_$eq(Map x$1) {
                this.resourceURL = x$1;
            }

            public URL sbt$classpath$FixedResources$$super$findResource(String x$1) {
                return super.findResource(x$1);
            }

            public Enumeration sbt$classpath$FixedResources$$super$findResources(String x$1) {
                return super.findResources(x$1);
            }

            public URL findResource(String s) {
                return FixedResources$class.findResource(this, s);
            }

            public Enumeration<URL> findResources(String s) {
                return FixedResources$class.findResources(this, s);
            }

            public Map<String, String> resources() {
                return this.resourceMap$1;
            }

            public NativeCopyConfig config() {
                return this.config;
            }
            {
                this.resourceMap$1 = resourceMap$1;
                super(Path$.MODULE$.toURLs((Seq<File>)paths$1), parent$2);
                FixedResources$class.$init$(this);
                RawResources$class.$init$(this);
                NativeCopyLoader$class.$init$(this);
                this.config = new NativeCopyConfig(nativeTemp$1, (Seq<File>)paths$1, ClasspathUtilities$.MODULE$.javaLibraryPaths());
            }
        };
    }

    public Seq<File> javaLibraryPaths() {
        return IO$.MODULE$.parseClasspath(System.getProperty("java.library.path"));
    }

    public ClassLoader rootLoader() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.rootLoader$lzycompute() : this.rootLoader;
    }

    public ClassLoader xsbtiLoader() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.xsbtiLoader$lzycompute() : this.xsbtiLoader;
    }

    public final String AppClassPath() {
        return "app.class.path";
    }

    public final String BootClassPath() {
        return "boot.class.path";
    }

    public Map<String, String> createClasspathResources(Seq<File> classpath, ScalaInstance instance) {
        return this.createClasspathResources(classpath, (Seq<File>)instance.jars());
    }

    public Map<String, String> createClasspathResources(Seq<File> appPaths, Seq<File> bootPaths) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.make$1("app.class.path", appPaths), this.make$1("boot.class.path", bootPaths)}));
    }

    public ClassLoader filterByClasspath(Seq<File> classpath, ClassLoader loader) {
        return new ClasspathFilter(loader, this.xsbtiLoader(), (Set<File>)classpath.toSet());
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loader(), instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ScalaInstance instance, File nativeTemp) {
        return this.filterByClasspath(classpath, this.makeLoader(classpath, instance.loader(), instance, nativeTemp));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance));
    }

    public ClassLoader makeLoader(Seq<File> classpath, ClassLoader parent, ScalaInstance instance, File nativeTemp) {
        return this.toLoader(classpath, parent, this.createClasspathResources(classpath, instance), nativeTemp);
    }

    public void printSource(Class<?> c) {
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)c.getName()).append((Object)" loader=").append((Object)c.getClassLoader()).append((Object)" location=").append((Object)IO$.MODULE$.classLocationFile(c)).toString());
    }

    public boolean isArchive(File file) {
        return this.isArchive(file, false);
    }

    public boolean isArchive(File file, boolean contentFallback) {
        return file.isFile() && (this.isArchiveName(file.getName()) || contentFallback && this.hasZipContent(file));
    }

    public boolean isArchiveName(String fileName) {
        return fileName.endsWith(".jar") || fileName.endsWith(".zip");
    }

    public boolean hasZipContent(File file) {
        boolean bl;
        try {
            bl = BoxesRunTime.unboxToBoolean(((Using)((Object)Using$.MODULE$.fileInputStream())).apply(file, new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(BufferedInputStream in) {
                    return in.read() == 80 && in.read() == 75 && in.read() == 3 && in.read() == 4;
                }
            }));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public Iterable<File> compilerPlugins(Seq<File> classpath) {
        URLClassLoader loader = new URLClassLoader(Path$.MODULE$.toURLs(classpath));
        return (Iterable)JavaConversions$.MODULE$.enumerationAsScalaIterator(loader.getResources("scalac-plugin.xml")).toList().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<File> apply(URL url) {
                return ClasspathUtilities$.MODULE$.asFile(true, url);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<File> asFile(URL url) {
        return this.asFile(false, url);
    }

    public List<File> asFile(boolean jarOnly, URL url) {
        Nil$ nil$;
        try {
            List list;
            String string;
            String string2 = string = url.getProtocol();
            if (!("file" != null ? !"file".equals(string2) : string2 != null) && !jarOnly) {
                File file = IO$.MODULE$.toFile(url);
                list = Nil$.MODULE$.$colon$colon((Object)file);
            } else {
                String string3 = string;
                if (!("jar" != null ? !"jar".equals(string3) : string3 != null)) {
                    String path = url.getPath();
                    int end = path.indexOf(33);
                    File file = new File(new URI(end == -1 ? path : path.substring(0, end)));
                    list = Nil$.MODULE$.$colon$colon((Object)file);
                } else {
                    list = Nil$.MODULE$;
                }
            }
            nil$ = list;
        }
        catch (Exception exception) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    private final ClassLoader parent$1(ClassLoader loader) {
        ClassLoader p;
        while ((p = loader.getParent()) != null) {
            loader = p;
        }
        return loader;
    }

    private final Tuple2 make$1(String name, Seq paths) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)name), (Object)Path$.MODULE$.makeString((Seq<File>)paths));
    }

    private ClasspathUtilities$() {
        MODULE$ = this;
    }
}

