/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import jline.Terminal;
import sbt.ConsoleLogger;
import sbt.ConsoleLogger$;
import sbt.ConsoleOut;
import sbt.SuppressedTraceContext;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.util.matching.Regex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleLogger$
implements ScalaObject {
    public static final ConsoleLogger$ MODULE$;
    private final boolean formatEnabled;
    private final Function1<SuppressedTraceContext, None$> noSuppressedMessage;
    private final Regex EscapeSequence;

    static {
        new ConsoleLogger$();
    }

    public ConsoleOut systemOut() {
        return this.printStreamOut(System.out);
    }

    public ConsoleOut printStreamOut(PrintStream out$1) {
        return new ConsoleOut(out$1){
            private final PrintStream lockObject;
            private final PrintStream out$1;

            public PrintStream lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                this.out$1.print(s);
            }

            public void println(String s) {
                this.out$1.println(s);
            }

            public void println() {
                this.out$1.println();
            }
            {
                this.out$1 = printStream;
                this.lockObject = printStream;
            }
        };
    }

    public ConsoleOut printWriterOut(PrintWriter out$2) {
        return new ConsoleOut(out$2){
            private final PrintWriter lockObject;
            private final PrintWriter out$2;

            public PrintWriter lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                this.out$2.print(s);
            }

            public void println(String s) {
                this.out$2.println(s);
                this.out$2.flush();
            }

            public void println() {
                this.out$2.println();
                this.out$2.flush();
            }
            {
                this.out$2 = printWriter;
                this.lockObject = printWriter;
            }
        };
    }

    public ConsoleOut bufferedWriterOut(BufferedWriter out$3) {
        return new ConsoleOut(out$3){
            private final BufferedWriter lockObject;
            private final BufferedWriter out$3;

            public BufferedWriter lockObject() {
                return this.lockObject;
            }

            public void print(String s) {
                this.out$3.write(s);
            }

            public void println(String s) {
                this.out$3.write(s);
                this.println();
            }

            public void println() {
                this.out$3.newLine();
                this.out$3.flush();
            }
            {
                this.out$3 = bufferedWriter;
                this.lockObject = bufferedWriter;
            }
        };
    }

    public boolean formatEnabled() {
        return this.formatEnabled;
    }

    /*
     * WARNING - void declaration
     */
    private boolean ansiSupported() {
        void var1_1;
        boolean exceptionResult1 = false;
        try {
            Terminal terminal = Terminal.getTerminal();
            terminal.enableEcho();
            exceptionResult1 = terminal.isANSISupported();
        }
        catch (Exception exception) {
            exceptionResult1 = !this.isWindows();
        }
        return (boolean)var1_1;
    }

    public Function1<SuppressedTraceContext, None$> noSuppressedMessage() {
        return this.noSuppressedMessage;
    }

    private String os() {
        return System.getProperty("os.name");
    }

    private boolean isWindows() {
        return this.os().toLowerCase().indexOf("windows") >= 0;
    }

    public ConsoleLogger apply(PrintStream out) {
        return this.apply(this.printStreamOut(out), this.apply$default$2(), this.apply$default$3(), (Function1<SuppressedTraceContext, Option<String>>)this.apply$default$4());
    }

    public ConsoleLogger apply(PrintWriter out) {
        return this.apply(this.printWriterOut(out), this.apply$default$2(), this.apply$default$3(), (Function1<SuppressedTraceContext, Option<String>>)this.apply$default$4());
    }

    public ConsoleLogger apply(ConsoleOut out, boolean ansiCodesSupported2, boolean useColor, Function1<SuppressedTraceContext, Option<String>> suppressedMessage) {
        return new ConsoleLogger(out, ansiCodesSupported2, useColor, suppressedMessage);
    }

    public Function1 apply$default$4() {
        return this.noSuppressedMessage();
    }

    public boolean apply$default$3() {
        return this.formatEnabled();
    }

    public boolean apply$default$2() {
        return this.formatEnabled();
    }

    public ConsoleOut apply$default$1() {
        return this.systemOut();
    }

    public String stripEscapeSequences(String s) {
        return this.EscapeSequence.pattern().matcher(s).replaceAll("");
    }

    private ConsoleLogger$() {
        MODULE$ = this;
        String value2 = System.getProperty("sbt.log.format");
        this.formatEnabled = value2 == null ? this.ansiSupported() && !Boolean.getBoolean("sbt.log.noformat") : Boolean.parseBoolean(value2);
        this.noSuppressedMessage = new anonfun.1();
        this.EscapeSequence = Predef$.MODULE$.augmentString(new StringBuilder().append((char)27).append((Object)"[^@-~]*[@-~]").toString()).r();
    }
}

