/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters.json;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.db.backends.converters.ValueConverter;
import com.torodb.torod.db.backends.converters.json.BinaryValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.BooleanValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.DateValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.DoubleValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.InstantValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.IntegerValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.LongValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.MongoObjectIdValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.MongoTimestampValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.NullValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.StringValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.TimeValueToJsonConverter;
import com.torodb.torod.db.backends.converters.json.ValueToJsonConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.array.GreenplumValueToArrayConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.json.ArrayValueToJsonConverter;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class GreenplumValueToJsonConverterProvider
implements ValueToJsonConverterProvider {
    private static final long serialVersionUID = 1L;
    private static final EnumSet<ScalarType> UNSUPPORTED_TYPES = EnumSet.noneOf(ScalarType.class);
    private static final Set<ScalarType> SUPPORTED_TYPES = Sets.difference(EnumSet.allOf(ScalarType.class), UNSUPPORTED_TYPES);
    private final Map<ScalarType, ValueConverter> converters = Maps.newEnumMap(ScalarType.class);

    private GreenplumValueToJsonConverterProvider() {
        this.converters.put(ScalarType.ARRAY, (ValueConverter)new ArrayValueToJsonConverter(GreenplumValueToArrayConverterProvider.getInstance()));
        this.converters.put(ScalarType.BOOLEAN, (ValueConverter)new BooleanValueToJsonConverter());
        this.converters.put(ScalarType.DATE, (ValueConverter)new DateValueToJsonConverter());
        this.converters.put(ScalarType.INSTANT, (ValueConverter)new InstantValueToJsonConverter());
        this.converters.put(ScalarType.DOUBLE, (ValueConverter)new DoubleValueToJsonConverter());
        this.converters.put(ScalarType.INTEGER, (ValueConverter)new IntegerValueToJsonConverter());
        this.converters.put(ScalarType.LONG, (ValueConverter)new LongValueToJsonConverter());
        this.converters.put(ScalarType.NULL, (ValueConverter)new NullValueToJsonConverter());
        this.converters.put(ScalarType.STRING, (ValueConverter)new StringValueToJsonConverter());
        this.converters.put(ScalarType.TIME, (ValueConverter)new TimeValueToJsonConverter());
        this.converters.put(ScalarType.MONGO_OBJECT_ID, (ValueConverter)new MongoObjectIdValueToJsonConverter());
        this.converters.put(ScalarType.MONGO_TIMESTAMP, (ValueConverter)new MongoTimestampValueToJsonConverter());
        this.converters.put(ScalarType.BINARY, (ValueConverter)new BinaryValueToJsonConverter());
        Sets.SetView withoutConverter = Sets.difference(this.converters.keySet(), SUPPORTED_TYPES);
        if (!withoutConverter.isEmpty()) {
            throw new AssertionError((Object)("It is not defined how to convert from the following scalar types to json: " + withoutConverter));
        }
    }

    public static GreenplumValueToJsonConverterProvider getInstance() {
        return ValueToJsonConverterProviderHolder.INSTANCE;
    }

    @Nonnull
    public ValueConverter getConverter(ScalarType valueType) {
        ValueConverter converter = this.converters.get(valueType);
        if (converter == null) {
            throw new AssertionError((Object)("There is no converter that converts elements of type " + valueType));
        }
        return converter;
    }

    private Object readResolve() {
        return GreenplumValueToJsonConverterProvider.getInstance();
    }

    private static class ValueToJsonConverterProviderHolder {
        private static final GreenplumValueToJsonConverterProvider INSTANCE = new GreenplumValueToJsonConverterProvider();

        private ValueToJsonConverterProviderHolder() {
        }
    }
}

