/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters.jooq;

import com.google.common.collect.Sets;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.db.backends.converters.jooq.BinaryValueConverter;
import com.torodb.torod.db.backends.converters.jooq.BooleanValueConverter;
import com.torodb.torod.db.backends.converters.jooq.DataTypeForScalar;
import com.torodb.torod.db.backends.converters.jooq.DateValueConverter;
import com.torodb.torod.db.backends.converters.jooq.DoubleValueConverter;
import com.torodb.torod.db.backends.converters.jooq.InstantValueConverter;
import com.torodb.torod.db.backends.converters.jooq.IntegerValueConverter;
import com.torodb.torod.db.backends.converters.jooq.LongValueConverter;
import com.torodb.torod.db.backends.converters.jooq.MongoObjectIdValueConverter;
import com.torodb.torod.db.backends.converters.jooq.MongoTimestampValueConverter;
import com.torodb.torod.db.backends.converters.jooq.NullValueConverter;
import com.torodb.torod.db.backends.converters.jooq.StringValueConverter;
import com.torodb.torod.db.backends.converters.jooq.TimeValueConverter;
import com.torodb.torod.db.backends.converters.jooq.ValueToJooqDataTypeProvider;
import com.torodb.torod.db.backends.greenplum.converters.jooq.ArrayValueConverter;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;

public class GreenplumValueToJooqDataTypeProvider
implements ValueToJooqDataTypeProvider {
    private static final long serialVersionUID = 1L;
    private static final EnumSet<ScalarType> UNSUPPORTED_TYPES = EnumSet.noneOf(ScalarType.class);
    private static final Set<ScalarType> SUPPORTED_TYPES = Sets.difference(EnumSet.allOf(ScalarType.class), UNSUPPORTED_TYPES);
    private static final EnumMap<ScalarType, DataTypeForScalar<?>> dataTypes = new EnumMap(ScalarType.class);

    public DataTypeForScalar<?> getDataType(ScalarType type) {
        DataTypeForScalar<?> dataType = dataTypes.get(type);
        if (dataType == null) {
            throw new IllegalArgumentException("It is not defined how to map elements of type " + type + " to SQL");
        }
        return dataType;
    }

    public static GreenplumValueToJooqDataTypeProvider getInstance() {
        return ValueToJooqDataTypeProviderHolder.INSTANCE;
    }

    private Object readResolve() {
        return GreenplumValueToJooqDataTypeProvider.getInstance();
    }

    static {
        dataTypes.put(ScalarType.ARRAY, ArrayValueConverter.TYPE);
        dataTypes.put(ScalarType.BOOLEAN, BooleanValueConverter.TYPE);
        dataTypes.put(ScalarType.DOUBLE, DoubleValueConverter.TYPE);
        dataTypes.put(ScalarType.INTEGER, IntegerValueConverter.TYPE);
        dataTypes.put(ScalarType.LONG, LongValueConverter.TYPE);
        dataTypes.put(ScalarType.NULL, NullValueConverter.TYPE);
        dataTypes.put(ScalarType.STRING, StringValueConverter.TYPE);
        dataTypes.put(ScalarType.DATE, DateValueConverter.TYPE);
        dataTypes.put(ScalarType.INSTANT, InstantValueConverter.TYPE);
        dataTypes.put(ScalarType.TIME, TimeValueConverter.TYPE);
        dataTypes.put(ScalarType.MONGO_OBJECT_ID, MongoObjectIdValueConverter.TYPE);
        dataTypes.put(ScalarType.MONGO_TIMESTAMP, MongoTimestampValueConverter.TYPE);
        dataTypes.put(ScalarType.BINARY, BinaryValueConverter.TYPE);
        Sets.SetView withoutConverter = Sets.difference(dataTypes.keySet(), SUPPORTED_TYPES);
        if (!withoutConverter.isEmpty()) {
            throw new AssertionError((Object)("It is not defined how to convert from the following scalar types to json: " + withoutConverter));
        }
    }

    private static class ValueToJooqDataTypeProviderHolder {
        private static final GreenplumValueToJooqDataTypeProvider INSTANCE = new GreenplumValueToJooqDataTypeProvider();

        private ValueToJooqDataTypeProviderHolder() {
        }
    }
}

