/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters.jooq;

import com.google.common.collect.Sets;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.core.subdocument.values.ScalarValue;
import com.torodb.torod.db.backends.converters.jooq.BinaryValueConverter;
import com.torodb.torod.db.backends.converters.jooq.BooleanValueConverter;
import com.torodb.torod.db.backends.converters.jooq.DateValueConverter;
import com.torodb.torod.db.backends.converters.jooq.DoubleValueConverter;
import com.torodb.torod.db.backends.converters.jooq.InstantValueConverter;
import com.torodb.torod.db.backends.converters.jooq.IntegerValueConverter;
import com.torodb.torod.db.backends.converters.jooq.LongValueConverter;
import com.torodb.torod.db.backends.converters.jooq.MongoObjectIdValueConverter;
import com.torodb.torod.db.backends.converters.jooq.MongoTimestampValueConverter;
import com.torodb.torod.db.backends.converters.jooq.NullValueConverter;
import com.torodb.torod.db.backends.converters.jooq.StringValueConverter;
import com.torodb.torod.db.backends.converters.jooq.SubdocValueConverter;
import com.torodb.torod.db.backends.converters.jooq.TimeValueConverter;
import com.torodb.torod.db.backends.converters.jooq.ValueToJooqConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.array.GreenplumValueToArrayConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.jooq.ArrayValueConverter;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;

public class GreenplumValueToJooqConverterProvider
implements ValueToJooqConverterProvider {
    private static final long serialVersionUID = 1L;
    private static final EnumSet<ScalarType> UNSUPPORTED_TYPES = EnumSet.noneOf(ScalarType.class);
    private static final Set<ScalarType> SUPPORTED_TYPES = Sets.difference(EnumSet.allOf(ScalarType.class), UNSUPPORTED_TYPES);
    private static final EnumMap<ScalarType, SubdocValueConverter> converters = new EnumMap(ScalarType.class);

    public SubdocValueConverter<?, ? extends ScalarValue<? extends Serializable>> getConverter(ScalarType type) {
        SubdocValueConverter converter = converters.get(type);
        if (converter == null) {
            throw new IllegalArgumentException("It is not defined how to map elements of type " + type + " to SQL");
        }
        return converter;
    }

    public static GreenplumValueToJooqConverterProvider getInstance() {
        return ValueToJooqConverterProviderHolder.INSTANCE;
    }

    private Object readResolve() {
        return GreenplumValueToJooqConverterProvider.getInstance();
    }

    static {
        converters.put(ScalarType.ARRAY, (SubdocValueConverter)new ArrayValueConverter(GreenplumValueToArrayConverterProvider.getInstance()));
        converters.put(ScalarType.BOOLEAN, (SubdocValueConverter)new BooleanValueConverter());
        converters.put(ScalarType.DOUBLE, (SubdocValueConverter)new DoubleValueConverter());
        converters.put(ScalarType.INTEGER, (SubdocValueConverter)new IntegerValueConverter());
        converters.put(ScalarType.LONG, (SubdocValueConverter)new LongValueConverter());
        converters.put(ScalarType.NULL, (SubdocValueConverter)new NullValueConverter());
        converters.put(ScalarType.STRING, (SubdocValueConverter)new StringValueConverter());
        converters.put(ScalarType.DATE, (SubdocValueConverter)new DateValueConverter());
        converters.put(ScalarType.INSTANT, (SubdocValueConverter)new InstantValueConverter());
        converters.put(ScalarType.TIME, (SubdocValueConverter)new TimeValueConverter());
        converters.put(ScalarType.MONGO_OBJECT_ID, (SubdocValueConverter)new MongoObjectIdValueConverter());
        converters.put(ScalarType.MONGO_TIMESTAMP, (SubdocValueConverter)new MongoTimestampValueConverter());
        converters.put(ScalarType.BINARY, (SubdocValueConverter)new BinaryValueConverter());
        Sets.SetView withoutConverter = Sets.difference(converters.keySet(), SUPPORTED_TYPES);
        if (!withoutConverter.isEmpty()) {
            throw new AssertionError((Object)("It is not defined how to convert from the following scalar types to json: " + withoutConverter));
        }
    }

    private static class ValueToJooqConverterProviderHolder {
        private static final GreenplumValueToJooqConverterProvider INSTANCE = new GreenplumValueToJooqConverterProvider();

        private ValueToJooqConverterProviderHolder() {
        }
    }
}

