/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters.array;

import com.google.common.collect.Maps;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.core.subdocument.values.ScalarArray;
import com.torodb.torod.core.subdocument.values.ScalarBinary;
import com.torodb.torod.core.subdocument.values.ScalarBoolean;
import com.torodb.torod.core.subdocument.values.ScalarDate;
import com.torodb.torod.core.subdocument.values.ScalarDouble;
import com.torodb.torod.core.subdocument.values.ScalarInstant;
import com.torodb.torod.core.subdocument.values.ScalarInteger;
import com.torodb.torod.core.subdocument.values.ScalarLong;
import com.torodb.torod.core.subdocument.values.ScalarMongoObjectId;
import com.torodb.torod.core.subdocument.values.ScalarMongoTimestamp;
import com.torodb.torod.core.subdocument.values.ScalarNull;
import com.torodb.torod.core.subdocument.values.ScalarString;
import com.torodb.torod.core.subdocument.values.ScalarTime;
import com.torodb.torod.db.backends.converters.array.ArrayConverter;
import com.torodb.torod.db.backends.converters.array.ValueToArrayDataTypeProvider;
import com.torodb.torod.db.backends.converters.jooq.ArrayToJooqConverter;
import com.torodb.torod.db.backends.greenplum.converters.array.GreenplumValueToArrayConverterProvider;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jooq.DataType;

public class GreenplumValueToArrayDataTypeProvider
implements ValueToArrayDataTypeProvider {
    private static final long serialVersionUID = 1L;
    private final Map<ScalarType, DataType<?>> converters;

    private GreenplumValueToArrayDataTypeProvider() {
        GreenplumValueToArrayConverterProvider greenplumValueToArrayConverterProvider = GreenplumValueToArrayConverterProvider.getInstance();
        this.converters = Maps.newEnumMap(ScalarType.class);
        this.converters.put(ScalarType.ARRAY, ArrayToJooqConverter.fromScalarValue(ScalarArray.class, greenplumValueToArrayConverterProvider.getArrayConverter(), (String)"json"));
        this.converters.put(ScalarType.BOOLEAN, ArrayToJooqConverter.fromScalarValue(ScalarBoolean.class, greenplumValueToArrayConverterProvider.getBooleanConverter(), (String)"json"));
        this.converters.put(ScalarType.DATE, ArrayToJooqConverter.fromScalarValue(ScalarDate.class, greenplumValueToArrayConverterProvider.getDateConverter(), (String)"json"));
        this.converters.put(ScalarType.INSTANT, ArrayToJooqConverter.fromScalarValue(ScalarInstant.class, greenplumValueToArrayConverterProvider.getInstantConverter(), (String)"json"));
        this.converters.put(ScalarType.DOUBLE, ArrayToJooqConverter.fromScalarValue(ScalarDouble.class, (ArrayConverter)greenplumValueToArrayConverterProvider.getDoubleConverter(), (String)"json"));
        this.converters.put(ScalarType.INTEGER, ArrayToJooqConverter.fromScalarValue(ScalarInteger.class, greenplumValueToArrayConverterProvider.getIntegerConverter(), (String)"json"));
        this.converters.put(ScalarType.LONG, ArrayToJooqConverter.fromScalarValue(ScalarLong.class, greenplumValueToArrayConverterProvider.getLongConverter(), (String)"json"));
        this.converters.put(ScalarType.NULL, ArrayToJooqConverter.fromScalarValue(ScalarNull.class, greenplumValueToArrayConverterProvider.getNullConverter(), (String)"json"));
        this.converters.put(ScalarType.STRING, ArrayToJooqConverter.fromScalarValue(ScalarString.class, greenplumValueToArrayConverterProvider.getStringConverter(), (String)"json"));
        this.converters.put(ScalarType.TIME, ArrayToJooqConverter.fromScalarValue(ScalarTime.class, greenplumValueToArrayConverterProvider.getTimeConverter(), (String)"json"));
        this.converters.put(ScalarType.MONGO_OBJECT_ID, ArrayToJooqConverter.fromScalarValue(ScalarMongoObjectId.class, greenplumValueToArrayConverterProvider.getMongoObjectIdConverter(), (String)"json"));
        this.converters.put(ScalarType.MONGO_TIMESTAMP, ArrayToJooqConverter.fromScalarValue(ScalarMongoTimestamp.class, (ArrayConverter)greenplumValueToArrayConverterProvider.getMongoTimestampConverter(), (String)"json"));
        this.converters.put(ScalarType.BINARY, ArrayToJooqConverter.fromScalarValue(ScalarBinary.class, greenplumValueToArrayConverterProvider.getBinaryConverter(), (String)"json"));
    }

    public static GreenplumValueToArrayDataTypeProvider getInstance() {
        return ToArrayDataTypeHolder.INSTANCE;
    }

    @Nonnull
    public DataType<?> getDataType(ScalarType valueType) {
        DataType<?> converter = this.converters.get(valueType);
        if (converter == null) {
            throw new AssertionError((Object)("There is no data type for elements of type " + valueType));
        }
        return converter;
    }

    private Object readResolve() {
        return GreenplumValueToArrayDataTypeProvider.getInstance();
    }

    private static class ToArrayDataTypeHolder {
        private static final GreenplumValueToArrayDataTypeProvider INSTANCE = new GreenplumValueToArrayDataTypeProvider();

        private ToArrayDataTypeHolder() {
        }
    }
}

