/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters.array;

import com.google.common.collect.Maps;
import com.torodb.torod.core.exceptions.ToroImplementationException;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.core.subdocument.values.ScalarArray;
import com.torodb.torod.core.subdocument.values.ScalarBinary;
import com.torodb.torod.core.subdocument.values.ScalarBoolean;
import com.torodb.torod.core.subdocument.values.ScalarDate;
import com.torodb.torod.core.subdocument.values.ScalarInstant;
import com.torodb.torod.core.subdocument.values.ScalarInteger;
import com.torodb.torod.core.subdocument.values.ScalarLong;
import com.torodb.torod.core.subdocument.values.ScalarMongoObjectId;
import com.torodb.torod.core.subdocument.values.ScalarNull;
import com.torodb.torod.core.subdocument.values.ScalarString;
import com.torodb.torod.core.subdocument.values.ScalarTime;
import com.torodb.torod.db.backends.converters.array.ArrayConverter;
import com.torodb.torod.db.backends.converters.array.BinaryToArrayConverter;
import com.torodb.torod.db.backends.converters.array.BooleanToArrayConverter;
import com.torodb.torod.db.backends.converters.array.DateToArrayConverter;
import com.torodb.torod.db.backends.converters.array.DoubleToArrayConverter;
import com.torodb.torod.db.backends.converters.array.InstantToArrayConverter;
import com.torodb.torod.db.backends.converters.array.IntegerToArrayConverter;
import com.torodb.torod.db.backends.converters.array.LongToArrayConverter;
import com.torodb.torod.db.backends.converters.array.MongoObjectIdToArrayConverter;
import com.torodb.torod.db.backends.converters.array.MongoTimestampToArrayConverter;
import com.torodb.torod.db.backends.converters.array.NullToArrayConverter;
import com.torodb.torod.db.backends.converters.array.StringToArrayConverter;
import com.torodb.torod.db.backends.converters.array.TimeToArrayConverter;
import com.torodb.torod.db.backends.converters.array.ValueToArrayConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.array.ArrayToArrayConverter;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class GreenplumValueToArrayConverterProvider
implements ValueToArrayConverterProvider {
    private static final long serialVersionUID = 1L;
    private final Map<ScalarType, ArrayConverter> converters;
    private final ArrayConverter<JsonArray, ScalarArray> arrayConverter = new ArrayToArrayConverter(this);
    private final ArrayConverter<JsonValue, ScalarBoolean> booleanConverter = new BooleanToArrayConverter();
    private final ArrayConverter<JsonString, ScalarDate> dateConverter = new DateToArrayConverter();
    private final ArrayConverter<JsonString, ScalarInstant> dateTimeConverter = new InstantToArrayConverter();
    private final DoubleToArrayConverter doubleConverter = new DoubleToArrayConverter();
    private final ArrayConverter<JsonNumber, ScalarInteger> integerConverter = new IntegerToArrayConverter();
    private final ArrayConverter<JsonNumber, ScalarLong> longConverter = new LongToArrayConverter();
    private final ArrayConverter<JsonValue, ScalarNull> nullConverter = new NullToArrayConverter();
    private final ArrayConverter<JsonString, ScalarString> stringConverter = new StringToArrayConverter();
    private final ArrayConverter<JsonString, ScalarTime> timeConverter = new TimeToArrayConverter();
    private final ArrayConverter<JsonString, ScalarMongoObjectId> mongoObjectIdConverter = new MongoObjectIdToArrayConverter();
    private final MongoTimestampToArrayConverter mongoTimestampConverter = new MongoTimestampToArrayConverter();
    private final ArrayConverter<JsonString, ScalarBinary> binaryConverter = new BinaryToArrayConverter();

    private GreenplumValueToArrayConverterProvider() {
        this.converters = Maps.newEnumMap(ScalarType.class);
        this.converters.put(ScalarType.ARRAY, this.arrayConverter);
        this.converters.put(ScalarType.BOOLEAN, this.booleanConverter);
        this.converters.put(ScalarType.DATE, this.dateConverter);
        this.converters.put(ScalarType.INSTANT, this.dateTimeConverter);
        this.converters.put(ScalarType.DOUBLE, (ArrayConverter)this.doubleConverter);
        this.converters.put(ScalarType.INTEGER, this.integerConverter);
        this.converters.put(ScalarType.LONG, this.longConverter);
        this.converters.put(ScalarType.NULL, this.nullConverter);
        this.converters.put(ScalarType.STRING, this.stringConverter);
        this.converters.put(ScalarType.TIME, this.timeConverter);
        this.converters.put(ScalarType.MONGO_OBJECT_ID, this.mongoObjectIdConverter);
        this.converters.put(ScalarType.MONGO_TIMESTAMP, (ArrayConverter)this.mongoTimestampConverter);
        this.converters.put(ScalarType.BINARY, this.binaryConverter);
    }

    public static GreenplumValueToArrayConverterProvider getInstance() {
        return ToArrayConverterHolder.INSTANCE;
    }

    @Nonnull
    public ArrayConverter getConverter(ScalarType valueType) {
        ArrayConverter converter = this.converters.get(valueType);
        if (converter == null) {
            throw new AssertionError((Object)("There is no converter that converts elements of type " + valueType));
        }
        return converter;
    }

    @Nonnull
    public ArrayConverter fromJsonValue(JsonValue jsonValue) {
        switch (jsonValue.getValueType()) {
            case ARRAY: {
                assert (jsonValue instanceof JsonArray);
                return this.arrayConverter;
            }
            case TRUE: 
            case FALSE: {
                return this.booleanConverter;
            }
            case NULL: {
                return this.nullConverter;
            }
            case NUMBER: {
                assert (jsonValue instanceof JsonNumber);
                JsonNumber number = (JsonNumber)jsonValue;
                if (number.isIntegral()) {
                    try {
                        long l = number.longValueExact();
                        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                            return this.longConverter;
                        }
                        return this.integerConverter;
                    }
                    catch (ArithmeticException ex) {
                        throw new ToroImplementationException("Unexpected integral value. " + number + " is " + "bigger than long values");
                    }
                }
                return this.doubleConverter;
            }
            case STRING: {
                assert (jsonValue instanceof JsonString);
                return this.stringConverter;
            }
            case OBJECT: {
                JsonObject asObject = (JsonObject)jsonValue;
                if (this.mongoTimestampConverter.isValid(asObject)) {
                    return this.mongoTimestampConverter;
                }
                throw new IllegalArgumentException("Te recived JsonObject " + jsonValue + " was not recognized as a valid ScalarValue codification");
            }
        }
        throw new IllegalArgumentException("Instances of '" + jsonValue.getClass() + "' like '" + jsonValue + "' are not supported");
    }

    public ArrayConverter<JsonArray, ScalarArray> getArrayConverter() {
        return this.arrayConverter;
    }

    public ArrayConverter<JsonValue, ScalarBoolean> getBooleanConverter() {
        return this.booleanConverter;
    }

    public ArrayConverter<JsonString, ScalarDate> getDateConverter() {
        return this.dateConverter;
    }

    public ArrayConverter<JsonString, ScalarInstant> getInstantConverter() {
        return this.dateTimeConverter;
    }

    public DoubleToArrayConverter getDoubleConverter() {
        return this.doubleConverter;
    }

    public ArrayConverter<JsonNumber, ScalarInteger> getIntegerConverter() {
        return this.integerConverter;
    }

    public ArrayConverter<JsonNumber, ScalarLong> getLongConverter() {
        return this.longConverter;
    }

    public ArrayConverter<JsonValue, ScalarNull> getNullConverter() {
        return this.nullConverter;
    }

    public ArrayConverter<JsonString, ScalarString> getStringConverter() {
        return this.stringConverter;
    }

    public ArrayConverter<JsonString, ScalarTime> getTimeConverter() {
        return this.timeConverter;
    }

    public ArrayConverter<JsonString, ScalarMongoObjectId> getMongoObjectIdConverter() {
        return this.mongoObjectIdConverter;
    }

    public MongoTimestampToArrayConverter getMongoTimestampConverter() {
        return this.mongoTimestampConverter;
    }

    public ArrayConverter<JsonString, ScalarBinary> getBinaryConverter() {
        return this.binaryConverter;
    }

    private Object readResolve() {
        return GreenplumValueToArrayConverterProvider.getInstance();
    }

    private static class ToArrayConverterHolder {
        private static final GreenplumValueToArrayConverterProvider INSTANCE = new GreenplumValueToArrayConverterProvider();

        private ToArrayConverterHolder() {
        }
    }
}

