/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters;

import com.torodb.common.util.HexUtils;
import com.torodb.common.util.OctetUtils;
import com.torodb.torod.core.subdocument.values.ScalarArray;
import com.torodb.torod.core.subdocument.values.ScalarBinary;
import com.torodb.torod.core.subdocument.values.ScalarBoolean;
import com.torodb.torod.core.subdocument.values.ScalarDate;
import com.torodb.torod.core.subdocument.values.ScalarDouble;
import com.torodb.torod.core.subdocument.values.ScalarInstant;
import com.torodb.torod.core.subdocument.values.ScalarInteger;
import com.torodb.torod.core.subdocument.values.ScalarLong;
import com.torodb.torod.core.subdocument.values.ScalarMongoObjectId;
import com.torodb.torod.core.subdocument.values.ScalarMongoTimestamp;
import com.torodb.torod.core.subdocument.values.ScalarNull;
import com.torodb.torod.core.subdocument.values.ScalarString;
import com.torodb.torod.core.subdocument.values.ScalarTime;
import com.torodb.torod.core.subdocument.values.ScalarValue;
import com.torodb.torod.core.subdocument.values.ScalarValueVisitor;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalTime;

public class GreenplumValueToCopyConverter
implements ScalarValueVisitor<Void, StringBuilder> {
    private static final char ROW_DELIMETER = '\n';
    private static final char COLUMN_DELIMETER = '\t';
    private static final InArrayConverter IN_ARRAY_CONVERTER = new InArrayConverter();
    public static final GreenplumValueToCopyConverter INSTANCE = new GreenplumValueToCopyConverter();

    GreenplumValueToCopyConverter() {
    }

    public Void visit(ScalarBoolean value, StringBuilder arg) {
        if (value.getValue().booleanValue()) {
            arg.append("true");
        } else {
            arg.append("false");
        }
        return null;
    }

    public Void visit(ScalarNull value, StringBuilder arg) {
        arg.append("\\N");
        return null;
    }

    public Void visit(ScalarArray value, StringBuilder arg) {
        arg.append('[');
        for (ScalarValue child : value) {
            child.accept((ScalarValueVisitor)IN_ARRAY_CONVERTER, (Object)arg);
            arg.append(',');
        }
        if (!value.isEmpty()) {
            arg.replace(arg.length() - 1, arg.length(), "]");
        } else {
            arg.append(']');
        }
        return null;
    }

    public Void visit(ScalarInteger value, StringBuilder arg) {
        arg.append(value.getValue().toString());
        return null;
    }

    public Void visit(ScalarLong value, StringBuilder arg) {
        arg.append(value.getValue().toString());
        return null;
    }

    public Void visit(ScalarDouble value, StringBuilder arg) {
        arg.append(value.getValue().toString());
        return null;
    }

    public Void visit(ScalarString value, StringBuilder arg) {
        GreenplumValueToCopyConverter.escape((String)value.getValue(), arg);
        return null;
    }

    public Void visit(ScalarMongoObjectId value, StringBuilder arg) {
        OctetUtils.bytes2Octet((byte[])value.getArrayValue(), (StringBuilder)arg);
        return null;
    }

    public Void visit(ScalarBinary value, StringBuilder arg) {
        OctetUtils.bytes2Octet((byte[])value.getByteSource().read(), (StringBuilder)arg);
        return null;
    }

    public Void visit(ScalarInstant value, StringBuilder arg) {
        arg.append('\'').append(((Instant)value.getValue()).toString()).append('\'');
        return null;
    }

    public Void visit(ScalarDate value, StringBuilder arg) {
        arg.append('\'').append(((LocalDate)value.getValue()).toString()).append('\'');
        return null;
    }

    public Void visit(ScalarTime value, StringBuilder arg) {
        arg.append('\'').append(((LocalTime)value.getValue()).toString()).append('\'');
        return null;
    }

    public Void visit(ScalarMongoTimestamp value, StringBuilder arg) {
        arg.append('(').append(value.getSecondsSinceEpoch()).append(',').append(value.getOrdinal()).append(')');
        return null;
    }

    private static void escape(String nonEscaped, StringBuilder appender) {
        if (!GreenplumValueToCopyConverter.needsEscape(nonEscaped)) {
            appender.append(nonEscaped);
            return;
        }
        appender.ensureCapacity(nonEscaped.length() + 16);
        int lenght = nonEscaped.length();
        for (int i = 0; i < lenght; ++i) {
            char c = nonEscaped.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\\': {
                    appender.append('\\');
                    break;
                }
            }
            appender.append(c);
        }
    }

    private static boolean needsEscape(String nonEscaped) {
        int lenght = nonEscaped.length();
        for (int i = 0; i < lenght; ++i) {
            switch (nonEscaped.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\\': {
                    return true;
                }
            }
        }
        return false;
    }

    static class InArrayConverter
    implements ScalarValueVisitor<Void, StringBuilder> {
        InArrayConverter() {
        }

        public Void visit(ScalarBoolean value, StringBuilder arg) {
            if (value.getValue().booleanValue()) {
                arg.append("true");
            } else {
                arg.append("false");
            }
            return null;
        }

        public Void visit(ScalarNull value, StringBuilder arg) {
            arg.append("null");
            return null;
        }

        public Void visit(ScalarArray value, StringBuilder arg) {
            arg.append('[');
            for (ScalarValue child : value) {
                child.accept((ScalarValueVisitor)this, (Object)arg);
                arg.append(',');
            }
            if (!value.isEmpty()) {
                arg.replace(arg.length() - 1, arg.length(), "]");
            }
            return null;
        }

        public Void visit(ScalarInteger value, StringBuilder arg) {
            arg.append(value.getValue().toString());
            return null;
        }

        public Void visit(ScalarLong value, StringBuilder arg) {
            arg.append(value.getValue().toString());
            return null;
        }

        public Void visit(ScalarDouble value, StringBuilder arg) {
            arg.append(value.getValue().toString());
            return null;
        }

        public Void visit(ScalarString value, StringBuilder arg) {
            arg.append('\"');
            GreenplumValueToCopyConverter.escape((String)value.getValue(), arg);
            arg.append('\"');
            return null;
        }

        public Void visit(ScalarMongoObjectId value, StringBuilder arg) {
            arg.append('\"');
            arg.append("\\\\x");
            HexUtils.bytes2Hex((byte[])value.getArrayValue(), (StringBuilder)arg);
            arg.append('\"');
            return null;
        }

        public Void visit(ScalarBinary value, StringBuilder arg) {
            arg.append('\"');
            arg.append("\\\\x");
            HexUtils.bytes2Hex((byte[])value.getByteSource().read(), (StringBuilder)arg);
            arg.append('\"');
            return null;
        }

        public Void visit(ScalarInstant value, StringBuilder arg) {
            arg.append('\"').append(((Instant)value.getValue()).toString()).append('\"');
            return null;
        }

        public Void visit(ScalarDate value, StringBuilder arg) {
            arg.append('\"').append(((LocalDate)value.getValue()).toString()).append('\"');
            return null;
        }

        public Void visit(ScalarTime value, StringBuilder arg) {
            arg.append('\"').append(((LocalTime)value.getValue()).toString()).append('\"');
            return null;
        }

        public Void visit(ScalarMongoTimestamp value, StringBuilder arg) {
            arg.append("{\"secs\":").append(value.getSecondsSinceEpoch()).append(",\"counter\":").append(value.getOrdinal()).append('}');
            return null;
        }
    }
}

