/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum.converters;

import com.torodb.torod.core.exceptions.ToroImplementationException;
import com.torodb.torod.core.subdocument.ScalarType;
import com.torodb.torod.db.backends.converters.ScalarTypeToSqlType;
import com.torodb.torod.db.backends.udt.MongoObjectIdUDT;
import com.torodb.torod.db.backends.udt.MongoTimestampUDT;

public class GreenplumScalarTypeToSqlType
implements ScalarTypeToSqlType {
    public static final String ARRAY_TYPE = "json";
    public static final String MONGO_OBJECT_ID_TYPE = "mongo_object_id";
    public static final String MONGO_TIMESTAMP_TYPE = "mongo_timestamp";
    public static final String FULL_MONGO_OBJECT_ID_TYPE = "\"torodb\".\"mongo_object_id\"";
    public static final String FULL_MONGO_TIMESTAMP_TYPE = "\"torodb\".\"mongo_timestamp\"";
    private static final long serialVersionUID = 385628201L;

    public ScalarType toScalarType(String columnName, int jdbcIntType, String jdbcStringType) {
        switch (jdbcIntType) {
            case -5: {
                return ScalarType.LONG;
            }
            case -7: 
            case 16: {
                return ScalarType.BOOLEAN;
            }
            case 91: {
                return ScalarType.DATE;
            }
            case 8: {
                return ScalarType.DOUBLE;
            }
            case 4: {
                return ScalarType.INTEGER;
            }
            case 0: 
            case 5: {
                return ScalarType.NULL;
            }
            case 92: {
                return ScalarType.TIME;
            }
            case 93: {
                return ScalarType.INSTANT;
            }
            case 12: {
                return ScalarType.STRING;
            }
            case -2: {
                return ScalarType.BINARY;
            }
            case 1111: {
                break;
            }
            case 2001: {
                if (jdbcStringType.equals(ARRAY_TYPE)) {
                    return ScalarType.ARRAY;
                }
                if (jdbcStringType.equals(FULL_MONGO_OBJECT_ID_TYPE) || jdbcStringType.equals(MongoObjectIdUDT.MONGO_OBJECT_ID.getName())) {
                    return ScalarType.MONGO_OBJECT_ID;
                }
                if (!jdbcStringType.equals(FULL_MONGO_TIMESTAMP_TYPE) && !jdbcStringType.equals(MongoTimestampUDT.MONGO_TIMESTAMP.getName())) break;
                return ScalarType.MONGO_TIMESTAMP;
            }
        }
        throw new ToroImplementationException("SQL type " + jdbcStringType + " (with int " + jdbcIntType + ") is not supported (column " + columnName + ")");
    }
}

