/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum;

import com.google.common.collect.MapMaker;
import com.google.common.io.CharStreams;
import com.torodb.torod.core.exceptions.ToroImplementationException;
import com.torodb.torod.core.subdocument.SubDocType;
import com.torodb.torod.db.backends.DatabaseInterface;
import com.torodb.torod.db.backends.exceptions.InvalidCollectionSchemaException;
import com.torodb.torod.db.backends.exceptions.InvalidDatabaseException;
import com.torodb.torod.db.backends.meta.CollectionSchema;
import com.torodb.torod.db.backends.meta.TorodbMeta;
import com.torodb.torod.db.backends.meta.TorodbSchema;
import com.torodb.torod.db.backends.tables.records.AbstractCollectionsRecord;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.jooq.DSLContext;
import org.jooq.Meta;
import org.jooq.Result;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenplumTorodbMeta
implements TorodbMeta {
    private static final long serialVersionUID = -4785629402L;
    private final String databaseName;
    private final ConcurrentMap<String, CollectionSchema> collectionSchemes;
    private static final Logger LOGGER = LoggerFactory.getLogger(GreenplumTorodbMeta.class);
    private final DatabaseInterface databaseInterface;
    private final Provider<SubDocType.Builder> subDocTypeBuilderProvider;

    GreenplumTorodbMeta(String databaseName, DSLContext dsl, DatabaseInterface databaseInterface, @Nonnull Provider<SubDocType.Builder> subDocTypeBuilderProvider) throws SQLException, IOException, InvalidDatabaseException {
        this.databaseName = databaseName;
        this.databaseInterface = databaseInterface;
        this.subDocTypeBuilderProvider = subDocTypeBuilderProvider;
        Meta jooqMeta = dsl.meta();
        Connection conn = dsl.configuration().connectionProvider().acquire();
        DatabaseMetaData jdbcMeta = conn.getMetaData();
        this.collectionSchemes = new MapMaker().concurrencyLevel(1).makeMap();
        TorodbSchema.TORODB.checkOrCreate(dsl, jooqMeta, jdbcMeta, databaseInterface);
        this.loadAllCollectionSchemas(dsl, jooqMeta, jdbcMeta);
        this.createTypes(conn, jdbcMeta);
        this.createProcedures(conn, jdbcMeta);
        dsl.configuration().connectionProvider().release(conn);
    }

    private void loadAllCollectionSchemas(DSLContext dsl, Meta jooqMeta, DatabaseMetaData jdbcMeta) throws InvalidCollectionSchemaException {
        Result records = dsl.selectFrom((Table)this.databaseInterface.getCollectionsTable()).fetch();
        for (AbstractCollectionsRecord colRecord : records) {
            CollectionSchema colSchema = new CollectionSchema(colRecord.getSchema(), colRecord.getName(), dsl, jdbcMeta, jooqMeta, (TorodbMeta)this, this.databaseInterface, this.subDocTypeBuilderProvider);
            this.collectionSchemes.put(colSchema.getCollection(), colSchema);
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean exists(String collection) {
        return this.collectionSchemes.containsKey(collection);
    }

    public CollectionSchema getCollectionSchema(String collection) {
        CollectionSchema schema = (CollectionSchema)this.collectionSchemes.get(collection);
        if (schema == null) {
            throw new IllegalArgumentException("There is no schema associated with collection " + collection);
        }
        return schema;
    }

    public void dropCollectionSchema(String collection) {
        CollectionSchema removed = (CollectionSchema)this.collectionSchemes.remove(collection);
        if (removed == null) {
            throw new IllegalArgumentException("Collection " + collection + " didn't exist");
        }
    }

    public CollectionSchema createCollectionSchema(String colName, String schemaName, DSLContext dsl) throws InvalidCollectionSchemaException {
        if (this.collectionSchemes.containsKey(colName)) {
            throw new IllegalArgumentException("Collection '" + colName + "' is already associated with a collection schema");
        }
        CollectionSchema result = new CollectionSchema(schemaName, colName, dsl, (TorodbMeta)this, this.databaseInterface, this.subDocTypeBuilderProvider);
        this.collectionSchemes.put(colName, result);
        return result;
    }

    public Collection<CollectionSchema> getCollectionSchemes() {
        return Collections.unmodifiableCollection(this.collectionSchemes.values());
    }

    private void createTypes(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        boolean findDocTypeExists = false;
        boolean jsonTypeExists = false;
        boolean mongoObjectIdExists = false;
        boolean mongoTimestampExists = false;
        try (ResultSet typeInfo = jdbcMeta.getTypeInfo();){
            while (typeInfo.next()) {
                findDocTypeExists = findDocTypeExists || typeInfo.getString("TYPE_NAME").equals("find_doc_type");
                jsonTypeExists = jsonTypeExists || typeInfo.getString("TYPE_NAME").equals("json");
                mongoObjectIdExists = mongoObjectIdExists || typeInfo.getString("TYPE_NAME").equals("mongo_object_id");
                boolean bl = mongoTimestampExists = mongoObjectIdExists || typeInfo.getString("TYPE_NAME").equals("mongo_timestamp");
                if (!findDocTypeExists || !mongoObjectIdExists || !mongoTimestampExists) continue;
                break;
            }
        }
        if (!findDocTypeExists) {
            LOGGER.debug("Creating type find_doc_type");
            this.createFindDocType(conn);
            LOGGER.debug("Created type find_doc_type");
        } else {
            LOGGER.debug("Type find_doc_type found");
        }
        if (!jsonTypeExists) {
            LOGGER.debug("Creating type find_doc_type");
            this.createJsonType(conn);
            LOGGER.debug("Created type find_doc_type");
        } else {
            LOGGER.debug("Type find_doc_type found");
        }
        if (!mongoObjectIdExists) {
            LOGGER.debug("Creating type mongo_object_id");
            this.createMongoObjectIdType(conn);
            LOGGER.debug("Created type mongo_object_id");
        } else {
            LOGGER.debug("Type mongo_object_id found");
        }
        if (!mongoTimestampExists) {
            LOGGER.debug("Creating type mongo_timestamp");
            this.createMongoTimestampType(conn);
            LOGGER.debug("Created type mongo_timestamp");
        } else {
            LOGGER.debug("Type mongo_object_id found");
        }
    }

    private void createProcedures(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createFindDocQueryProcedure(conn, jdbcMeta);
        this.createFindDocProcedure(conn, jdbcMeta);
        this.createFindDocsProcedure(conn, jdbcMeta);
        this.createFirstFreeDocIdProcedure(conn, jdbcMeta);
        this.createReserveDocIdsProcedure(conn, jdbcMeta);
        this.createJsonFunctions(conn, jdbcMeta);
    }

    private void createFindDocType(Connection conn) throws IOException, SQLException {
        this.executeSql(conn, "/sql/greenplum/find_doc_type.sql");
    }

    private void createJsonType(Connection conn) throws IOException, SQLException {
        this.executeSql(conn, "/sql/greenplum/json_type.sql");
    }

    private void createMongoObjectIdType(Connection conn) throws IOException, SQLException {
        this.executeSql(conn, "/sql/greenplum/mongo_object_id_type.sql");
    }

    private void createMongoTimestampType(Connection conn) throws IOException, SQLException {
        this.executeSql(conn, "/sql/greenplum/mongo_timestamp_type.sql");
    }

    private void createFindDocQueryProcedure(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createProcedure(conn, jdbcMeta, "find_doc_query");
    }

    private void createFindDocProcedure(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createProcedure(conn, jdbcMeta, "find_doc");
    }

    private void createFindDocsProcedure(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createProcedure(conn, jdbcMeta, "find_docs");
    }

    private void createFirstFreeDocIdProcedure(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createProcedure(conn, jdbcMeta, "first_free_doc_id");
    }

    private void createReserveDocIdsProcedure(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createProcedure(conn, jdbcMeta, "reserve_doc_ids");
    }

    private void createJsonFunctions(Connection conn, DatabaseMetaData jdbcMeta) throws SQLException, IOException {
        this.createProcedure(conn, jdbcMeta, "json_functions");
    }

    private void createProcedure(Connection conn, DatabaseMetaData jdbcMeta, String proc) throws SQLException, IOException {
        if (!this.checkIfProcedureExists(jdbcMeta, proc)) {
            LOGGER.debug("Creating procedure " + proc);
            this.executeSql(conn, "/sql/greenplum/" + proc + ".sql");
            LOGGER.debug("Procedure " + proc + " created");
        } else {
            LOGGER.debug("Procedure " + proc + " found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkIfProcedureExists(DatabaseMetaData jdbcMeta, String procedureName) throws SQLException {
        try (ResultSet procedures = null;){
            procedures = jdbcMeta.getProcedures("%", "torodb", procedureName);
            boolean bl = procedures.next();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    private void executeSql(Connection conn, String resourcePath) throws IOException, SQLException {
        InputStream resourceAsStream = GreenplumTorodbMeta.class.getResourceAsStream(resourcePath);
        if (resourceAsStream == null) {
            throw new ToroImplementationException("Resource '" + resourcePath + "' does not exist");
        }
        Statement st = null;
        try {
            String methodAsString = CharStreams.toString((Readable)new BufferedReader(new InputStreamReader(resourceAsStream, Charset.forName("UTF-8"))));
            st = conn.createStatement();
            st.execute(methodAsString);
        }
        finally {
            if (st != null) {
                st.close();
            }
            resourceAsStream.close();
        }
    }
}

