/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum;

import com.google.common.base.Preconditions;
import com.torodb.torod.core.exceptions.UserToroException;
import com.torodb.torod.db.backends.ArraySerializer;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.Table;

@Singleton
public class GreenplumJsonArraySerializer
implements ArraySerializer {
    private static final long serialVersionUID = 946395628L;

    public String getFieldName(String[] keys) {
        return this.getFieldName(keys, 0, keys.length);
    }

    public String getFieldName(String[] keys, int from, int to) {
        Preconditions.checkArgument((to > from ? 1 : 0) != 0, (Object)"'to' must be greater than 'from'");
        StringBuilder sb = new StringBuilder(12 + (to - from + 1) * 2);
        if (from + 1 > to) {
            throw new UserToroException("query on arrays are not supported for Greenplum");
        }
        for (int i = from; i < to; ++i) {
            sb.append('\"').append(keys[i]).append('\"').append("->");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    @Nonnull
    public Condition typeof(String fieldName, String typeName) {
        throw new UserToroException("query on arrays are not supported for Greenplum");
    }

    @Nonnull
    public Condition typeof(String fieldName, String typeName, Condition condition) {
        throw new UserToroException("query on arrays are not supported for Greenplum");
    }

    @Nonnull
    public Condition arrayLength(String fieldName, Param<?> value) {
        throw new UserToroException("query on arrays are not supported for Greenplum");
    }

    @Nonnull
    public Table arrayElements(Field<?> iteratorVariable, Field<?> field) {
        throw new UserToroException("query on arrays are not supported for Greenplum");
    }
}

