/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum;

import com.torodb.torod.core.annotations.DatabaseName;
import com.torodb.torod.core.backend.DbBackend;
import com.torodb.torod.core.d2r.D2RTranslator;
import com.torodb.torod.core.dbWrapper.DbConnection;
import com.torodb.torod.core.dbWrapper.exceptions.ImplementationDbException;
import com.torodb.torod.core.subdocument.SubDocType;
import com.torodb.torod.db.backends.DatabaseInterface;
import com.torodb.torod.db.backends.greenplum.GreenplumDbConnection;
import com.torodb.torod.db.backends.meta.TorodbMeta;
import com.torodb.torod.db.backends.meta.routines.QueryRoutine;
import com.torodb.torod.db.backends.sql.AbstractDbWrapper;
import java.sql.Connection;
import java.sql.SQLException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.RenderNameStyle;
import org.jooq.conf.Settings;
import org.jooq.impl.DefaultConfiguration;

@Singleton
public class GreenplumDbWrapper
extends AbstractDbWrapper {
    private static final int DB_SUPPORT_MAJOR = 8;
    private static final int DB_SUPPORT_MINOR = 2;
    private final D2RTranslator d2r;
    private final QueryRoutine queryRoutine;
    private final DatabaseInterface databaseInterface;
    private final Provider<SubDocType.Builder> subDocTypeBuilderProvider;

    @Inject
    public GreenplumDbWrapper(@DatabaseName String databaseName, DbBackend dbBackend, D2RTranslator d2r, QueryRoutine queryRoutine, DatabaseInterface databaseInterface, Provider<SubDocType.Builder> subDocTypeBuilderProvider) {
        super(databaseName, dbBackend, queryRoutine, databaseInterface);
        this.d2r = d2r;
        this.queryRoutine = queryRoutine;
        this.databaseInterface = databaseInterface;
        this.subDocTypeBuilderProvider = subDocTypeBuilderProvider;
    }

    protected Configuration getJooqConfiguration(ConnectionProvider cp) {
        return new DefaultConfiguration().set(cp).set(SQLDialect.POSTGRES).set(new Settings().withRenderNameStyle(RenderNameStyle.QUOTED));
    }

    protected DbConnection reserveConnection(DSLContext dsl, TorodbMeta meta) {
        return new GreenplumDbConnection(dsl, meta, this.subDocTypeBuilderProvider, this.d2r, this.queryRoutine, this.databaseInterface);
    }

    protected void checkDbSupported(Connection conn) throws SQLException, ImplementationDbException {
        int major = conn.getMetaData().getDatabaseMajorVersion();
        int minor = conn.getMetaData().getDatabaseMinorVersion();
        if (major <= 8 && (major != 8 || minor < 2)) {
            throw new ImplementationDbException(true, "ToroDB requires PostgreSQL version 8.2 or higher! Detected " + major + "." + minor);
        }
    }
}

