/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum;

import com.google.common.collect.Lists;
import com.torodb.torod.core.ValueRow;
import com.torodb.torod.core.connection.exceptions.RetryTransactionException;
import com.torodb.torod.core.d2r.D2RTranslator;
import com.torodb.torod.core.dbWrapper.exceptions.ImplementationDbException;
import com.torodb.torod.core.exceptions.IllegalPathViewException;
import com.torodb.torod.core.exceptions.UserToroException;
import com.torodb.torod.core.subdocument.SplitDocument;
import com.torodb.torod.core.subdocument.SubDocType;
import com.torodb.torod.core.subdocument.structure.DocStructure;
import com.torodb.torod.core.subdocument.values.ScalarArray;
import com.torodb.torod.core.subdocument.values.ScalarMongoObjectId;
import com.torodb.torod.core.subdocument.values.ScalarMongoTimestamp;
import com.torodb.torod.core.subdocument.values.ScalarValue;
import com.torodb.torod.db.backends.DatabaseInterface;
import com.torodb.torod.db.backends.meta.CollectionSchema;
import com.torodb.torod.db.backends.meta.StructuresCache;
import com.torodb.torod.db.backends.meta.TorodbMeta;
import com.torodb.torod.db.backends.meta.routines.QueryRoutine;
import com.torodb.torod.db.backends.sql.AbstractDbConnection;
import com.torodb.torod.db.backends.sql.index.IndexManager;
import com.torodb.torod.db.backends.sql.index.NamedDbIndex;
import com.torodb.torod.db.backends.sql.path.view.DefaultPathViewHandlerCallback;
import com.torodb.torod.db.backends.sql.path.view.PathViewHandler;
import com.torodb.torod.db.backends.tables.SubDocTable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jooq.Configuration;
import org.jooq.ConnectionProvider;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.InsertValuesStep2;
import org.jooq.Name;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GreenplumDbConnection
extends AbstractDbConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreenplumDbConnection.class);
    static final String SUBDOC_TABLE_PK_COLUMN = "pk";
    static final String SUBDOC_TABLE_DOC_ID_COLUMN = "docId";
    static final String SUBDOC_TABLE_KEYS_COLUMN = "keys";
    private final FieldComparator fieldComparator = new FieldComparator();
    private final MyStructureListener listener = new MyStructureListener();
    private final DatabaseInterface databaseInterface;

    @Inject
    public GreenplumDbConnection(DSLContext dsl, TorodbMeta meta, Provider<SubDocType.Builder> subDocTypeBuilderProvider, D2RTranslator d2r, QueryRoutine queryRoutine, DatabaseInterface databaseInterface) {
        super(dsl, meta, subDocTypeBuilderProvider, d2r, queryRoutine, databaseInterface);
        this.databaseInterface = databaseInterface;
    }

    protected String getCreateIndexQuery(SubDocTable table, Field<?> field, Configuration conf) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE INDEX \"").append(table.getName()).append('_').append(field.getName()).append("\" ON \"").append(table.getSchema().getName()).append("\".\"").append(table.getName()).append("\" (\"").append(field.getName()).append("\")");
        return sb.toString();
    }

    protected String getCreateSubDocTypeTableQuery(SubDocTable table, Configuration conf) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE \"").append(table.getSchema().getName()).append("\".\"").append(table.getName()).append("\"(");
        for (Field field : this.getFieldIterator(table.fields())) {
            sb.append('\"').append(field.getName()).append("\" ").append(this.getSqlType(field, conf));
            sb.append(',');
        }
        if (table.fields().length > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append(") DISTRIBUTED BY (").append('\"').append("did").append("\")");
        return sb.toString();
    }

    public void insertRootDocuments(@Nonnull String collection, @Nonnull Collection<SplitDocument> docs) throws ImplementationDbException, RetryTransactionException {
        try {
            this.standardInsertRootDocuments(collection, docs);
        }
        catch (DataAccessException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SQLException) {
                this.databaseInterface.handleRetryException((SQLException)cause);
            }
            throw new RuntimeException(ex);
        }
    }

    private void standardInsertRootDocuments(@Nonnull String collection, @Nonnull Collection<SplitDocument> docs) {
        CollectionSchema colSchema = this.getMeta().getCollectionSchema(collection);
        Field idField = DSL.field((String)"did", (DataType)SQLDataType.INTEGER.nullable(false));
        Field sidField = DSL.field((String)"sid", (DataType)SQLDataType.INTEGER.nullable(false));
        InsertValuesStep2 insertInto = this.getDsl().insertInto(DSL.table((Name)DSL.name((String[])new String[]{colSchema.getName(), "root"})), idField, sidField);
        for (SplitDocument splitDocument : docs) {
            int structureId = colSchema.getStructuresCache().getOrCreateStructure(splitDocument.getRoot(), this.getDsl(), (StructuresCache.NewStructureListener)this.listener);
            insertInto = insertInto.values((Object)splitDocument.getDocumentId(), (Object)structureId);
        }
        insertInto.execute();
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="False positive: https://sourceforge.net/p/findbugs/bugs/1021/")
    public long getDatabaseSize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="False positive: https://sourceforge.net/p/findbugs/bugs/1021/")
    public Long getCollectionSize(String collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected void createSchema(String escapedSchemaName) throws SQLException {
        Connection c = this.getDsl().configuration().connectionProvider().acquire();
        String query = "CREATE SCHEMA \"" + escapedSchemaName + "\"";
        try (PreparedStatement ps = c.prepareStatement(query);){
            ps.executeUpdate();
        }
        finally {
            this.getDsl().configuration().connectionProvider().release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected void createStructuresTable(String escapedSchemaName) throws SQLException {
        Connection c = this.getDsl().configuration().connectionProvider().acquire();
        String query = "CREATE TABLE \"" + escapedSchemaName + "\".structures(" + "sid int PRIMARY KEY," + "_structure text NOT NULL" + ")";
        try (PreparedStatement ps = c.prepareStatement(query);){
            ps.executeUpdate();
        }
        finally {
            this.getDsl().configuration().connectionProvider().release(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected void createRootTable(String escapedSchemaName) throws SQLException {
        Connection c = this.getDsl().configuration().connectionProvider().acquire();
        String query = "CREATE TABLE \"" + escapedSchemaName + "\".root(" + "did int PRIMARY KEY DEFAULT nextval('\"" + escapedSchemaName + "\".root_seq')," + "sid int NOT NULL" + ") DISTRIBUTED BY (did)";
        try (PreparedStatement ps = c.prepareStatement(query);){
            ps.executeUpdate();
        }
        finally {
            this.getDsl().configuration().connectionProvider().release(c);
        }
    }

    protected String getRootSeqName() {
        return "root_seq";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected void createSequence(String escapedSchemaName, String seqName) throws SQLException {
        Connection c = this.getDsl().configuration().connectionProvider().acquire();
        String query = "CREATE SEQUENCE \"" + escapedSchemaName + "\".\"" + seqName + "\" " + "MINVALUE 0 START 0";
        try (PreparedStatement ps = c.prepareStatement(query);){
            ps.executeUpdate();
        }
        finally {
            this.getDsl().configuration().connectionProvider().release(c);
        }
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="False positive: https://sourceforge.net/p/findbugs/bugs/1021/")
    public Long getDocumentsSize(String collection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Long getIndexSize(String collection, String index) {
        CollectionSchema colSchema = this.getMeta().getCollectionSchema(collection);
        ConnectionProvider connectionProvider = this.getDsl().configuration().connectionProvider();
        Connection connection = connectionProvider.acquire();
        Set relatedDbIndexes = colSchema.getIndexManager().getRelatedDbIndexes(index);
        String query = "SELECT sum(table_size)::bigint from (SELECT pg_relation_size(pg_class.oid) AS table_size FROM pg_class join pg_indexes   on pg_class.relname = pg_indexes.tablename WHERE pg_indexes.schemaname = ?   and pg_indexes.indexname = ?) as t";
        long result = 0L;
        try {
            for (NamedDbIndex dbIndex : relatedDbIndexes) {
                PreparedStatement ps = connection.prepareStatement(query);
                Throwable throwable = null;
                try {
                    ps.setString(1, colSchema.getName());
                    ps.setString(2, dbIndex.getName());
                    ResultSet rs = ps.executeQuery();
                    int usedBy = colSchema.getIndexManager().getRelatedToroIndexes(dbIndex.getName()).size();
                    assert (usedBy != 0);
                    rs.next();
                    result += rs.getLong(1) / (long)usedBy;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
            Long l = result;
            return l;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            connectionProvider.release(connection);
        }
    }

    public Integer createPathViews(String collection) throws IllegalPathViewException {
        DefaultPathViewHandlerCallback callback = new DefaultPathViewHandlerCallback(this.getDsl());
        PathViewHandler handler = new PathViewHandler(this.getMeta(), (PathViewHandler.Callback)callback);
        return handler.createPathViews(collection);
    }

    public void dropPathViews(String collection) throws IllegalPathViewException {
        DefaultPathViewHandlerCallback callback = new DefaultPathViewHandlerCallback(this.getDsl());
        PathViewHandler handler = new PathViewHandler(this.getMeta(), (PathViewHandler.Callback)callback);
        handler.dropPathViews(collection);
    }

    /*
     * Exception decompiling
     */
    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="It is known that this command is unsafe. We needto improve it as soon as we can")
    public Iterator<ValueRow<ScalarValue<?>>> select(String query) throws UserToroException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getSqlType(Field<?> field, Configuration conf) {
        if (field.getConverter() != null) {
            Class fieldType = field.getDataType().getType();
            if (fieldType.equals(ScalarArray.class)) {
                return "json";
            }
            if (fieldType.equals(ScalarMongoObjectId.class)) {
                return "\"torodb\".\"mongo_object_id\"";
            }
            if (fieldType.equals(ScalarMongoTimestamp.class)) {
                return "\"torodb\".\"mongo_timestamp\"";
            }
        }
        return field.getDataType().getTypeName(conf);
    }

    private Iterable<Field> getFieldIterator(Field[] fields) {
        ArrayList fieldList = Lists.newArrayList((Object[])fields);
        Collections.sort(fieldList, this.fieldComparator);
        return fieldList;
    }

    private class MyStructureListener
    implements StructuresCache.NewStructureListener {
        private MyStructureListener() {
        }

        public void eventNewStructure(CollectionSchema colSchema, DocStructure newStructure) {
            colSchema.getIndexManager().newStructureDetected(newStructure, (IndexManager.DbIndexCreator)GreenplumDbConnection.this);
        }
    }

    private static class FieldComparator
    implements Comparator<Field>,
    Serializable {
        private static final List<Integer> sqlTypeOrder = Arrays.asList(0, 8, -5, 4, 6, 92, 91, 7, -6, 1, -7, -2);
        private static final long serialVersionUID = 1L;

        private FieldComparator() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            int i2;
            if (o1.getName().equals("did")) {
                return -1;
            }
            if (o2.getName().equals("did")) {
                return 1;
            }
            if (o1.getName().equals("index")) {
                return -1;
            }
            if (o2.getName().equals("index")) {
                return 1;
            }
            int i1 = sqlTypeOrder.indexOf(o1.getDataType().getSQLType());
            if (i1 == (i2 = sqlTypeOrder.indexOf(o2.getDataType().getSQLType()))) {
                return o1.getName().compareTo(o2.getName());
            }
            if (i1 == -1) {
                return 1;
            }
            if (i2 == -1) {
                return -1;
            }
            return i1 - i2;
        }
    }
}

