/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum;

import com.torodb.torod.backends.drivers.postgresql.PostgreSQLDriverProvider;
import com.torodb.torod.db.backends.AbstractDbBackend;
import com.torodb.torod.db.backends.DbBackendConfiguration;
import com.torodb.torod.db.backends.TransactionIsolationLevel;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.sql.DataSource;

public class GreenplumDbBackend
extends AbstractDbBackend {
    private final PostgreSQLDriverProvider driverProvider;

    @Inject
    public GreenplumDbBackend(DbBackendConfiguration configuration, PostgreSQLDriverProvider driverProvider) {
        super(configuration);
        this.driverProvider = driverProvider;
        this.initialize();
    }

    protected DataSource getConfiguredDataSource(DbBackendConfiguration configuration, String poolName) {
        return this.driverProvider.getConfiguredDataSource(configuration, poolName);
    }

    @Nonnull
    protected TransactionIsolationLevel getCommonTransactionIsolation() {
        return TransactionIsolationLevel.TRANSACTION_READ_COMMITTED;
    }

    @Nonnull
    protected TransactionIsolationLevel getSystemTransactionIsolation() {
        return TransactionIsolationLevel.TRANSACTION_READ_COMMITTED;
    }

    @Nonnull
    protected TransactionIsolationLevel getGlobalCursorTransactionIsolation() {
        return TransactionIsolationLevel.TRANSACTION_READ_COMMITTED;
    }
}

