/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.torod.db.backends.greenplum;

import com.torodb.torod.core.connection.exceptions.RetryTransactionException;
import com.torodb.torod.core.language.AttributeReference;
import com.torodb.torod.core.language.projection.Projection;
import com.torodb.torod.core.pojos.IndexedAttributes;
import com.torodb.torod.core.subdocument.SimpleSubDocTypeBuilderProvider;
import com.torodb.torod.core.subdocument.SubDocType;
import com.torodb.torod.db.backends.ArraySerializer;
import com.torodb.torod.db.backends.DatabaseInterface;
import com.torodb.torod.db.backends.converters.ScalarTypeToSqlType;
import com.torodb.torod.db.backends.converters.StructureConverter;
import com.torodb.torod.db.backends.converters.array.ValueToArrayConverterProvider;
import com.torodb.torod.db.backends.converters.array.ValueToArrayDataTypeProvider;
import com.torodb.torod.db.backends.converters.jooq.ValueToJooqConverterProvider;
import com.torodb.torod.db.backends.converters.jooq.ValueToJooqDataTypeProvider;
import com.torodb.torod.db.backends.converters.json.ValueToJsonConverterProvider;
import com.torodb.torod.db.backends.exceptions.InvalidDatabaseException;
import com.torodb.torod.db.backends.greenplum.GreenplumJsonArraySerializer;
import com.torodb.torod.db.backends.greenplum.GreenplumTorodbMeta;
import com.torodb.torod.db.backends.greenplum.converters.array.GreenplumValueToArrayConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.array.GreenplumValueToArrayDataTypeProvider;
import com.torodb.torod.db.backends.greenplum.converters.jooq.GreenplumValueToJooqConverterProvider;
import com.torodb.torod.db.backends.greenplum.converters.jooq.GreenplumValueToJooqDataTypeProvider;
import com.torodb.torod.db.backends.greenplum.converters.json.GreenplumValueToJsonConverterProvider;
import com.torodb.torod.db.backends.greenplum.meta.GreenplumIndexStorage;
import com.torodb.torod.db.backends.greenplum.meta.GreenplumStructuresCache;
import com.torodb.torod.db.backends.greenplum.tables.GreenplumCollectionsTable;
import com.torodb.torod.db.backends.meta.CollectionSchema;
import com.torodb.torod.db.backends.meta.IndexStorage;
import com.torodb.torod.db.backends.meta.StructuresCache;
import com.torodb.torod.db.backends.meta.TorodbMeta;
import com.torodb.torod.db.backends.sql.index.UnnamedDbIndex;
import com.torodb.torod.db.backends.tables.AbstractCollectionsTable;
import com.torodb.torod.db.backends.tables.SubDocTable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jooq.DSLContext;

@Singleton
public class GreenplumDatabaseInterface
implements DatabaseInterface {
    private static final long serialVersionUID = 484638503L;
    private final ValueToArrayConverterProvider valueToArrayConverterProvider = GreenplumValueToArrayConverterProvider.getInstance();
    private final ValueToArrayDataTypeProvider valueToArrayDataTypeProvider = GreenplumValueToArrayDataTypeProvider.getInstance();
    private final ValueToJooqConverterProvider valueToJooqConverterProvider = GreenplumValueToJooqConverterProvider.getInstance();
    private final ValueToJooqDataTypeProvider valueToJooqDataTypeProvider = GreenplumValueToJooqDataTypeProvider.getInstance();
    private final ValueToJsonConverterProvider valueToJsonConverterProvider = GreenplumValueToJsonConverterProvider.getInstance();
    private final ScalarTypeToSqlType scalarTypeToSqlType;
    @Nonnull
    private transient Provider<SubDocType.Builder> subDocTypeBuilderProvider;

    @Nonnull
    public ArraySerializer arraySerializer() {
        return ArraySerializatorHolder.INSTANCE;
    }

    @Inject
    public GreenplumDatabaseInterface(ScalarTypeToSqlType scalarTypeToSqlType, Provider<SubDocType.Builder> subDocTypeBuilderProvider) {
        this.scalarTypeToSqlType = scalarTypeToSqlType;
        this.subDocTypeBuilderProvider = subDocTypeBuilderProvider;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.subDocTypeBuilderProvider = new SimpleSubDocTypeBuilderProvider();
    }

    public GreenplumCollectionsTable getCollectionsTable() {
        return GreenplumCollectionsTable.COLLECTIONS;
    }

    public StructuresCache createStructuresCache(CollectionSchema colSchema, String schemaName, StructureConverter converter) {
        return new GreenplumStructuresCache(colSchema, schemaName, converter);
    }

    public IndexStorage createIndexStorage(String databaseName, CollectionSchema colSchema) {
        return new GreenplumIndexStorage(databaseName, colSchema, this);
    }

    public ValueToArrayConverterProvider getValueToArrayConverterProvider() {
        return this.valueToArrayConverterProvider;
    }

    public ValueToArrayDataTypeProvider getValueToArrayDataTypeProvider() {
        return this.valueToArrayDataTypeProvider;
    }

    @Nonnull
    public ValueToJooqConverterProvider getValueToJooqConverterProvider() {
        return this.valueToJooqConverterProvider;
    }

    @Nonnull
    public ValueToJooqDataTypeProvider getValueToJooqDataTypeProvider() {
        return this.valueToJooqDataTypeProvider;
    }

    @Nonnull
    public ValueToJsonConverterProvider getValueToJsonConverterProvider() {
        return this.valueToJsonConverterProvider;
    }

    @Nonnull
    public String escapeSchemaName(@Nonnull String collection) throws IllegalArgumentException {
        return GreenplumDatabaseInterface.filter(collection);
    }

    @Nonnull
    public String escapeAttributeName(@Nonnull String attributeName) throws IllegalArgumentException {
        return GreenplumDatabaseInterface.filter(attributeName);
    }

    @Nonnull
    public String escapeIndexName(@Nonnull String indexName) throws IllegalArgumentException {
        return GreenplumDatabaseInterface.filter(indexName);
    }

    private static String filter(String str) {
        if (str.length() > 63) {
            throw new IllegalArgumentException(str + " is too long to be a " + "valid PostgreSQL name. By default names must be shorter " + "than 64, but it has " + str.length() + " characters");
        }
        Pattern quotesPattern = Pattern.compile("(\"+)");
        Matcher matcher = quotesPattern.matcher(str);
        while (matcher.find()) {
            if ((matcher.end() - matcher.start() & 1) != 1) continue;
            throw new IllegalArgumentException("The name '" + str + "' is" + "illegal because contains an open quote at " + matcher.start());
        }
        return str;
    }

    public int getIntColumnType(ResultSet columns) throws SQLException {
        return columns.getInt("DATA_TYPE");
    }

    public String getStringColumnType(ResultSet columns) throws SQLException {
        return columns.getString("TYPE_NAME");
    }

    public ScalarTypeToSqlType getScalarTypeToSqlType() {
        return this.scalarTypeToSqlType;
    }

    @Nonnull
    private static StringBuilder fullTableName(@Nonnull String schemaName, @Nonnull String tableName) {
        return new StringBuilder().append("\"").append(schemaName).append("\"").append(".").append("\"").append(tableName).append("\"");
    }

    @Nonnull
    public ResultSet getColumns(DatabaseMetaData metadata, String schemaName, String tableName) throws SQLException {
        return metadata.getColumns("%", schemaName, tableName, null);
    }

    @Nonnull
    public ResultSet getIndexes(DatabaseMetaData metadata, String schemaName, String tableName) throws SQLException {
        return metadata.getIndexInfo("%", schemaName, tableName, false, false);
    }

    @Nonnull
    public UnnamedDbIndex getDbIndex(String colSchema, String tableName, Map.Entry<AttributeReference, IndexedAttributes.IndexType> entrySet) {
        List keys = entrySet.getKey().getKeys();
        switch (entrySet.getValue()) {
            case asc: 
            case desc: {
                return new UnnamedDbIndex(colSchema, tableName, ((AttributeReference.Key)keys.get(keys.size() - 1)).toString(), true);
            }
        }
        throw new UnsupportedOperationException("Index of type " + entrySet.getValue() + " is not supported.");
    }

    @Nonnull
    public String createCollectionsTableStatement(@Nonnull String schemaName, @Nonnull String tableName) {
        return "CREATE TABLE " + GreenplumDatabaseInterface.fullTableName(schemaName, tableName) + " (" + AbstractCollectionsTable.TableFields.NAME.name() + "             varchar     PRIMARY KEY     ," + AbstractCollectionsTable.TableFields.SCHEMA.name() + "           varchar     NOT NULL        ," + AbstractCollectionsTable.TableFields.CAPPED.name() + "           boolean     NOT NULL        ," + AbstractCollectionsTable.TableFields.MAX_SIZE.name() + "         int         NOT NULL        ," + AbstractCollectionsTable.TableFields.MAX_ELEMENTS.name() + "     int         NOT NULL        ," + AbstractCollectionsTable.TableFields.OTHER.name() + "            text                        ," + AbstractCollectionsTable.TableFields.STORAGE_ENGINE.name() + "   varchar     NOT NULL        " + ')';
    }

    @Nonnull
    public String createSchemaStatement(@Nonnull String schemaName) {
        return "CREATE SCHEMA " + "\"" + schemaName + "\"";
    }

    @Nonnull
    public String createIndexesTableStatement(@Nonnull String tableName, @Nonnull String indexNameColumn, @Nonnull String indexOptionsColumn) {
        return "CREATE TABLE " + tableName + " (" + indexNameColumn + "       varchar     PRIMARY KEY," + indexOptionsColumn + "    text        NOT NULL" + ")";
    }

    @Nonnull
    public String arrayUnnestParametrizedSelectStatement() {
        return "SELECT unnest(?)";
    }

    @Nonnull
    public String deleteDidsStatement(@Nonnull String schemaName, @Nonnull String tableName, @Nonnull String didColumnName) {
        return "DELETE FROM " + GreenplumDatabaseInterface.fullTableName(schemaName, tableName) + " WHERE (" + GreenplumDatabaseInterface.fullTableName(schemaName, tableName) + "." + didColumnName + " IN (" + this.arrayUnnestParametrizedSelectStatement() + ")" + ")";
    }

    public void setDeleteDidsStatementParameters(PreparedStatement ps, Collection<Integer> dids) throws SQLException {
        Connection connection = ps.getConnection();
        int maxInArray = 65535;
        Integer[] didsToDelete = dids.toArray(new Integer[dids.size()]);
        int i = 0;
        while (i < didsToDelete.length) {
            int toIndex = Math.min(i + 65535, didsToDelete.length);
            Object[] subDids = Arrays.copyOfRange(didsToDelete, i, toIndex);
            Array arr = connection.createArrayOf("integer", subDids);
            ps.setArray(1, arr);
            ps.addBatch();
            i = toIndex;
        }
    }

    @Nonnull
    public String dropSchemaStatement(@Nonnull String schemaName) {
        return "DROP SCHEMA " + "\"" + schemaName + "\"" + " CASCADE";
    }

    @Nonnull
    public String findDocsSelectStatement() {
        return "SELECT did, typeid, index, _json" + " FROM torodb.find_docs(?, ?, ?) ORDER BY did ASC";
    }

    @Nonnull
    public ResultSet getFindDocsSelectStatementResultSet(PreparedStatement ps) throws SQLException {
        return ps.executeQuery();
    }

    @Nonnull
    public DatabaseInterface.FindDocsSelectStatementRow getFindDocsSelectStatementRow(ResultSet rs) throws SQLException {
        return new PostgresSQLFindDocsSelectStatementRow(rs);
    }

    public void setFindDocsSelectStatementParameters(CollectionSchema colSchema, Integer[] requestedDocs, Projection projection, Connection c, PreparedStatement ps) throws SQLException {
        ps.setString(1, colSchema.getName());
        ps.setArray(2, c.createArrayOf("integer", requestedDocs));
        Object[] requiredTables = this.requiredTables(colSchema, projection);
        ps.setArray(3, c.createArrayOf("integer", requiredTables));
    }

    private Integer[] requiredTables(CollectionSchema colSchema, Projection projection) {
        Collection subDocTables = colSchema.getSubDocTables();
        Integer[] result = new Integer[subDocTables.size()];
        int i = 0;
        for (SubDocTable subDocTable : subDocTables) {
            result[i] = subDocTable.getTypeId();
            ++i;
        }
        return result;
    }

    @Nonnull
    public String createIndexStatement(@Nonnull String fullIndexName, @Nonnull String tableSchema, @Nonnull String tableName, @Nonnull String tableColumnName, boolean ascending) {
        return "CREATE INDEX " + "\"" + fullIndexName + "\"" + " ON " + "\"" + tableSchema + "\"" + "." + "\"" + tableName + "\"" + " (" + "\"" + tableColumnName + "\"" + ")";
    }

    @Nonnull
    public String dropIndexStatement(@Nonnull String schemaName, @Nonnull String indexName) {
        return "DROP INDEX " + "\"" + schemaName + "\"" + "." + "\"" + indexName + "\"";
    }

    @Nonnull
    public TorodbMeta initializeTorodbMeta(String databaseName, DSLContext dsl, DatabaseInterface databaseInterface) throws SQLException, IOException, InvalidDatabaseException {
        return new GreenplumTorodbMeta(databaseName, dsl, databaseInterface, this.subDocTypeBuilderProvider);
    }

    public void handleRetryException(SQLException sqlException) throws RetryTransactionException {
        if ("42P01".equals(sqlException.getSQLState()) && sqlException.getMessage().startsWith("ERROR: relation not found")) {
            throw new RetryTransactionException((Throwable)sqlException);
        }
        if (sqlException instanceof BatchUpdateException && "40001".equals(sqlException.getSQLState())) {
            throw new RetryTransactionException((Throwable)sqlException);
        }
    }

    private static class PostgresSQLFindDocsSelectStatementRow
    implements DatabaseInterface.FindDocsSelectStatementRow {
        private final int docid;
        private final Integer typeId;
        private final Integer index;
        private final String json;

        private PostgresSQLFindDocsSelectStatementRow(ResultSet rs) throws SQLException {
            this.docid = rs.getInt(1);
            Object typeId = rs.getObject(2);
            Object index = rs.getObject(3);
            this.json = rs.getString(4);
            if (typeId != null) {
                assert (typeId instanceof Integer);
                assert (index == null || index instanceof Integer);
                assert (this.json != null);
                if (index == null) {
                    index = 0;
                }
                this.typeId = (Integer)typeId;
                this.index = (Integer)index;
            } else {
                assert (index != null);
                assert (this.json == null);
                this.typeId = null;
                this.index = (Integer)index;
            }
        }

        public int getDocId() {
            return this.docid;
        }

        public Integer getTypeId() {
            return this.typeId;
        }

        public Integer getindex() {
            return this.index;
        }

        public String getJson() {
            return this.json;
        }

        public boolean isSubdocument() {
            return this.typeId != null;
        }

        public boolean isMetainfo() {
            return this.typeId == null;
        }
    }

    private static class ArraySerializatorHolder {
        private static final ArraySerializer INSTANCE = new GreenplumJsonArraySerializer();

        private ArraySerializatorHolder() {
        }
    }
}

