/*
 * Decompiled with CFR 0.152.
 */
package com.toomuchcoding.jsonassert;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.toomuchcoding.jsonassert.ArrayAssertion;
import com.toomuchcoding.jsonassert.ArrayValueAssertion;
import com.toomuchcoding.jsonassert.FieldAssertion;
import com.toomuchcoding.jsonassert.JsonAsserterConfiguration;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import com.toomuchcoding.jsonassert.ReadyToCheckAsserter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minidev.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonAsserter
implements JsonVerifiable {
    private static final Logger log = LoggerFactory.getLogger(JsonAsserter.class);
    protected final DocumentContext parsedJson;
    protected final LinkedList<String> jsonPathBuffer;
    protected final Object fieldName;
    protected final JsonAsserterConfiguration jsonAsserterConfiguration;

    protected JsonAsserter(DocumentContext parsedJson, LinkedList<String> jsonPathBuffer, Object fieldName, JsonAsserterConfiguration jsonAsserterConfiguration) {
        this.parsedJson = parsedJson;
        this.jsonPathBuffer = new LinkedList<String>(jsonPathBuffer);
        this.fieldName = fieldName;
        this.jsonAsserterConfiguration = jsonAsserterConfiguration;
    }

    @Override
    public JsonVerifiable contains(Object value) {
        FieldAssertion asserter = new FieldAssertion(this.parsedJson, this.jsonPathBuffer, value, this.jsonAsserterConfiguration);
        asserter.jsonPathBuffer.offer("[*]");
        return asserter;
    }

    @Override
    public FieldAssertion field(Object value) {
        FieldAssertion asserter = new FieldAssertion(this.parsedJson, this.jsonPathBuffer, value, this.jsonAsserterConfiguration);
        asserter.jsonPathBuffer.offer("." + String.valueOf(value));
        return asserter;
    }

    @Override
    public FieldAssertion field(String ... fields) {
        JsonAsserter assertion = null;
        for (String field : fields) {
            assertion = assertion == null ? this.field((Object)field) : assertion.field((Object)field);
        }
        return assertion;
    }

    @Override
    public ArrayAssertion array(Object value) {
        if (value == null) {
            return this.array();
        }
        ArrayAssertion asserter = new ArrayAssertion(this.parsedJson, this.jsonPathBuffer, value, this.jsonAsserterConfiguration);
        asserter.jsonPathBuffer.offer("." + String.valueOf(value) + "[*]");
        return asserter;
    }

    @Override
    public ArrayValueAssertion arrayField() {
        String peekedLast = this.jsonPathBuffer.peekLast();
        if (!"[*]".equals(peekedLast) && peekedLast.endsWith("[*]")) {
            String last = this.jsonPathBuffer.pollLast();
            this.jsonPathBuffer.offer(last.replace("[*]", ""));
        }
        return new ArrayValueAssertion(this.parsedJson, this.jsonPathBuffer, this.jsonAsserterConfiguration);
    }

    @Override
    public ArrayAssertion array() {
        ArrayAssertion asserter = new ArrayAssertion(this.parsedJson, this.jsonPathBuffer, this.jsonAsserterConfiguration);
        asserter.jsonPathBuffer.offer("[*]");
        return asserter;
    }

    @Override
    public JsonVerifiable elementWithIndex(int index) {
        ArrayAssertion asserter = new ArrayAssertion(this.parsedJson, this.jsonPathBuffer, this.jsonAsserterConfiguration);
        asserter.jsonPathBuffer.offer("[" + index + "]");
        return asserter;
    }

    @Override
    public JsonVerifiable isEqualTo(String value) {
        if (value == null) {
            return this.isNull();
        }
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.removeLast();
        readyToCheck.jsonPathBuffer.offer("[?(@." + String.valueOf(this.fieldName) + " == " + this.wrapValueWithSingleQuotes(value) + ")]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    private void updateCurrentBuffer(JsonAsserter readyToCheck) {
        this.jsonPathBuffer.clear();
        this.jsonPathBuffer.addAll(readyToCheck.jsonPathBuffer);
    }

    @Override
    public JsonVerifiable isEqualTo(Object value) {
        if (value == null) {
            return this.isNull();
        }
        if (value instanceof Number) {
            return this.isEqualTo((Number)value);
        }
        if (value instanceof Boolean) {
            return this.isEqualTo((Boolean)value);
        }
        if (value instanceof Pattern) {
            return this.matches(((Pattern)value).pattern());
        }
        return this.isEqualTo(value.toString());
    }

    @Override
    public JsonVerifiable isEqualTo(Number value) {
        if (value == null) {
            return this.isNull();
        }
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.removeLast();
        readyToCheck.jsonPathBuffer.offer("[?(@." + String.valueOf(this.fieldName) + " == " + value + ")]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable isNull() {
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.removeLast();
        readyToCheck.jsonPathBuffer.offer("[?(@." + String.valueOf(this.fieldName) + " == null)]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable matches(String value) {
        if (value == null) {
            return this.isNull();
        }
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.removeLast();
        readyToCheck.jsonPathBuffer.offer("[?(@." + String.valueOf(this.fieldName) + " =~ /" + JsonAsserter.stringWithEscapedSingleQuotesForRegex(value) + "/)]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable isEqualTo(Boolean value) {
        if (value == null) {
            return this.isNull();
        }
        ReadyToCheckAsserter readyToCheck = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheck.jsonPathBuffer.removeLast();
        readyToCheck.jsonPathBuffer.offer("[?(@." + String.valueOf(this.fieldName) + " == " + String.valueOf(value) + ")]");
        this.updateCurrentBuffer(readyToCheck);
        readyToCheck.checkBufferedJsonPathString();
        return readyToCheck;
    }

    @Override
    public JsonVerifiable isEmpty() throws IllegalStateException {
        if (this.jsonAsserterConfiguration.ignoreJsonPathException) {
            this.logOverridingWarning();
            return this;
        }
        String jsonPathString = this.createJsonPathString();
        JSONArray array = this.jsonPathToArray(jsonPathString);
        if (array.size() != 0) {
            throw new IllegalStateException("Parsed JSON [" + this.parsedJson.jsonString() + "] with the JSON path [" + jsonPathString + "] is not empty!");
        }
        return this;
    }

    @Override
    public JsonVerifiable value() {
        ReadyToCheckAsserter readyToCheckAsserter = new ReadyToCheckAsserter(this.parsedJson, this.jsonPathBuffer, this.fieldName, this.jsonAsserterConfiguration);
        readyToCheckAsserter.checkBufferedJsonPathString();
        return readyToCheckAsserter;
    }

    @Override
    public JsonVerifiable withoutThrowingException() {
        this.jsonAsserterConfiguration.ignoreJsonPathException = true;
        return this;
    }

    private JSONArray check(String jsonPathString) {
        if (this.jsonAsserterConfiguration.ignoreJsonPathException) {
            this.logOverridingWarning();
            return null;
        }
        JSONArray array = this.jsonPathToArray(jsonPathString);
        if (array.isEmpty() || this.containsEmptyElementsOnly(array)) {
            throw new IllegalStateException("Parsed JSON [" + this.parsedJson.jsonString() + "] doesn't match the JSON path [" + jsonPathString + "]");
        }
        return array;
    }

    private boolean containsEmptyElementsOnly(JSONArray array) {
        boolean empty = true;
        for (Object o : array) {
            if (o instanceof Map) {
                empty = empty && ((Map)o).isEmpty();
                continue;
            }
            if (o instanceof List) {
                empty = empty && ((List)o).isEmpty();
                continue;
            }
            if (o instanceof JSONArray) {
                empty = empty && this.containsEmptyElementsOnly((JSONArray)o);
                continue;
            }
            if (o == null) continue;
            empty = false;
        }
        return empty;
    }

    private JSONArray jsonPathToArray(String jsonPathString) {
        return this.parseJsonPathAsArray(jsonPathString);
    }

    private JSONArray parseJsonPathAsArray(String jsonPathString) {
        try {
            return (JSONArray)this.parsedJson.read(jsonPathString, JSONArray.class, new Predicate[0]);
        }
        catch (Exception e) {
            log.error("Exception occurred while trying to match JSON Path [{}]", (Object)jsonPathString, (Object)e);
            throw new RuntimeException(e);
        }
    }

    JSONArray checkBufferedJsonPathString() {
        return this.check(this.createJsonPathString());
    }

    private String createJsonPathString() {
        LinkedList<String> queue = new LinkedList<String>(this.jsonPathBuffer);
        StringBuilder stringBuffer = new StringBuilder();
        while (!queue.isEmpty()) {
            stringBuffer.append(queue.remove());
        }
        return stringBuffer.toString();
    }

    @Override
    public String jsonPath() {
        return this.createJsonPathString();
    }

    @Override
    public void matchesJsonPath(String jsonPath) {
        this.check(jsonPath);
    }

    @Override
    public JsonVerifiable hasSize(int size) {
        if (this.jsonAsserterConfiguration.ignoreJsonPathException) {
            this.logOverridingWarning();
            return this;
        }
        JSONArray array = this.checkBufferedJsonPathString();
        if (array == null || array.size() != size) {
            throw new IllegalStateException("Parsed JSON <" + this.parsedJson.jsonString() + "> doesn't have the size <" + size + "> for JSON path <" + this.createJsonPathString() + ">. The size is <" + (array == null ? null : Integer.valueOf(array.size())) + ">");
        }
        return this;
    }

    private void logOverridingWarning() {
        log.trace("WARNING!!! Overriding verification of the JSON Path. Your tests may pass even though they shouldn't");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonAsserter that = (JsonAsserter)o;
        if (this.jsonPathBuffer != null ? !this.jsonPathBuffer.equals(that.jsonPathBuffer) : that.jsonPathBuffer != null) {
            return false;
        }
        return this.fieldName != null ? this.fieldName.equals(that.fieldName) : that.fieldName == null;
    }

    public int hashCode() {
        int result = this.jsonPathBuffer != null ? this.jsonPathBuffer.hashCode() : 0;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "\\nAsserter{\n    jsonPathBuffer=" + String.valueOf(this.jsonPathBuffer) + "\n}";
    }

    @Override
    public boolean isIteratingOverNamelessArray() {
        return false;
    }

    @Override
    public boolean isIteratingOverArray() {
        return false;
    }

    @Override
    public boolean isAssertingAValueInArray() {
        return false;
    }

    protected static String stringWithEscapedSingleQuotes(Object object) {
        String stringValue = object.toString();
        return stringValue.replaceAll("'", "\\\\'");
    }

    protected static String stringWithEscapedSingleQuotesForRegex(Object object) {
        return JsonAsserter.stringWithEscapedSingleQuotes(object).replace("/", "\\/");
    }

    protected String wrapValueWithSingleQuotes(Object value) {
        return value instanceof String ? "'" + JsonAsserter.stringWithEscapedSingleQuotes(value) + "'" : value.toString();
    }

    @Override
    public <T> T read(Class<T> clazz) {
        Object readObject = this.parsedJson.read(this.jsonPath(), new Predicate[0]);
        if (readObject instanceof JSONArray) {
            JSONArray array = (JSONArray)this.parsedJson.read(this.jsonPath(), new Predicate[0]);
            if (array.size() == 1) {
                return (T)array.get(0);
            }
            return (T)array;
        }
        return (T)readObject;
    }
}

