/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaClassParent;
import com.thoughtworks.qdox.model.WildcardType;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.parser.structs.WildcardTypeDef;
import java.io.Serializable;

public class Type
implements Comparable,
Serializable {
    public static final Type[] EMPTY_ARRAY = new Type[0];
    public static final Type VOID = new Type("void");
    private String name;
    private JavaClassParent context;
    private String fullName;
    private int dimensions;
    private Type[] actualArgumentTypes;

    public Type(String fullName, String name, int dimensions, JavaClassParent context) {
        this.fullName = fullName;
        this.name = name;
        this.dimensions = dimensions;
        this.context = context;
    }

    public Type(String fullName, TypeDef typeDef, int dimensions, JavaClassParent context) {
        this.fullName = fullName;
        this.name = typeDef.name;
        this.dimensions = typeDef.dimensions + dimensions;
        if (typeDef.actualArgumentTypes != null && !typeDef.actualArgumentTypes.isEmpty()) {
            this.actualArgumentTypes = new Type[typeDef.actualArgumentTypes.size()];
            for (int index = 0; index < typeDef.actualArgumentTypes.size(); ++index) {
                this.actualArgumentTypes[index] = Type.createUnresolved((TypeDef)typeDef.actualArgumentTypes.get(index), context);
            }
        }
        this.context = context;
    }

    public Type(String fullName, int dimensions, JavaClassParent context) {
        this(fullName, (String)null, dimensions, context);
    }

    public Type(String fullName, int dimensions) {
        this(fullName, dimensions, null);
    }

    public Type(String fullName) {
        this(fullName, 0);
    }

    public static Type createUnresolved(String name, int dimensions, JavaClassParent context) {
        return new Type(null, name, dimensions, context);
    }

    public static Type createUnresolved(TypeDef typeDef, int dimensions, JavaClassParent context) {
        return new Type(null, typeDef, dimensions, context);
    }

    public static Type createUnresolved(TypeDef typeDef, JavaClassParent context) {
        if (typeDef instanceof WildcardTypeDef) {
            return new WildcardType((WildcardTypeDef)typeDef, context);
        }
        return new Type(null, typeDef, 0, context);
    }

    public JavaClassParent getJavaClassParent() {
        return this.context;
    }

    public String getValue() {
        return this.isResolved() ? this.fullName : this.name;
    }

    public String getGenericValue() {
        StringBuffer result = new StringBuffer(this.getValue());
        if (this.actualArgumentTypes != null && this.actualArgumentTypes.length > 0) {
            result.append("<");
            for (int index = 0; index < this.actualArgumentTypes.length; ++index) {
                result.append(this.actualArgumentTypes[index].getGenericValue());
                if (index + 1 == this.actualArgumentTypes.length) continue;
                result.append(",");
            }
            result.append(">");
        }
        return result.toString();
    }

    public boolean isResolved() {
        if (this.fullName == null && this.context != null) {
            this.fullName = this.context.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Type)) {
            return 0;
        }
        return this.getValue().compareTo(((Type)o).getValue());
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public String toString() {
        if (this.dimensions == 0) {
            return this.getValue();
        }
        StringBuffer buff = new StringBuffer(this.getValue());
        for (int i = 0; i < this.dimensions; ++i) {
            buff.append("[]");
        }
        String result = buff.toString();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Type t = (Type)obj;
        return this.getValue().equals(t.getValue()) && t.getDimensions() == this.getDimensions();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public JavaClass getJavaClass() {
        ClassLibrary classLibrary;
        JavaClass result = null;
        JavaClassParent javaClassParent = this.getJavaClassParent();
        if (javaClassParent != null && (result = javaClassParent.getNestedClassByName(this.getValue())) == null && (classLibrary = javaClassParent.getClassLibrary()) != null) {
            result = classLibrary.getClassByName(this.getValue());
        }
        return result;
    }

    public boolean isA(Type type) {
        if (this.equals(type)) {
            return true;
        }
        JavaClass javaClass = this.getJavaClass();
        if (javaClass != null) {
            Type[] implementz = javaClass.getImplements();
            for (int i = 0; i < implementz.length; ++i) {
                if (!implementz[i].isA(type)) continue;
                return true;
            }
            Type supertype = javaClass.getSuperClass();
            if (supertype != null && supertype.isA(type)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrimitive() {
        String value = this.getValue();
        if (value == null || value.length() == 0 || value.indexOf(46) > -1) {
            return false;
        }
        return "boolean".equals(value) || "byte".equals(value) || "char".equals(value) || "short".equals(value) || "int".equals(value) || "long".equals(value) || "float".equals(value) || "double".equals(value);
    }

    public boolean isVoid() {
        return "void".equals(this.getValue());
    }
}

