/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework;

import com.sun.jersey.api.core.ClassNamesResourceConfig;
import com.sun.jersey.api.core.ClasspathResourceConfig;
import com.sun.jersey.api.core.PackagesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.HashMap;
import java.util.Map;

public class LowLevelAppDescriptor
extends AppDescriptor {
    private final ResourceConfig rc;
    private final String contextPath;

    private LowLevelAppDescriptor(Builder b) {
        super(b);
        this.contextPath = b.contextPath;
        this.rc = b.rc;
    }

    public ResourceConfig getResourceConfig() {
        return this.rc;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public static LowLevelAppDescriptor transform(WebAppDescriptor wad) {
        if (wad.getInitParams().get("com.sun.jersey.config.property.packages") != null) {
            HashMap<String, String> init = new HashMap<String, String>(wad.getInitParams());
            PackagesResourceConfig packagesResourceConfig = new PackagesResourceConfig(init);
            LowLevelAppDescriptor.populateResourceConfigFeatures((ResourceConfig)packagesResourceConfig, wad.getInitParams());
            return new Builder((ResourceConfig)packagesResourceConfig).build();
        }
        if (wad.getInitParams().get("com.sun.jersey.config.property.classnames") != null) {
            String classes = wad.getInitParams().get("com.sun.jersey.config.property.classnames");
            ClassNamesResourceConfig classNamesResourceConfig = new ClassNamesResourceConfig(new String[]{classes});
            LowLevelAppDescriptor.populateResourceConfigFeatures((ResourceConfig)classNamesResourceConfig, wad.getInitParams());
            return new Builder((ResourceConfig)classNamesResourceConfig).build();
        }
        if (wad.getInitParams().get("com.sun.jersey.config.property.classpath") != null) {
            String classpath = wad.getInitParams().get("com.sun.jersey.config.property.classpath");
            ClasspathResourceConfig classpathResourceConfig = new ClasspathResourceConfig(classpath.split(";"));
            LowLevelAppDescriptor.populateResourceConfigFeatures((ResourceConfig)classpathResourceConfig, wad.getInitParams());
            return new Builder((ResourceConfig)classpathResourceConfig).build();
        }
        return null;
    }

    private static void populateResourceConfigFeatures(ResourceConfig rc, Map<String, String> initParams) {
        for (String initParam : initParams.keySet()) {
            if (!initParams.get(initParam).equalsIgnoreCase("true") && !initParams.get(initParam).equalsIgnoreCase("false")) continue;
            rc.getFeatures().put(initParam, new Boolean(initParams.get(initParam)));
        }
    }

    public static class Builder
    extends AppDescriptor.AppDescriptorBuilder<Builder, LowLevelAppDescriptor> {
        protected final ResourceConfig rc;
        protected String contextPath = "";

        public Builder(String ... packages) throws IllegalArgumentException {
            if (packages == null) {
                throw new IllegalArgumentException("The packages must not be null");
            }
            this.rc = new PackagesResourceConfig(packages);
        }

        public Builder(Class ... classes) throws IllegalArgumentException {
            if (classes == null) {
                throw new IllegalArgumentException("The classes must not be null");
            }
            this.rc = new ClassNamesResourceConfig(classes);
        }

        public Builder(ResourceConfig rc) {
            if (rc == null) {
                throw new IllegalArgumentException("The resource configuration must not be null");
            }
            this.rc = rc;
        }

        public Builder contextPath(String contextPath) {
            if (contextPath == null) {
                throw new IllegalArgumentException("The context path must not be null");
            }
            this.contextPath = contextPath;
            return this;
        }

        @Override
        public LowLevelAppDescriptor build() {
            LowLevelAppDescriptor lld = new LowLevelAppDescriptor(this);
            this.reset();
            return lld;
        }

        @Override
        protected void reset() {
            super.reset();
            this.contextPath = "";
        }
    }
}

