/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.allocations;

import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.internal.Internal;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Connection {
    private final ConnectionPool pool;
    private final List<StreamAllocationReference> allocations = new ArrayList<StreamAllocationReference>();
    private int allocationLimit = 1;
    private boolean noNewAllocations;
    long idleAt = Long.MAX_VALUE;

    public Connection(ConnectionPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamAllocation reserve(String name) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.noNewAllocations || this.allocations.size() >= this.allocationLimit) {
                return null;
            }
            StreamAllocation result = new StreamAllocation();
            this.allocations.add(new StreamAllocationReference(result, name));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StreamAllocation streamAllocation) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (streamAllocation.released) {
                throw new IllegalStateException("already released");
            }
            streamAllocation.released = true;
            if (streamAllocation.stream == null) {
                this.remove(streamAllocation);
            }
        }
    }

    private void remove(StreamAllocation streamAllocation) {
        int size = this.allocations.size();
        for (int i = 0; i < size; ++i) {
            StreamAllocationReference weakReference = this.allocations.get(i);
            if (weakReference.get() != streamAllocation) continue;
            this.allocations.remove(i);
            if (this.allocations.isEmpty()) {
                this.idleAt = System.nanoTime();
            }
            return;
        }
        throw new IllegalArgumentException("unexpected allocation: " + streamAllocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noNewStreams() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            this.noNewAllocations = true;
            for (int i = 0; i < this.allocations.size(); ++i) {
                this.allocations.get(i).rescind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllocationLimit(int allocationLimit) {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (allocationLimit < 0) {
                throw new IllegalArgumentException();
            }
            this.allocationLimit = allocationLimit;
            for (int i = allocationLimit; i < this.allocations.size(); ++i) {
                this.allocations.get(i).rescind();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pruneLeakedAllocations() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            Iterator<StreamAllocationReference> i = this.allocations.iterator();
            while (i.hasNext()) {
                StreamAllocationReference reference = i.next();
                if (reference.get() != null) continue;
                Internal.logger.warning("Call " + reference.name + " leaked a connection. Did you forget to close a response body?");
                this.noNewAllocations = true;
                i.remove();
                if (!this.allocations.isEmpty()) continue;
                this.idleAt = System.nanoTime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            return this.allocations.size();
        }
    }

    public static class Stream {
        public final String name;

        public Stream(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private static final class StreamAllocationReference
    extends WeakReference<StreamAllocation> {
        private final String name;

        public StreamAllocationReference(StreamAllocation streamAllocation, String name) {
            super(streamAllocation);
            this.name = name;
        }

        public void rescind() {
            StreamAllocation streamAllocation = (StreamAllocation)this.get();
            if (streamAllocation != null) {
                streamAllocation.rescinded = true;
            }
        }
    }

    public final class StreamAllocation {
        private boolean released;
        private Stream stream;
        private boolean rescinded;

        private StreamAllocation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Stream newStream(String name) {
            ConnectionPool connectionPool = Connection.this.pool;
            synchronized (connectionPool) {
                if (this.stream != null || this.released) {
                    throw new IllegalStateException();
                }
                if (this.rescinded) {
                    return null;
                }
                this.stream = new Stream(name);
                return this.stream;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void streamComplete(Stream stream) {
            ConnectionPool connectionPool = Connection.this.pool;
            synchronized (connectionPool) {
                if (stream == null || stream != this.stream) {
                    throw new IllegalArgumentException();
                }
                this.stream = null;
                if (this.released) {
                    Connection.this.remove(this);
                }
            }
        }
    }
}

