/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.util;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import java.util.Arrays;

public class GeohashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int[] BASE_32_IDX;
    public static final int MAX_PRECISION = 24;
    private static final int[] BITS;
    private static final double[] hashLenToLatHeight;
    private static final double[] hashLenToLonWidth;

    private GeohashUtils() {
    }

    public static String encodeLatLon(double latitude, double longitude) {
        return GeohashUtils.encodeLatLon(latitude, longitude, 12);
    }

    public static String encodeLatLon(double latitude, double longitude, int precision) {
        double[] latInterval = new double[]{-90.0, 90.0};
        double[] lngInterval = new double[]{-180.0, 180.0};
        StringBuilder geohash = new StringBuilder(precision);
        boolean isEven = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < precision) {
            double mid = 0.0;
            if (isEven) {
                mid = (lngInterval[0] + lngInterval[1]) / 2.0;
                if (longitude > mid) {
                    ch |= BITS[bit];
                    lngInterval[0] = mid;
                } else {
                    lngInterval[1] = mid;
                }
            } else {
                mid = (latInterval[0] + latInterval[1]) / 2.0;
                if (latitude > mid) {
                    ch |= BITS[bit];
                    latInterval[0] = mid;
                } else {
                    latInterval[1] = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(BASE_32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public static Point decode(String geohash, SpatialContext ctx) {
        Rectangle rect = GeohashUtils.decodeBoundary(geohash, ctx);
        double latitude = (rect.getMinY() + rect.getMaxY()) / 2.0;
        double longitude = (rect.getMinX() + rect.getMaxX()) / 2.0;
        return ctx.makePoint(longitude, latitude);
    }

    public static Rectangle decodeBoundary(String geohash, SpatialContext ctx) {
        double minY = -90.0;
        double maxY = 90.0;
        double minX = -180.0;
        double maxX = 180.0;
        boolean isEven = true;
        for (int i = 0; i < geohash.length(); ++i) {
            char c = geohash.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            int cd = BASE_32_IDX[c - BASE_32[0]];
            for (int mask : BITS) {
                if (isEven) {
                    if ((cd & mask) != 0) {
                        minX = (minX + maxX) / 2.0;
                    } else {
                        maxX = (minX + maxX) / 2.0;
                    }
                } else if ((cd & mask) != 0) {
                    minY = (minY + maxY) / 2.0;
                } else {
                    maxY = (minY + maxY) / 2.0;
                }
                isEven = !isEven;
            }
        }
        return ctx.makeRect(minX, maxX, minY, maxY);
    }

    public static String[] getSubGeohashes(String baseGeohash) {
        String[] hashes = new String[BASE_32.length];
        for (int i = 0; i < BASE_32.length; ++i) {
            char c = BASE_32[i];
            hashes[i] = baseGeohash + c;
        }
        return hashes;
    }

    public static double[] lookupDegreesSizeForHashLen(int hashLen) {
        return new double[]{hashLenToLatHeight[hashLen], hashLenToLonWidth[hashLen]};
    }

    public static int lookupHashLenForWidthHeight(double width, double height) {
        for (int len = 1; len <= 24; ++len) {
            double latHeight = hashLenToLatHeight[len];
            double lonWidth = hashLenToLonWidth[len];
            if (!(latHeight < height) && !(lonWidth < width)) continue;
            return len - 1;
        }
        return 24;
    }

    static {
        BITS = new int[]{16, 8, 4, 2, 1};
        BASE_32_IDX = new int[BASE_32[BASE_32.length - 1] - BASE_32[0] + 1];
        assert (BASE_32_IDX.length < 100);
        Arrays.fill(BASE_32_IDX, -500);
        for (int i = 0; i < BASE_32.length; ++i) {
            GeohashUtils.BASE_32_IDX[GeohashUtils.BASE_32[i] - GeohashUtils.BASE_32[0]] = i;
        }
        hashLenToLatHeight = new double[25];
        hashLenToLonWidth = new double[25];
        GeohashUtils.hashLenToLatHeight[0] = 180.0;
        GeohashUtils.hashLenToLonWidth[0] = 360.0;
        boolean even = false;
        for (int i = 1; i <= 24; ++i) {
            GeohashUtils.hashLenToLatHeight[i] = hashLenToLatHeight[i - 1] / (double)(even ? 8 : 4);
            GeohashUtils.hashLenToLonWidth[i] = hashLenToLonWidth[i - 1] / (double)(even ? 4 : 8);
            even = !even;
        }
    }
}

