/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.simple;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.simple.PointImpl;

public class RectangleImpl
implements Rectangle {
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;

    public RectangleImpl(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        assert (minY <= maxY);
    }

    public RectangleImpl(Rectangle r) {
        this(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY());
    }

    @Override
    public boolean hasArea() {
        return this.maxX != this.minX && this.maxY != this.minY;
    }

    @Override
    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    @Override
    public boolean getCrossesDateLine() {
        return this.minX > this.maxX;
    }

    @Override
    public double getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public double getWidth() {
        double w = this.maxX - this.minX;
        if (w < 0.0) assert ((w += 360.0) >= 0.0);
        return w;
    }

    @Override
    public double getMaxX() {
        return this.maxX;
    }

    @Override
    public double getMaxY() {
        return this.maxY;
    }

    @Override
    public double getMinX() {
        return this.minX;
    }

    @Override
    public double getMinY() {
        return this.minY;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this;
    }

    @Override
    public SpatialRelation relate(Shape other, SpatialContext ctx) {
        if (other instanceof Point) {
            return this.relate((Point)other, ctx);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other, ctx);
        }
        return other.relate(this, ctx).transpose();
    }

    public SpatialRelation relate(Point point, SpatialContext ctx) {
        if (point.getY() > this.getMaxY() || point.getY() < this.getMinY() || (this.getCrossesDateLine() ? point.getX() < this.minX && point.getX() > this.maxX : point.getX() < this.minX || point.getX() > this.maxX)) {
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.CONTAINS;
    }

    public SpatialRelation relate(Rectangle rect, SpatialContext ctx) {
        SpatialRelation yIntersect = this.relate_yRange(rect.getMinY(), rect.getMaxY(), ctx);
        if (yIntersect == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        SpatialRelation xIntersect = this.relate_xRange(rect.getMinX(), rect.getMaxX(), ctx);
        if (xIntersect == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        if (xIntersect == yIntersect) {
            return xIntersect;
        }
        if (this.getMinX() == rect.getMinX() && this.getMaxX() == rect.getMaxX()) {
            return yIntersect;
        }
        if (this.getMinY() == rect.getMinY() && this.getMaxY() == rect.getMaxY()) {
            return xIntersect;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public SpatialRelation relate_yRange(double ext_minY, double ext_maxY, SpatialContext ctx) {
        if (ext_minY > this.maxY || ext_maxY < this.minY) {
            return SpatialRelation.DISJOINT;
        }
        if (ext_minY >= this.minY && ext_maxY <= this.maxY) {
            return SpatialRelation.CONTAINS;
        }
        if (ext_minY <= this.minY && ext_maxY >= this.maxY) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public SpatialRelation relate_xRange(double ext_minX, double ext_maxX, SpatialContext ctx) {
        double minX = this.minX;
        double maxX = this.maxX;
        if (ctx.isGeo()) {
            double ext_width = ext_maxX - ext_minX;
            if (ext_width < 0.0) {
                ext_width += 360.0;
            }
            ext_maxX = ext_width < 360.0 ? ext_minX + ext_width : 540.0;
            maxX = this.getWidth() < 360.0 ? minX + this.getWidth() : 540.0;
            if (maxX < ext_minX) {
                minX += 360.0;
                maxX += 360.0;
            } else if (ext_maxX < minX) {
                ext_minX += 360.0;
                ext_maxX += 360.0;
            }
        }
        if (ext_minX > maxX || ext_maxX < minX) {
            return SpatialRelation.DISJOINT;
        }
        if (ext_minX >= minX && ext_maxX <= maxX) {
            return SpatialRelation.CONTAINS;
        }
        if (ext_minX <= minX && ext_maxX >= maxX) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return "Rect(minX=" + this.minX + ",maxX=" + this.maxX + ",minY=" + this.minY + ",maxY=" + this.maxY + ")";
    }

    @Override
    public Point getCenter() {
        double y = this.getHeight() / 2.0 + this.minY;
        double x = this.getWidth() / 2.0 + this.minX;
        if (this.minX > this.maxX) {
            x = DistanceUtils.normLonDEG(x);
        }
        return new PointImpl(x, y);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RectangleImpl rectangle = (RectangleImpl)o;
        if (Double.compare(rectangle.maxX, this.maxX) != 0) {
            return false;
        }
        if (Double.compare(rectangle.maxY, this.maxY) != 0) {
            return false;
        }
        if (Double.compare(rectangle.minX, this.minX) != 0) {
            return false;
        }
        return Double.compare(rectangle.minY, this.minY) == 0;
    }

    public int hashCode() {
        long temp = this.minX != 0.0 ? Double.doubleToLongBits(this.minX) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.maxX != 0.0 ? Double.doubleToLongBits(this.maxX) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.minY != 0.0 ? Double.doubleToLongBits(this.minY) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.maxY != 0.0 ? Double.doubleToLongBits(this.maxY) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

