/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.simple;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.simple.RectangleImpl;

public class PointImpl
implements Point {
    private final double x;
    private final double y;

    public PointImpl(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public Rectangle getBoundingBox() {
        return new RectangleImpl(this.x, this.x, this.y, this.y);
    }

    @Override
    public PointImpl getCenter() {
        return this;
    }

    @Override
    public SpatialRelation relate(Shape other, SpatialContext ctx) {
        if (other instanceof Point) {
            return this.equals(other) ? SpatialRelation.INTERSECTS : SpatialRelation.DISJOINT;
        }
        return other.relate(this, ctx).transpose();
    }

    @Override
    public boolean hasArea() {
        return false;
    }

    public String toString() {
        return "Pt(x=" + this.x + ",y=" + this.y + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointImpl point = (PointImpl)o;
        if (Double.compare(point.x, this.x) != 0) {
            return false;
        }
        return Double.compare(point.y, this.y) == 0;
    }

    public int hashCode() {
        long temp = this.x != 0.0 ? Double.doubleToLongBits(this.x) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.y != 0.0 ? Double.doubleToLongBits(this.y) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

