/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.simple;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.simple.CircleImpl;

public class GeoCircleImpl
extends CircleImpl {
    private final double distDEG;
    private final GeoCircleImpl inverseCircle;
    private final double horizAxisY;

    public GeoCircleImpl(Point p, double dist, SpatialContext ctx) {
        super(p, dist, ctx);
        assert (ctx.isGeo());
        this.distDEG = ctx.getDistCalc().distanceToDegrees(this.distance);
        if (this.distDEG > 90.0) {
            assert (this.enclosingBox.getWidth() == 360.0);
            double backDistDEG = 180.0 - this.distDEG;
            if (backDistDEG >= 0.0) {
                double backDistance = ctx.getDistCalc().degreesToDistance(backDistDEG);
                Point backPoint = ctx.makePoint(this.getCenter().getX() + 180.0, this.getCenter().getY() + 180.0);
                this.inverseCircle = new GeoCircleImpl(backPoint, backDistance, ctx);
            } else {
                this.inverseCircle = null;
            }
            this.horizAxisY = this.getCenter().getY();
        } else {
            this.inverseCircle = null;
            double _horizAxisY = ctx.getDistCalc().calcBoxByDistFromPtHorizAxis(this.getCenter(), this.distance, ctx);
            this.horizAxisY = _horizAxisY > this.enclosingBox.getMaxY() ? this.enclosingBox.getMaxY() : (_horizAxisY < this.enclosingBox.getMinY() ? this.enclosingBox.getMinY() : _horizAxisY);
        }
    }

    @Override
    protected double getYAxis() {
        return this.horizAxisY;
    }

    @Override
    protected SpatialRelation relateRectanglePhase2(Rectangle r, SpatialRelation bboxSect, SpatialContext ctx) {
        if (r.getWidth() == 360.0) {
            return SpatialRelation.INTERSECTS;
        }
        if (this.inverseCircle != null) {
            return this.inverseCircle.relate(r, ctx).inverse();
        }
        if (this.enclosingBox.getWidth() == 360.0) {
            return this.relateRectangleCircleWrapsPole(r, ctx);
        }
        if (!this.enclosingBox.getCrossesDateLine() && !r.getCrossesDateLine()) {
            return super.relateRectanglePhase2(r, bboxSect, ctx);
        }
        int cornersIntersect = this.numCornersIntersect(r);
        if (cornersIntersect == 4) {
            SpatialRelation xIntersect = r.relate_xRange(this.enclosingBox.getMinX(), this.enclosingBox.getMaxX(), ctx);
            if (xIntersect == SpatialRelation.WITHIN) {
                return SpatialRelation.CONTAINS;
            }
            return SpatialRelation.INTERSECTS;
        }
        if (cornersIntersect > 0) {
            return SpatialRelation.INTERSECTS;
        }
        if (r.relate_yRange(this.getYAxis(), this.getYAxis(), ctx).intersects() && r.relate_xRange(this.enclosingBox.getMinX(), this.enclosingBox.getMaxX(), ctx).intersects()) {
            return SpatialRelation.INTERSECTS;
        }
        if (r.relate_xRange(this.getXAxis(), this.getXAxis(), ctx).intersects()) {
            double yTop = this.getCenter().getY() + this.distDEG;
            assert (yTop <= 90.0);
            double yBot = this.getCenter().getY() - this.distDEG;
            assert (yBot >= -90.0);
            if (r.relate_yRange(yBot, yTop, ctx).intersects()) {
                return SpatialRelation.INTERSECTS;
            }
        }
        return SpatialRelation.DISJOINT;
    }

    private SpatialRelation relateRectangleCircleWrapsPole(Rectangle r, SpatialContext ctx) {
        if (this.distDEG == 180.0) {
            return SpatialRelation.CONTAINS;
        }
        double yTop = this.getCenter().getY() + this.distDEG;
        if (yTop > 90.0) {
            double yTopOverlap = yTop - 90.0;
            assert (yTopOverlap <= 90.0);
            if (r.getMinY() >= 90.0 - yTopOverlap) {
                return SpatialRelation.CONTAINS;
            }
        } else {
            double yBot = this.point.getY() - this.distDEG;
            if (yBot < -90.0) {
                double yBotOverlap = -90.0 - yBot;
                assert (yBotOverlap <= 90.0);
                if (r.getMaxY() <= -90.0 + yBotOverlap) {
                    return SpatialRelation.CONTAINS;
                }
            } else assert (yTop == 90.0 || yBot == -90.0);
        }
        if (r.getWidth() == 360.0) {
            return SpatialRelation.INTERSECTS;
        }
        int cornersIntersect = this.numCornersIntersect(r);
        if (cornersIntersect == 4) {
            double backX = ctx.normX(this.getCenter().getX() + 180.0);
            if (r.relate_xRange(backX, backX, ctx).intersects()) {
                return SpatialRelation.INTERSECTS;
            }
            return SpatialRelation.CONTAINS;
        }
        if (cornersIntersect == 0) {
            double frontX = this.getCenter().getX();
            if (r.relate_xRange(frontX, frontX, ctx).intersects()) {
                return SpatialRelation.INTERSECTS;
            }
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.INTERSECTS;
    }

    private int numCornersIntersect(Rectangle r) {
        boolean bool = this.contains(r.getMinX(), r.getMinY());
        if (this.contains(r.getMinX(), r.getMaxY()) ? !bool : bool) {
            return 1;
        }
        if (this.contains(r.getMaxX(), r.getMinY()) ? !bool : bool) {
            return 1;
        }
        if (this.contains(r.getMaxX(), r.getMaxY()) ? !bool : bool) {
            return 1;
        }
        return bool ? 4 : 0;
    }

    @Override
    public String toString() {
        String dStr = String.format("%.1f", this.distance);
        if (this.ctx.isGeo()) {
            double distDEG = this.ctx.getDistCalc().distanceToDegrees(this.distance);
            dStr = dStr + String.format("=%.1f\u00b0", distDEG);
        }
        return "Circle(" + this.point + ",d=" + dStr + ')';
    }
}

