/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.simple;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;

public class CircleImpl
implements Circle {
    protected final Point point;
    protected final double distance;
    protected final SpatialContext ctx;
    protected final Rectangle enclosingBox;

    public CircleImpl(Point p, double dist, SpatialContext ctx) {
        this.point = p;
        this.distance = dist;
        this.ctx = ctx;
        this.enclosingBox = ctx.getDistCalc().calcBoxByDistFromPt(this.point, this.distance, ctx);
    }

    @Override
    public Point getCenter() {
        return this.point;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    public boolean contains(double x, double y) {
        return this.ctx.getDistCalc().distance(this.point, x, y) <= this.distance;
    }

    @Override
    public boolean hasArea() {
        return this.distance > 0.0;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.enclosingBox;
    }

    @Override
    public SpatialRelation relate(Shape other, SpatialContext ctx) {
        assert (this.ctx == ctx);
        if (other instanceof Point) {
            return this.relate((Point)other, ctx);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other, ctx);
        }
        if (other instanceof Circle) {
            return this.relate((Circle)other, ctx);
        }
        return other.relate(this, ctx).transpose();
    }

    public SpatialRelation relate(Point point, SpatialContext ctx) {
        return this.contains(point.getX(), point.getY()) ? SpatialRelation.CONTAINS : SpatialRelation.DISJOINT;
    }

    public SpatialRelation relate(Rectangle r, SpatialContext ctx) {
        SpatialRelation bboxSect = this.enclosingBox.relate(r, ctx);
        if (bboxSect == SpatialRelation.DISJOINT || bboxSect == SpatialRelation.WITHIN) {
            return bboxSect;
        }
        if (bboxSect == SpatialRelation.CONTAINS && this.enclosingBox.equals(r)) {
            return SpatialRelation.WITHIN;
        }
        return this.relateRectanglePhase2(r, bboxSect, ctx);
    }

    protected SpatialRelation relateRectanglePhase2(Rectangle r, SpatialRelation bboxSect, SpatialContext ctx) {
        double farthestY;
        double ctr_x = this.getXAxis();
        double closestX = ctr_x < r.getMinX() ? r.getMinX() : (ctr_x > r.getMaxX() ? r.getMaxX() : ctr_x);
        double ctr_y = this.getYAxis();
        double closestY = ctr_y < r.getMinY() ? r.getMinY() : (ctr_y > r.getMaxY() ? r.getMaxY() : ctr_y);
        boolean didContainOnClosestXY = false;
        if (ctr_x == closestX) {
            double distYCirc;
            double deltaY = Math.abs(ctr_y - closestY);
            double d = distYCirc = ctr_y < closestY ? this.enclosingBox.getMaxY() - ctr_y : ctr_y - this.enclosingBox.getMinY();
            if (deltaY > distYCirc) {
                return SpatialRelation.DISJOINT;
            }
        } else if (ctr_y == closestY) {
            double distXCirc;
            double deltaX = Math.abs(ctr_x - closestX);
            double d = distXCirc = ctr_x < closestX ? this.enclosingBox.getMaxX() - ctr_x : ctr_x - this.enclosingBox.getMinX();
            if (deltaX > distXCirc) {
                return SpatialRelation.DISJOINT;
            }
        } else {
            didContainOnClosestXY = true;
            if (!this.contains(closestX, closestY)) {
                return SpatialRelation.DISJOINT;
            }
        }
        if (bboxSect != SpatialRelation.CONTAINS) {
            return SpatialRelation.INTERSECTS;
        }
        double farthestX = r.getMaxX() - ctr_x > ctr_x - r.getMinX() ? r.getMaxX() : r.getMinX();
        double d = farthestY = r.getMaxY() - ctr_y > ctr_y - r.getMinY() ? r.getMaxY() : r.getMinY();
        if (this.contains(farthestX, farthestY)) {
            return SpatialRelation.CONTAINS;
        }
        return SpatialRelation.INTERSECTS;
    }

    protected double getYAxis() {
        return this.point.getY();
    }

    protected double getXAxis() {
        return this.point.getX();
    }

    public SpatialRelation relate(Circle circle, SpatialContext ctx) {
        double bDist;
        double aDist;
        double crossDist = ctx.getDistCalc().distance(this.point, circle.getCenter());
        if (crossDist > (aDist = this.distance) + (bDist = circle.getDistance())) {
            return SpatialRelation.DISJOINT;
        }
        if (crossDist < aDist && crossDist + bDist <= aDist) {
            return SpatialRelation.CONTAINS;
        }
        if (crossDist < bDist && crossDist + aDist <= bDist) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return "Circle(" + this.point + ",d=" + this.distance + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CircleImpl circle = (CircleImpl)o;
        if (this.point != null ? !this.point.equals(circle.point) : circle.point != null) {
            return false;
        }
        if (Double.compare(circle.distance, this.distance) != 0) {
            return false;
        }
        return !(this.ctx != null ? !this.ctx.equals(circle.ctx) : circle.ctx != null);
    }

    public int hashCode() {
        int result = this.point != null ? this.point.hashCode() : 0;
        long temp = this.distance != 0.0 ? Double.doubleToLongBits(this.distance) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.ctx != null ? this.ctx.hashCode() : 0);
        return result;
    }
}

