/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.jts;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.jts.JtsSpatialContext;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.jts.JtsEnvelope;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.spatial4j.core.shape.simple.PointImpl;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;

public class JtsGeometry
implements Shape {
    public final Geometry geo;
    private final boolean hasArea;

    public JtsGeometry(Geometry geo) {
        this.geo = geo;
        this.hasArea = !Lineal.class.isInstance(geo) && !Puntal.class.isInstance(geo);
    }

    @Override
    public boolean hasArea() {
        return this.hasArea;
    }

    @Override
    public JtsEnvelope getBoundingBox() {
        return new JtsEnvelope(this.geo.getEnvelopeInternal());
    }

    @Override
    public JtsPoint getCenter() {
        return new JtsPoint(this.geo.getCentroid());
    }

    private GeometryFactory getGeometryFactory(SpatialContext context) {
        if (JtsSpatialContext.class.isInstance(context)) {
            return ((JtsSpatialContext)context).factory;
        }
        return new GeometryFactory();
    }

    @Override
    public SpatialRelation relate(Shape other, SpatialContext ctx) {
        if (other instanceof Point) {
            Point pt = (Point)other;
            JtsPoint jtsPoint = (JtsPoint)(pt instanceof JtsPoint ? pt : ctx.makePoint(pt.getX(), pt.getY()));
            return this.geo.contains((Geometry)jtsPoint.getJtsPoint()) ? SpatialRelation.INTERSECTS : SpatialRelation.DISJOINT;
        }
        Rectangle ext = other.getBoundingBox();
        if (!ext.hasArea()) {
            throw new IllegalArgumentException("the query shape must cover some area (not a line)");
        }
        Envelope gEnv = this.geo.getEnvelopeInternal();
        if (ext.getMinX() > gEnv.getMaxX() || ext.getMaxX() < gEnv.getMinX() || ext.getMinY() > gEnv.getMaxY() || ext.getMaxY() < gEnv.getMinY()) {
            return SpatialRelation.DISJOINT;
        }
        if (other instanceof Circle) {
            Coordinate[] coords = this.geo.getCoordinates();
            int outside = 0;
            int i = 0;
            for (Coordinate coord : coords) {
                ++i;
                SpatialRelation sect = other.relate(new PointImpl(coord.x, coord.y), ctx);
                if (sect == SpatialRelation.DISJOINT) {
                    ++outside;
                }
                if (i == outside || outside == 0) continue;
                return SpatialRelation.INTERSECTS;
            }
            if (i == outside) {
                return this.relate(other.getCenter(), ctx) == SpatialRelation.DISJOINT ? SpatialRelation.DISJOINT : SpatialRelation.CONTAINS;
            }
            assert (outside == 0);
            return SpatialRelation.WITHIN;
        }
        Polygon qGeo = null;
        if (other instanceof Rectangle) {
            Envelope env;
            if (other instanceof JtsEnvelope) {
                env = ((JtsEnvelope)other).envelope;
            } else {
                Rectangle r = (Rectangle)other;
                env = new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY());
            }
            qGeo = (Polygon)this.getGeometryFactory(ctx).toGeometry(env);
        } else if (other instanceof JtsGeometry) {
            qGeo = (Polygon)((JtsGeometry)other).geo;
        } else {
            throw new IllegalArgumentException("Incompatible intersection of " + this + " with " + other);
        }
        if (!RectangleIntersects.intersects((Polygon)qGeo, (Geometry)this.geo)) {
            return SpatialRelation.DISJOINT;
        }
        IntersectionMatrix matrix = this.geo.relate((Geometry)qGeo);
        assert (!matrix.isDisjoint());
        if (matrix.isCovers()) {
            return SpatialRelation.CONTAINS;
        }
        if (matrix.isCoveredBy()) {
            return SpatialRelation.WITHIN;
        }
        assert (matrix.isIntersects());
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return this.geo.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsGeometry that = (JtsGeometry)o;
        return this.geo.equalsExact(that.geo);
    }

    public int hashCode() {
        return this.geo.getEnvelopeInternal().hashCode();
    }
}

