/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.jts;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;

public class JtsEnvelope
implements Rectangle {
    public final Envelope envelope;

    public JtsEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public JtsEnvelope(double x1, double x2, double y1, double y2) {
        if (x2 < x1) {
            throw new IllegalArgumentException("JtsEnvelope doesn't support crossing the dateline.");
        }
        this.envelope = new Envelope(x1, x2, y1, y2);
    }

    @Override
    public boolean hasArea() {
        return this.getWidth() > 0.0 && this.getHeight() > 0.0;
    }

    @Override
    public double getArea() {
        return this.getWidth() * this.getHeight();
    }

    @Override
    public boolean getCrossesDateLine() {
        return false;
    }

    @Override
    public double getHeight() {
        return this.envelope.getHeight();
    }

    @Override
    public double getWidth() {
        return this.envelope.getWidth();
    }

    @Override
    public double getMaxX() {
        return this.envelope.getMaxX();
    }

    @Override
    public double getMaxY() {
        return this.envelope.getMaxY();
    }

    @Override
    public double getMinX() {
        return this.envelope.getMinX();
    }

    @Override
    public double getMinY() {
        return this.envelope.getMinY();
    }

    @Override
    public JtsEnvelope getBoundingBox() {
        return this;
    }

    @Override
    public SpatialRelation relate(Shape other, SpatialContext ctx) {
        if (other instanceof Point) {
            Point p = (Point)other;
            return this.envelope.contains(p.getX(), p.getY()) ? SpatialRelation.CONTAINS : SpatialRelation.DISJOINT;
        }
        if (!(other instanceof Rectangle)) {
            return other.relate(this, ctx).transpose();
        }
        Rectangle ext = other.getBoundingBox();
        if (ext.getMinX() > this.envelope.getMaxX() || ext.getMaxX() < this.envelope.getMinX() || ext.getMinY() > this.envelope.getMaxY() || ext.getMaxY() < this.envelope.getMinY()) {
            return SpatialRelation.DISJOINT;
        }
        if (ext.getMinX() >= this.envelope.getMinX() && ext.getMaxX() <= this.envelope.getMaxX() && ext.getMinY() >= this.envelope.getMinY() && ext.getMaxY() <= this.envelope.getMaxY()) {
            return SpatialRelation.CONTAINS;
        }
        if (this.envelope.getMinX() >= ext.getMinX() && this.envelope.getMaxX() <= ext.getMaxX() && this.envelope.getMinY() >= ext.getMinY() && this.envelope.getMaxY() <= ext.getMaxY()) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public SpatialRelation relate_yRange(double minY, double maxY, SpatialContext ctx) {
        if (minY > this.envelope.getMaxY() || maxY < this.envelope.getMinY()) {
            return SpatialRelation.DISJOINT;
        }
        if (minY >= this.envelope.getMinY() && maxY <= this.envelope.getMaxY()) {
            return SpatialRelation.CONTAINS;
        }
        if (this.envelope.getMinY() >= minY && this.envelope.getMaxY() <= maxY) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    @Override
    public SpatialRelation relate_xRange(double minX, double maxX, SpatialContext ctx) {
        if (minX > this.envelope.getMaxX() || maxX < this.envelope.getMinX()) {
            return SpatialRelation.DISJOINT;
        }
        if (minX >= this.envelope.getMinX() && maxX <= this.envelope.getMaxX()) {
            return SpatialRelation.CONTAINS;
        }
        if (this.envelope.getMinX() >= minX && this.envelope.getMaxX() <= maxX) {
            return SpatialRelation.WITHIN;
        }
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return this.envelope.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsEnvelope that = (JtsEnvelope)o;
        return this.envelope.equals((Object)that.envelope);
    }

    public int hashCode() {
        return this.envelope.hashCode();
    }

    @Override
    public Point getCenter() {
        return new JtsPoint(new GeometryFactory().createPoint(this.envelope.centre()));
    }
}

