/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.util.Collection;

public class MultiShape
implements Shape {
    private final Collection<Shape> geoms;
    private final Rectangle bbox;

    public MultiShape(Collection<Shape> geoms, SpatialContext ctx) {
        this.geoms = geoms;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Shape geom : geoms) {
            Rectangle r = geom.getBoundingBox();
            minX = Math.min(minX, r.getMinX());
            minY = Math.min(minY, r.getMinY());
            maxX = Math.max(maxX, r.getMaxX());
            maxY = Math.max(maxY, r.getMaxY());
        }
        this.bbox = ctx.makeRect(minX, maxX, minY, maxY);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public Point getCenter() {
        return this.bbox.getCenter();
    }

    @Override
    public boolean hasArea() {
        for (Shape geom : this.geoms) {
            if (!geom.hasArea()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SpatialRelation relate(Shape other, SpatialContext ctx) {
        boolean allOutside = true;
        boolean allContains = true;
        for (Shape geom : this.geoms) {
            SpatialRelation sect = geom.relate(other, ctx);
            if (sect != SpatialRelation.DISJOINT) {
                allOutside = false;
            }
            if (sect != SpatialRelation.CONTAINS) {
                allContains = false;
            }
            if (allContains || allOutside) continue;
            return SpatialRelation.INTERSECTS;
        }
        if (allOutside) {
            return SpatialRelation.DISJOINT;
        }
        if (allContains) {
            return SpatialRelation.CONTAINS;
        }
        return SpatialRelation.INTERSECTS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiShape that = (MultiShape)o;
        return !(this.geoms != null ? !((Object)this.geoms).equals(that.geoms) : that.geoms != null);
    }

    public int hashCode() {
        return this.geoms != null ? ((Object)this.geoms).hashCode() : 0;
    }
}

