/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.AbstractDistanceCalculator;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;

public abstract class GeodesicSphereDistCalc
extends AbstractDistanceCalculator {
    protected final double radius;

    public GeodesicSphereDistCalc(double radius) {
        this.radius = radius;
    }

    @Override
    public double distanceToDegrees(double distance) {
        return DistanceUtils.dist2Degrees(distance, this.radius);
    }

    @Override
    public double degreesToDistance(double degrees) {
        return DistanceUtils.radians2Dist(Math.toRadians(degrees), this.radius);
    }

    @Override
    public Point pointOnBearing(Point from, double dist, double bearingDEG, SpatialContext ctx) {
        if (dist == 0.0) {
            return from;
        }
        double[] latLon = DistanceUtils.pointOnBearingRAD(Math.toRadians(from.getY()), Math.toRadians(from.getX()), DistanceUtils.dist2Radians(dist, ctx.getUnits().earthRadius()), Math.toRadians(bearingDEG), null);
        return ctx.makePoint(Math.toDegrees(latLon[1]), Math.toDegrees(latLon[0]));
    }

    @Override
    public Rectangle calcBoxByDistFromPt(Point from, double distance, SpatialContext ctx) {
        assert (this.radius == ctx.getUnits().earthRadius());
        if (distance == 0.0) {
            return from.getBoundingBox();
        }
        return DistanceUtils.calcBoxByDistFromPtDEG(from.getY(), from.getX(), distance, ctx);
    }

    @Override
    public double calcBoxByDistFromPtHorizAxis(Point from, double distance, SpatialContext ctx) {
        return DistanceUtils.calcBoxByDistFromPtHorizAxisDEG(from.getY(), from.getX(), distance, this.radius);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeodesicSphereDistCalc that = (GeodesicSphereDistCalc)o;
        return Double.compare(that.radius, this.radius) == 0;
    }

    public int hashCode() {
        long temp = this.radius != 0.0 ? Double.doubleToLongBits(this.radius) : 0L;
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public final double distance(Point from, double toX, double toY) {
        return this.distanceLatLonRAD(Math.toRadians(from.getY()), Math.toRadians(from.getX()), Math.toRadians(toY), Math.toRadians(toX)) * this.radius;
    }

    protected abstract double distanceLatLonRAD(double var1, double var3, double var5, double var7);

    public static class Vincenty
    extends GeodesicSphereDistCalc {
        public Vincenty(double radius) {
            super(radius);
        }

        @Override
        protected double distanceLatLonRAD(double lat1, double lon1, double lat2, double lon2) {
            return DistanceUtils.distVincentyRAD(lat1, lon1, lat2, lon2);
        }
    }

    public static class LawOfCosines
    extends GeodesicSphereDistCalc {
        public LawOfCosines(double radius) {
            super(radius);
        }

        @Override
        protected double distanceLatLonRAD(double lat1, double lon1, double lat2, double lon2) {
            return DistanceUtils.distLawOfCosinesRAD(lat1, lon1, lat2, lon2);
        }
    }

    public static class Haversine
    extends GeodesicSphereDistCalc {
        public Haversine(double radius) {
            super(radius);
        }

        @Override
        protected double distanceLatLonRAD(double lat1, double lon1, double lat2, double lon2) {
            return DistanceUtils.distHaversineRAD(lat1, lon1, lat2, lon2);
        }
    }
}

