/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Rectangle;

public class DistanceUtils {
    public static final double DEG_45_AS_RADS = 0.7853981633974483;
    public static final double SIN_45_AS_RADS = Math.sin(0.7853981633974483);
    public static final double DEG_90_AS_RADS = 1.5707963267948966;
    public static final double DEG_180_AS_RADS = Math.PI;
    public static final double DEG_225_AS_RADS = 3.9269908169872414;
    public static final double DEG_270_AS_RADS = 4.71238898038469;
    public static final double KM_TO_MILES = 0.621371192;
    public static final double MILES_TO_KM = 1.6093440006146922;
    public static final double EARTH_MEAN_RADIUS_KM = 6371.0087714;
    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.137;
    public static final double EARTH_MEAN_RADIUS_MI = 3958.7613145272735;
    public static final double EARTH_EQUATORIAL_RADIUS_MI = 3963.190590429304;

    public static double vectorDistance(double[] vec1, double[] vec2, double power) {
        return DistanceUtils.vectorDistance(vec1, vec2, power, 1.0 / power);
    }

    public static double vectorDistance(double[] vec1, double[] vec2, double power, double oneOverPower) {
        double result = 0.0;
        if (power == 0.0) {
            for (int i = 0; i < vec1.length; ++i) {
                result += vec1[i] - vec2[i] == 0.0 ? 0.0 : 1.0;
            }
        } else if (power == 1.0) {
            for (int i = 0; i < vec1.length; ++i) {
                result += vec1[i] - vec2[i];
            }
        } else if (power == 2.0) {
            result = Math.sqrt(DistanceUtils.distSquaredCartesian(vec1, vec2));
        } else if (power == 2.147483647E9 || Double.isInfinite(power)) {
            for (int i = 0; i < vec1.length; ++i) {
                result = Math.max(result, Math.max(vec1[i], vec2[i]));
            }
        } else {
            for (int i = 0; i < vec1.length; ++i) {
                result += Math.pow(vec1[i] - vec2[i], power);
            }
            result = Math.pow(result, oneOverPower);
        }
        return result;
    }

    public static double[] vectorBoxCorner(double[] center, double[] result, double distance, boolean upperRight) {
        if (result == null || result.length != center.length) {
            result = new double[center.length];
        }
        if (!upperRight) {
            distance = -distance;
        }
        distance = SIN_45_AS_RADS * distance;
        for (int i = 0; i < center.length; ++i) {
            result[i] = center[i] + distance;
        }
        return result;
    }

    public static double[] pointOnBearingRAD(double startLat, double startLon, double distanceRAD, double bearingRAD, double[] result) {
        double cosAngDist = Math.cos(distanceRAD);
        double cosStartLat = Math.cos(startLat);
        double sinAngDist = Math.sin(distanceRAD);
        double sinStartLat = Math.sin(startLat);
        double lat2 = Math.asin(sinStartLat * cosAngDist + cosStartLat * sinAngDist * Math.cos(bearingRAD));
        double lon2 = startLon + Math.atan2(Math.sin(bearingRAD) * sinAngDist * cosStartLat, cosAngDist - sinStartLat * Math.sin(lat2));
        if (result == null || result.length != 2) {
            result = new double[]{lat2, lon2};
        }
        DistanceUtils.normLngRAD(result);
        DistanceUtils.normLatRAD(result);
        return result;
    }

    public static void normLatRAD(double[] latLng) {
        if (latLng[0] > 1.5707963267948966) {
            latLng[0] = 1.5707963267948966 - (latLng[0] - 1.5707963267948966);
            latLng[1] = latLng[1] < 0.0 ? latLng[1] + Math.PI : latLng[1] - Math.PI;
        } else if (latLng[0] < -1.5707963267948966) {
            latLng[0] = -1.5707963267948966 - (latLng[0] + 1.5707963267948966);
            latLng[1] = latLng[1] < 0.0 ? latLng[1] + Math.PI : latLng[1] - Math.PI;
        }
    }

    @Deprecated
    public static void normLngRAD(double[] latLng) {
        if (latLng[1] > Math.PI) {
            latLng[1] = -1.0 * (Math.PI - (latLng[1] - Math.PI));
        } else if (latLng[1] < -Math.PI) {
            latLng[1] = latLng[1] + Math.PI + Math.PI;
        }
    }

    public static double normLonDEG(double lon_deg) {
        if (lon_deg >= -180.0 && lon_deg < 180.0) {
            return lon_deg;
        }
        double off = (lon_deg + 180.0) % 360.0;
        return off < 0.0 ? 180.0 + off : -180.0 + off;
    }

    public static double normLatDEG(double lat_deg) {
        if (lat_deg >= -90.0 && lat_deg <= 90.0) {
            return lat_deg;
        }
        double off = Math.abs((lat_deg + 90.0) % 360.0);
        return (off <= 180.0 ? off : 360.0 - off) - 90.0;
    }

    public static Rectangle calcBoxByDistFromPtDEG(double lat, double lon, double distance, SpatialContext ctx) {
        double radius = ctx.getUnits().earthRadius();
        double dist_rad = distance / radius;
        double dist_deg = Math.toDegrees(dist_rad);
        if (dist_deg == 0.0) {
            return ctx.makeRect(lon, lon, lat, lat);
        }
        if (dist_deg >= 180.0) {
            return ctx.getWorldBounds();
        }
        double latN_deg = lat + dist_deg;
        double latS_deg = lat - dist_deg;
        if (latN_deg >= 90.0 || latS_deg <= -90.0) {
            double lonW_deg = -180.0;
            double lonE_deg = 180.0;
            if (latN_deg <= 90.0 && latS_deg >= -90.0) {
                lonW_deg = lon - 90.0;
                lonE_deg = lon + 90.0;
            }
            if (latN_deg > 90.0) {
                latN_deg = 90.0;
            }
            if (latS_deg < -90.0) {
                latS_deg = -90.0;
            }
            return ctx.makeRect(lonW_deg, lonE_deg, latS_deg, latN_deg);
        }
        double lon_delta_deg = DistanceUtils.calcBoxByDistFromPtVertAxisOffsetDEG(lat, lon, distance, radius);
        double lonW_deg = lon - lon_delta_deg;
        double lonE_deg = lon + lon_delta_deg;
        return ctx.makeRect(lonW_deg, lonE_deg, latS_deg, latN_deg);
    }

    public static double calcBoxByDistFromPtVertAxisOffsetDEG(double lat, double lon, double distance, double radius) {
        if (distance == 0.0) {
            return 0.0;
        }
        double lat_rad = Math.toRadians(lat);
        double dist_rad = distance / radius;
        double result_rad = Math.asin(Math.sin(dist_rad) / Math.cos(lat_rad));
        if (!Double.isNaN(result_rad)) {
            return Math.toDegrees(result_rad);
        }
        return 90.0;
    }

    public static double calcBoxByDistFromPtHorizAxisDEG(double lat, double lon, double distance, double radius) {
        if (distance == 0.0) {
            return lat;
        }
        double lat_rad = Math.toRadians(lat);
        double dist_rad = distance / radius;
        double result_rad = Math.asin(Math.sin(lat_rad) / Math.cos(dist_rad));
        if (!Double.isNaN(result_rad)) {
            return Math.toDegrees(result_rad);
        }
        if (lat > 0.0) {
            return 90.0;
        }
        if (lat < 0.0) {
            return -90.0;
        }
        return lat;
    }

    public static double distSquaredCartesian(double[] vec1, double[] vec2) {
        double result = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            double v = vec1[i] - vec2[i];
            result += v * v;
        }
        return result;
    }

    public static double distHaversineRAD(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double hsinX = Math.sin((lon1 - lon2) * 0.5);
        double hsinY = Math.sin((lat1 - lat2) * 0.5);
        double h = hsinY * hsinY + Math.cos(lat1) * Math.cos(lat2) * hsinX * hsinX;
        return 2.0 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
    }

    public static double distLawOfCosinesRAD(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double dLon = lon2 - lon1;
        double a = 1.5707963267948966 - lat1;
        double c = 1.5707963267948966 - lat2;
        double cosB = Math.cos(a) * Math.cos(c) + Math.sin(a) * Math.sin(c) * Math.cos(dLon);
        if (cosB < -1.0) {
            return Math.PI;
        }
        if (cosB >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosB);
    }

    public static double distVincentyRAD(double lat1, double lon1, double lat2, double lon2) {
        if (lat1 == lat2 && lon1 == lon2) {
            return 0.0;
        }
        double cosLat1 = Math.cos(lat1);
        double cosLat2 = Math.cos(lat2);
        double sinLat1 = Math.sin(lat1);
        double sinLat2 = Math.sin(lat2);
        double dLon = lon2 - lon1;
        double cosDLon = Math.cos(dLon);
        double sinDLon = Math.sin(dLon);
        double a = cosLat2 * sinDLon;
        double b = cosLat1 * sinLat2 - sinLat1 * cosLat2 * cosDLon;
        double c = sinLat1 * sinLat2 + cosLat1 * cosLat2 * cosDLon;
        return Math.atan2(Math.sqrt(a * a + b * b), c);
    }

    public static double dist2Degrees(double dist, double radius) {
        return Math.toDegrees(DistanceUtils.dist2Radians(dist, radius));
    }

    public static double dist2Radians(double dist, double radius) {
        return dist / radius;
    }

    public static double radians2Dist(double radians, double radius) {
        return radians * radius;
    }
}

