/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

public enum DistanceUnits {
    KILOMETERS("km", 6371.0087714, 40076.0),
    MILES("miles", 3958.7613145272735, 24902.0),
    RADIANS("radians", 1.0, Math.PI * 2),
    CARTESIAN("u", -1.0, -1.0);

    private final String units;
    private final double earthCircumference;
    private final double earthRadius;

    private DistanceUnits(String units, double earthRadius, double earthCircumfence) {
        this.units = units;
        this.earthCircumference = earthCircumfence;
        this.earthRadius = earthRadius;
    }

    public static DistanceUnits findDistanceUnit(String unit) {
        if (MILES.getUnits().equalsIgnoreCase(unit) || unit.equalsIgnoreCase("mi")) {
            return MILES;
        }
        if (KILOMETERS.getUnits().equalsIgnoreCase(unit)) {
            return KILOMETERS;
        }
        if (CARTESIAN.getUnits().equalsIgnoreCase(unit) || unit.length() == 0) {
            return CARTESIAN;
        }
        throw new IllegalArgumentException("Unknown distance unit " + unit);
    }

    public double convert(double distance, DistanceUnits from) {
        if (from == this) {
            return distance;
        }
        if (this == CARTESIAN || from == CARTESIAN) {
            throw new IllegalStateException("Can't convert cartesian distances: " + (Object)((Object)from) + " -> " + (Object)((Object)this));
        }
        return this == MILES ? distance * 0.621371192 : distance * 1.6093440006146922;
    }

    public String getUnits() {
        return this.units;
    }

    public double earthRadius() {
        return this.earthRadius;
    }

    public double earthCircumference() {
        return this.earthCircumference;
    }

    public boolean isGeo() {
        return this.earthRadius > 0.0;
    }
}

