/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.distance;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.AbstractDistanceCalculator;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;

public class CartesianDistCalc
extends AbstractDistanceCalculator {
    private final boolean squared;

    public CartesianDistCalc() {
        this.squared = false;
    }

    public CartesianDistCalc(boolean squared) {
        this.squared = squared;
    }

    @Override
    public double distance(Point from, double toX, double toY) {
        double result = 0.0;
        double v = from.getX() - toX;
        result += v * v;
        v = from.getY() - toY;
        result += v * v;
        if (this.squared) {
            return result;
        }
        return Math.sqrt(result);
    }

    @Override
    public Point pointOnBearing(Point from, double dist, double bearingDEG, SpatialContext ctx) {
        if (dist == 0.0) {
            return from;
        }
        double bearingRAD = Math.toDegrees(bearingDEG);
        double x = Math.sin(bearingRAD) * dist;
        double y = Math.cos(bearingRAD) * dist;
        return ctx.makePoint(from.getX() + x, from.getY() + y);
    }

    @Override
    public double distanceToDegrees(double distance) {
        throw new UnsupportedOperationException("no geo!");
    }

    @Override
    public double degreesToDistance(double degrees) {
        throw new UnsupportedOperationException("no geo!");
    }

    @Override
    public Rectangle calcBoxByDistFromPt(Point from, double distance, SpatialContext ctx) {
        return ctx.makeRect(from.getX() - distance, from.getX() + distance, from.getY() - distance, from.getY() + distance);
    }

    @Override
    public double calcBoxByDistFromPtHorizAxis(Point from, double distance, SpatialContext ctx) {
        return from.getY();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CartesianDistCalc that = (CartesianDistCalc)o;
        return this.squared == that.squared;
    }

    public int hashCode() {
        return this.squared ? 1 : 0;
    }
}

