/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context.simple;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUnits;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.simple.CircleImpl;
import com.spatial4j.core.shape.simple.GeoCircleImpl;
import com.spatial4j.core.shape.simple.PointImpl;
import com.spatial4j.core.shape.simple.RectangleImpl;
import java.text.NumberFormat;
import java.util.Locale;

public class SimpleSpatialContext
extends SpatialContext {
    public static SimpleSpatialContext GEO_KM = new SimpleSpatialContext(DistanceUnits.KILOMETERS);

    public SimpleSpatialContext(DistanceUnits units) {
        this(units, null, null);
    }

    public SimpleSpatialContext(DistanceUnits units, DistanceCalculator calculator, Rectangle worldBounds) {
        super(units, calculator, worldBounds);
    }

    @Override
    public Shape readShape(String value) throws InvalidShapeException {
        Shape s = super.readStandardShape(value);
        if (s == null) {
            throw new InvalidShapeException("Unable to read: " + value);
        }
        return s;
    }

    @Override
    public String toString(Shape shape) {
        if (Point.class.isInstance(shape)) {
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(6);
            nf.setMinimumFractionDigits(6);
            Point point = (Point)shape;
            return nf.format(point.getX()) + " " + nf.format(point.getY());
        }
        if (Rectangle.class.isInstance(shape)) {
            return this.writeRect((Rectangle)shape);
        }
        return shape.toString();
    }

    @Override
    public Circle makeCircle(Point point, double distance) {
        if (distance < 0.0) {
            throw new InvalidShapeException("distance must be >= 0; got " + distance);
        }
        if (this.isGeo()) {
            return new GeoCircleImpl(point, Math.min(distance, this.maxCircleDistance), this);
        }
        return new CircleImpl(point, distance, this);
    }

    @Override
    public Rectangle makeRect(double minX, double maxX, double minY, double maxY) {
        if (this.isGeo()) {
            double delta = this.calcWidth(minX, maxX);
            if (delta >= 360.0) {
                minX = -180.0;
                maxX = 180.0;
            } else {
                minX = this.normX(minX);
                maxX = this.normX(maxX);
                assert (Math.abs(delta - this.calcWidth(minX, maxX)) < 1.0E-4);
            }
            if (minY > maxY) {
                throw new IllegalArgumentException("maxY must be >= minY");
            }
            if (minY < -90.0 || minY > 90.0 || maxY < -90.0 || maxY > 90.0) {
                throw new IllegalArgumentException("minY or maxY is outside of -90 to 90 bounds. What did you mean?");
            }
        } else {
            minX = this.normX(minX);
            maxX = this.normX(maxX);
            minY = this.normY(minY);
            maxY = this.normY(maxY);
        }
        return new RectangleImpl(minX, maxX, minY, maxY);
    }

    private double calcWidth(double minX, double maxX) {
        double w = maxX - minX;
        if (w < 0.0) assert ((w += 360.0) >= 0.0);
        return w;
    }

    @Override
    public Point makePoint(double x, double y) {
        return new PointImpl(this.normX(x), this.normY(y));
    }
}

