/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context.jts;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUnits;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.jts.JtsEnvelope;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.spatial4j.core.shape.jts.JtsPoint;
import com.spatial4j.core.shape.simple.CircleImpl;
import com.spatial4j.core.shape.simple.GeoCircleImpl;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Locale;

public class JtsSpatialContext
extends SpatialContext {
    private static final byte TYPE_POINT = 0;
    private static final byte TYPE_BBOX = 1;
    private static final byte TYPE_GEO = 2;
    public GeometryFactory factory;
    public static JtsSpatialContext GEO_KM = new JtsSpatialContext(DistanceUnits.KILOMETERS);

    public JtsSpatialContext(DistanceUnits units) {
        this(null, units, null, null);
    }

    public JtsSpatialContext(GeometryFactory f, DistanceUnits units, DistanceCalculator calculator, Rectangle worldBounds) {
        super(units, calculator, worldBounds);
        if (f == null) {
            f = new GeometryFactory();
        }
        this.factory = f;
    }

    @Override
    public Shape readShape(String str) throws InvalidShapeException {
        Shape shape = super.readStandardShape(str);
        if (shape == null) {
            try {
                WKTReader reader = new WKTReader(this.factory);
                Geometry geo = reader.read(str);
                if (geo instanceof Point) {
                    return new JtsPoint((Point)geo);
                }
                if (geo.isRectangle()) {
                    return new JtsEnvelope(geo.getEnvelopeInternal());
                }
                return new JtsGeometry(geo);
            }
            catch (ParseException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
        }
        return shape;
    }

    public byte[] toBytes(Shape shape) throws IOException {
        if (com.spatial4j.core.shape.Point.class.isInstance(shape)) {
            ByteBuffer bytes = ByteBuffer.wrap(new byte[17]);
            com.spatial4j.core.shape.Point p = (com.spatial4j.core.shape.Point)shape;
            bytes.put((byte)0);
            bytes.putDouble(p.getX());
            bytes.putDouble(p.getY());
            return bytes.array();
        }
        if (Rectangle.class.isInstance(shape)) {
            Rectangle rect = (Rectangle)shape;
            ByteBuffer bytes = ByteBuffer.wrap(new byte[33]);
            bytes.put((byte)1);
            bytes.putDouble(rect.getMinX());
            bytes.putDouble(rect.getMaxX());
            bytes.putDouble(rect.getMinY());
            bytes.putDouble(rect.getMaxY());
            return bytes.array();
        }
        if (JtsGeometry.class.isInstance(shape)) {
            WKBWriter writer = new WKBWriter();
            byte[] bb = writer.write(((JtsGeometry)shape).geo);
            ByteBuffer bytes = ByteBuffer.wrap(new byte[1 + bb.length]);
            bytes.put((byte)2);
            bytes.put(bb);
            return bytes.array();
        }
        throw new IllegalArgumentException("unsuported shape:" + shape);
    }

    public Shape readShape(final byte[] array, final int offset, final int length) throws InvalidShapeException {
        ByteBuffer bytes = ByteBuffer.wrap(array, offset, length);
        byte type = bytes.get();
        if (type == 0) {
            return new JtsPoint(this.factory.createPoint(new Coordinate(bytes.getDouble(), bytes.getDouble())));
        }
        if (type == 1) {
            return new JtsEnvelope(bytes.getDouble(), bytes.getDouble(), bytes.getDouble(), bytes.getDouble());
        }
        if (type == 2) {
            WKBReader reader = new WKBReader(this.factory);
            try {
                return new JtsGeometry(reader.read(new InStream(){
                    int off;
                    {
                        this.off = offset + 1;
                    }

                    public void read(byte[] buf) throws IOException {
                        if (this.off + buf.length > length) {
                            throw new InvalidShapeException("Asking for too many bytes");
                        }
                        for (int i = 0; i < buf.length; ++i) {
                            buf[i] = array[this.off + i];
                        }
                        this.off += buf.length;
                    }
                }));
            }
            catch (ParseException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
            catch (IOException ex) {
                throw new InvalidShapeException("error reading WKT", ex);
            }
        }
        throw new InvalidShapeException("shape not handled: " + type);
    }

    @Override
    public String toString(Shape shape) {
        if (com.spatial4j.core.shape.Point.class.isInstance(shape)) {
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(6);
            nf.setMinimumFractionDigits(6);
            com.spatial4j.core.shape.Point point = (com.spatial4j.core.shape.Point)shape;
            return nf.format(point.getX()) + " " + nf.format(point.getY());
        }
        if (Rectangle.class.isInstance(shape)) {
            Rectangle rect = (Rectangle)shape;
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setGroupingUsed(false);
            nf.setMaximumFractionDigits(6);
            nf.setMinimumFractionDigits(6);
            return nf.format(rect.getMinX()) + " " + nf.format(rect.getMinY()) + " " + nf.format(rect.getMaxX()) + " " + nf.format(rect.getMaxY());
        }
        if (JtsGeometry.class.isInstance(shape)) {
            JtsGeometry geo = (JtsGeometry)shape;
            return geo.geo.toText();
        }
        return shape.toString();
    }

    public Geometry getGeometryFrom(Shape shape) {
        if (JtsGeometry.class.isInstance(shape)) {
            return ((JtsGeometry)shape).geo;
        }
        if (JtsPoint.class.isInstance(shape)) {
            return ((JtsPoint)shape).getJtsPoint();
        }
        if (JtsEnvelope.class.isInstance(shape)) {
            return this.factory.toGeometry(((JtsEnvelope)shape).envelope);
        }
        if (Circle.class.isInstance(shape)) {
            Circle circle = (Circle)shape;
            GeometricShapeFactory gsf = new GeometricShapeFactory(this.factory);
            gsf.setSize(circle.getBoundingBox().getWidth() / 2.0);
            gsf.setNumPoints(100);
            gsf.setBase(new Coordinate(circle.getCenter().getX(), circle.getCenter().getY()));
            return gsf.createCircle();
        }
        throw new InvalidShapeException("can't make Geometry from: " + shape);
    }

    @Override
    public Circle makeCircle(com.spatial4j.core.shape.Point point, double distance) {
        if (this.isGeo()) {
            return new GeoCircleImpl(point, Math.min(distance, this.maxCircleDistance), this);
        }
        return new CircleImpl(point, distance, this);
    }

    @Override
    public Rectangle makeRect(double minX, double maxX, double minY, double maxY) {
        return new JtsEnvelope(new Envelope(minX, maxX, minY, maxY));
    }

    @Override
    public com.spatial4j.core.shape.Point makePoint(double x, double y) {
        return new JtsPoint(this.factory.createPoint(new Coordinate(x, y)));
    }
}

