/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.context.simple.SimpleSpatialContext;
import com.spatial4j.core.context.simple.SimpleSpatialContextFactory;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUnits;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.shape.Rectangle;
import java.util.Map;

public abstract class SpatialContextFactory {
    protected Map<String, String> args;
    protected ClassLoader classLoader;
    protected DistanceUnits units;
    protected DistanceCalculator calculator;
    protected Rectangle worldBounds;

    public static SpatialContext makeSpatialContext(Map<String, String> args, ClassLoader classLoader) {
        SpatialContextFactory instance;
        String cname = args.get("spatialContextFactory");
        if (cname == null) {
            cname = System.getProperty("SpatialContextFactory");
        }
        if (cname == null) {
            instance = new SimpleSpatialContextFactory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialContextFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        instance.init(args, classLoader);
        return instance.newSpatialContext();
    }

    protected void init(Map<String, String> args, ClassLoader classLoader) {
        this.args = args;
        this.classLoader = classLoader;
        this.initUnits();
        this.initCalculator();
        this.initWorldBounds();
    }

    protected void initUnits() {
        String unitsStr = this.args.get("units");
        if (unitsStr != null) {
            this.units = DistanceUnits.findDistanceUnit(unitsStr);
        }
        if (this.units == null) {
            this.units = DistanceUnits.KILOMETERS;
        }
    }

    protected void initCalculator() {
        String calcStr = this.args.get("distCalculator");
        if (calcStr == null) {
            return;
        }
        if (calcStr.equalsIgnoreCase("haversine")) {
            this.calculator = new GeodesicSphereDistCalc.Haversine(this.units.earthRadius());
        } else if (calcStr.equalsIgnoreCase("lawOfCosines")) {
            this.calculator = new GeodesicSphereDistCalc.LawOfCosines(this.units.earthRadius());
        } else if (calcStr.equalsIgnoreCase("vincentySphere")) {
            this.calculator = new GeodesicSphereDistCalc.Vincenty(this.units.earthRadius());
        } else if (calcStr.equalsIgnoreCase("cartesian")) {
            this.calculator = new CartesianDistCalc();
        } else if (calcStr.equalsIgnoreCase("cartesian^2")) {
            this.calculator = new CartesianDistCalc(true);
        } else {
            throw new RuntimeException("Unknown calculator: " + calcStr);
        }
    }

    protected void initWorldBounds() {
        String worldBoundsStr = this.args.get("worldBounds");
        if (worldBoundsStr == null) {
            return;
        }
        SimpleSpatialContext simpleCtx = new SimpleSpatialContext(this.units, this.calculator, null);
        this.worldBounds = (Rectangle)simpleCtx.readShape(worldBoundsStr);
    }

    protected abstract SpatialContext newSpatialContext();
}

