/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.context;

import com.spatial4j.core.context.ParseUtils;
import com.spatial4j.core.distance.CartesianDistCalc;
import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.distance.DistanceUnits;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.distance.GeodesicSphereDistCalc;
import com.spatial4j.core.exception.InvalidShapeException;
import com.spatial4j.core.shape.Circle;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.simple.RectangleImpl;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class SpatialContext {
    private final DistanceUnits units;
    private final DistanceCalculator calculator;
    private final Rectangle worldBounds;
    public static RectangleImpl GEO_WORLDBOUNDS = new RectangleImpl(-180.0, 180.0, -90.0, 90.0);
    public static RectangleImpl MAX_WORLDBOUNDS;
    protected final Double maxCircleDistance;
    protected final boolean NUDGE = false;

    protected SpatialContext(DistanceUnits units, DistanceCalculator calculator, Rectangle worldBounds) {
        if (units == null) {
            throw new IllegalArgumentException("units can't be null");
        }
        this.units = units;
        if (calculator == null) {
            calculator = this.isGeo() ? new GeodesicSphereDistCalc.Haversine(units.earthRadius()) : new CartesianDistCalc();
        }
        this.calculator = calculator;
        if (worldBounds == null) {
            worldBounds = this.isGeo() ? GEO_WORLDBOUNDS : MAX_WORLDBOUNDS;
        } else {
            if (this.isGeo()) assert (new RectangleImpl(worldBounds).equals(GEO_WORLDBOUNDS));
            if (worldBounds.getCrossesDateLine()) {
                throw new IllegalArgumentException("worldBounds shouldn't cross dateline: " + worldBounds);
            }
        }
        this.worldBounds = worldBounds = this.makeRect(worldBounds.getMinX(), worldBounds.getMaxX(), worldBounds.getMinY(), worldBounds.getMaxY());
        this.maxCircleDistance = this.isGeo() ? Double.valueOf(calculator.degreesToDistance(180.0)) : null;
    }

    public DistanceUnits getUnits() {
        return this.units;
    }

    public DistanceCalculator getDistCalc() {
        return this.calculator;
    }

    public Rectangle getWorldBounds() {
        return this.worldBounds;
    }

    public double normX(double x) {
        if (this.isGeo()) {
            return DistanceUtils.normLonDEG(x);
        }
        return x;
    }

    public double normY(double y) {
        if (this.isGeo()) {
            y = DistanceUtils.normLatDEG(y);
        }
        return y;
    }

    public boolean isGeo() {
        return this.getUnits().isGeo();
    }

    public abstract Shape readShape(String var1) throws InvalidShapeException;

    public Point readLatCommaLonPoint(String value) throws InvalidShapeException {
        double[] latLon = ParseUtils.parseLatitudeLongitude(value);
        return this.makePoint(latLon[1], latLon[0]);
    }

    public abstract String toString(Shape var1);

    public abstract Point makePoint(double var1, double var3);

    public abstract Rectangle makeRect(double var1, double var3, double var5, double var7);

    public Circle makeCircle(double x, double y, double distance) {
        return this.makeCircle(this.makePoint(x, y), distance);
    }

    public abstract Circle makeCircle(Point var1, double var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Shape readStandardShape(String str) {
        if (str.length() < 1) {
            throw new InvalidShapeException(str);
        }
        if (Character.isLetter(str.charAt(0))) {
            Point pt;
            int idx;
            if (!str.startsWith("Circle(") || (idx = str.lastIndexOf(41)) <= 0) return null;
            String body = str.substring("Circle(".length(), idx);
            StringTokenizer st = new StringTokenizer(body, " ");
            String token = st.nextToken();
            if (token.indexOf(44) != -1) {
                pt = this.readLatCommaLonPoint(token);
            } else {
                double x = Double.parseDouble(token);
                double y = Double.parseDouble(st.nextToken());
                pt = this.makePoint(x, y);
            }
            Double d = null;
            String arg = st.nextToken();
            idx = arg.indexOf(61);
            if (idx > 0) {
                String k = arg.substring(0, idx);
                if (!k.equals("d") && !k.equals("distance")) throw new InvalidShapeException("unknown arg: " + k + " :: " + str);
                d = Double.parseDouble(arg.substring(idx + 1));
            } else {
                d = Double.parseDouble(arg);
            }
            if (st.hasMoreTokens()) {
                throw new InvalidShapeException("Extra arguments: " + st.nextToken() + " :: " + str);
            }
            if (d != null) return this.makeCircle(pt, d);
            throw new InvalidShapeException("Missing Distance: " + str);
        }
        if (str.indexOf(44) != -1) {
            return this.readLatCommaLonPoint(str);
        }
        StringTokenizer st = new StringTokenizer(str, " ");
        double p0 = Double.parseDouble(st.nextToken());
        double p1 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return this.makePoint(p0, p1);
        double p2 = Double.parseDouble(st.nextToken());
        double p3 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return this.makeRect(p0, p2, p1, p3);
        throw new InvalidShapeException("Only 4 numbers supported (rect) but found more: " + str);
    }

    public String writeRect(Rectangle rect) {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(6);
        nf.setMinimumFractionDigits(6);
        return nf.format(rect.getMinX()) + " " + nf.format(rect.getMinY()) + " " + nf.format(rect.getMaxX()) + " " + nf.format(rect.getMaxY());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "units=" + (Object)((Object)this.units) + ", calculator=" + this.calculator + ", worldBounds=" + this.worldBounds + '}';
    }

    static {
        double v = Double.MAX_VALUE;
        MAX_WORLDBOUNDS = new RectangleImpl(-v, v, -v, v);
    }
}

