/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.util;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.util.ClassUtils;

public class AopTargetUtils {
    public static <T> T getTarget(Object proxy) {
        if (Proxy.isProxyClass(proxy.getClass())) {
            return AopTargetUtils.getJdkDynamicProxyTargetObject(proxy);
        }
        if (ClassUtils.isCglibProxy((Object)proxy)) {
            return AopTargetUtils.getCglibProxyTargetObject(proxy);
        }
        return (T)proxy;
    }

    private static <T> T getCglibProxyTargetObject(Object proxy) {
        try {
            Field h = proxy.getClass().getDeclaredField("CGLIB$CALLBACK_0");
            h.setAccessible(true);
            Object dynamicAdvisedInterceptor = h.get(proxy);
            Field advised = dynamicAdvisedInterceptor.getClass().getDeclaredField("advised");
            advised.setAccessible(true);
            return (T)((AdvisedSupport)advised.get(dynamicAdvisedInterceptor)).getTargetSource().getTarget();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T getJdkDynamicProxyTargetObject(Object proxy) {
        try {
            Field h = proxy.getClass().getSuperclass().getDeclaredField("h");
            h.setAccessible(true);
            Object proxy_ = h.get(proxy);
            Field f = proxy_.getClass().getDeclaredField("target");
            f.setAccessible(true);
            return (T)f.get(proxy_);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

