/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa.hibernate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import javax.persistence.Column;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.jboss.logging.Logger;
import org.springframework.util.ReflectionUtils;

public class JSONType
implements UserType,
DynamicParameterizedType,
Serializable {
    private static final long serialVersionUID = 352044032843534075L;
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JSONType.class.getName());
    public static final String TYPE = "com.slyak.spring.jpa.hibernate.JSONType";
    public static final String CLASS_NAME = "class";
    private int sqlType = 12;
    private Type type = Object.class;

    public int[] sqlTypes() {
        return new int[]{this.sqlType};
    }

    public Class returnedClass() {
        if (this.type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.type).getRawType();
        }
        return (Class)this.type;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equals(x, y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String value = JSONType.extractString(rs.getObject(names[0]));
        if (rs.wasNull() || StringUtils.isEmpty((CharSequence)value)) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Returning null as column {0}", (Object)names[0]);
            }
            return null;
        }
        if (this.type == Object.class) {
            return JSON.parse((String)value);
        }
        return JSON.parseObject((String)value, (Type)this.type, (Feature[])new Feature[0]);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Binding null to parameter: {0}", (Object)index);
            }
            st.setNull(index, this.sqlType);
        } else {
            String json = this.type == Object.class ? JSON.toJSONString((Object)value, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}) : JSON.toJSONString((Object)value);
            if (this.sqlType == 2005) {
                StringReader sr = new StringReader(json);
                st.setCharacterStream(index, (Reader)sr, json.length());
            } else {
                st.setObject(index, (Object)json, this.sqlType);
            }
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public void setParameterValues(Properties parameters) {
        try {
            Class eClass = ReflectHelper.classForName((String)parameters.getProperty("org.hibernate.type.ParameterType.entityClass"));
            Field field = ReflectionUtils.findField((Class)eClass, (String)parameters.getProperty("org.hibernate.type.ParameterType.propertyName"));
            Type fieldType = field.getGenericType();
            if (fieldType instanceof Class || fieldType instanceof ParameterizedType) {
                this.type = fieldType;
            }
            this.parseSqlType(field.getAnnotations());
            return;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
            if (reader != null) {
                this.type = reader.getReturnedClass();
                this.parseSqlType(reader.getAnnotationsMethod());
            } else {
                try {
                    this.type = ReflectHelper.classForName((String)((String)parameters.get(CLASS_NAME)));
                }
                catch (ClassNotFoundException exception) {
                    throw new HibernateException("class not found", (Throwable)exception);
                }
            }
            return;
        }
    }

    private void parseSqlType(Annotation[] anns) {
        for (Annotation an : anns) {
            if (!(an instanceof Column)) continue;
            int length = ((Column)an).length();
            if (length <= 4000) break;
            this.sqlType = 2005;
            break;
        }
    }

    private static String extractString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Reader) {
            return DataHelper.extractString((Reader)((Reader)value));
        }
        if (value instanceof Clob) {
            return DataHelper.extractString((Clob)((Clob)value));
        }
        return null;
    }
}

