/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa.converter;

import com.slyak.spring.jpa.GenericJpaRepository;
import com.slyak.spring.jpa.auditing.CachingJpaRepository;
import com.slyak.spring.jpa.converter.AbstractConverter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.repository.support.Repositories;

public abstract class RepoBasedConverter<S, D, ID extends Serializable>
extends AbstractConverter<S, D, ID>
implements ApplicationContextAware {
    private Repositories repositories;
    private GenericJpaRepository<S, ID> genericJpaRepository;
    private JpaEntityInformation<S, ID> entityInformation;
    private boolean useCache = false;

    @Override
    protected ID getId(S source) {
        return (ID)this.entityInformation.getId(source);
    }

    @Override
    protected S internalGet(ID id) {
        return (S)this.genericJpaRepository.findOne((Serializable)id);
    }

    @Override
    protected Map<ID, S> internalMGet(Collection<ID> ids) {
        if (this.useCache) {
            return this.genericJpaRepository.mgetOneByOne(ids);
        }
        return this.genericJpaRepository.mget(ids);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Class[] classes = GenericTypeResolver.resolveTypeArguments(this.getClass(), RepoBasedConverter.class);
        Class clazz = classes[0];
        this.repositories = new Repositories((ListableBeanFactory)context);
        this.entityInformation = (JpaEntityInformation)this.repositories.getEntityInformationFor(clazz);
        this.genericJpaRepository = (GenericJpaRepository)this.repositories.getRepositoryFor(clazz);
        this.useCache = this.genericJpaRepository instanceof CachingJpaRepository;
    }
}

