/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa.converter;

import com.slyak.spring.jpa.converter.ConverterAssembler;
import com.slyak.spring.jpa.converter.ConverterEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.util.CollectionUtils;

public abstract class AbstractConverter<S, D, ID>
implements ConverterEx<S, D, ID>,
InitializingBean {
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());
    private Map<String, Object> hints = Collections.emptyMap();
    protected List<ConverterAssembler> assemblers = new ArrayList<ConverterAssembler>();

    public static <T> List<T> trimNull(List<T> list) {
        ArrayList<T> list1 = new ArrayList<T>(list.size());
        for (T item : list) {
            if (item == null) continue;
            list1.add(item);
        }
        return list1;
    }

    protected void initAssemblers(List<ConverterAssembler> assemblers) {
    }

    public void setHints(Map<String, Object> hints) {
        this.hints = hints;
    }

    protected void setAssemblers(List<ConverterAssembler> assemblers) {
        this.assemblers = assemblers;
    }

    public D convert(S source) {
        if (source == null) {
            return null;
        }
        D d = this.internalConvert(source);
        if (d != null) {
            for (ConverterAssembler assembler : this.assemblers) {
                Set keys;
                if (!assembler.accept(this.hints) || (keys = assembler.getKeys(source, d)) == null) continue;
                Map values = new HashMap();
                if (keys.size() == 1) {
                    Object key = keys.iterator().next();
                    if (key != null) {
                        values.put(key, assembler.getValue(key));
                    }
                } else {
                    values = assembler.mgetValue(this.trimNull(keys));
                }
                assembler.setValues(source, d, values);
            }
        }
        return d;
    }

    private Set trimNull(Set keys) {
        HashSet set = new HashSet();
        for (Object o : keys) {
            if (o == null) continue;
            set.add(o);
        }
        return set;
    }

    @Override
    public List<D> convert(List<S> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<D> ds = new ArrayList<D>(source.size());
        for (S s : source) {
            ds.add(this.convert(s));
        }
        this.assembler(source, ds);
        return ds;
    }

    @Override
    public Map<ID, D> convert(Map<ID, S> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        int len = source.size();
        ArrayList<S> ss = new ArrayList<S>(source.values());
        List<D> ds = this.convert((List<S>)ss);
        HashMap<ID, D> dMap = new HashMap<ID, D>(ss.size());
        for (int i = 0; i < len; ++i) {
            dMap.put(this.getId(ss.get(i)), ds.get(i));
        }
        return dMap;
    }

    @Override
    public Page<D> convert(Page<S> source) {
        return new PageImpl(this.convert(source.getContent()), source.previousPageable(), source.getTotalElements());
    }

    @Override
    public D get(ID id) {
        return this.convert(this.internalGet(id));
    }

    @Override
    public Map<ID, D> mget(Collection<ID> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyMap();
        }
        return this.convert(this.internalMGet(ids));
    }

    @Override
    public List<ID> getIds(List<S> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<ID> ids = new ArrayList<ID>(source.size());
        for (S s : source) {
            ids.add(this.getId(s));
        }
        return ids;
    }

    private void assembler(List<S> ss, List<D> ds) {
        int len = ss.size();
        ArrayList keys = new ArrayList(len);
        for (ConverterAssembler assembler : this.assemblers) {
            Map map;
            if (!assembler.accept(this.hints)) continue;
            keys.clear();
            for (int i = 0; i < len; ++i) {
                Set ks = assembler.getKeys(ss.get(i), ds.get(i));
                if (ks == null) continue;
                keys.addAll(ks);
            }
            List realKeys = AbstractConverter.trimNull(keys);
            if (CollectionUtils.isEmpty(realKeys) || CollectionUtils.isEmpty(map = assembler.mgetValue(realKeys))) continue;
            for (int i = 0; i < ds.size(); ++i) {
                assembler.setValues(ss.get(i), ds.get(i), map);
            }
        }
    }

    protected abstract ID getId(S var1);

    protected abstract D internalConvert(S var1);

    protected abstract S internalGet(ID var1);

    protected abstract Map<ID, S> internalMGet(Collection<ID> var1);

    public void afterPropertiesSet() throws Exception {
        this.initAssemblers(this.assemblers);
    }
}

