/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa.auditing;

import java.io.Serializable;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.AbstractPersistable;
import org.springframework.util.ClassUtils;

@MappedSuperclass
public abstract class BaseEntity<PK extends Serializable>
implements Persistable<PK> {
    @Id
    @GenericGenerator(name="snowflake", strategy="com.slyak.spring.jpa.util.SnowflakeGenerator")
    @GeneratedValue(generator="snowflake")
    private PK id;

    public PK getId() {
        return this.id;
    }

    protected void setId(PK id) {
        this.id = id;
    }

    @Transient
    public boolean isNew() {
        return null == this.getId();
    }

    public String toString() {
        return String.format("Entity of type %s with id: %s", this.getClass().getName(), this.getId());
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!this.getClass().equals(ClassUtils.getUserClass((Object)obj))) {
            return false;
        }
        AbstractPersistable that = (AbstractPersistable)obj;
        return null != this.getId() && this.getId().equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 17;
        return hashCode += null == this.getId() ? 0 : this.getId().hashCode() * 31;
    }
}

