/*
 * Decompiled with CFR 0.152.
 */
package com.slyak.spring.jpa;

import com.slyak.spring.jpa.NamedTemplateCallback;
import com.slyak.spring.jpa.NamedTemplateResolver;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleSaxErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XmlNamedTemplateResolver
implements NamedTemplateResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String encoding = "UTF-8";
    private DocumentLoader documentLoader = new DefaultDocumentLoader();
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new SimpleSaxErrorHandler(this.logger);

    public XmlNamedTemplateResolver(ResourceLoader resourceLoader) {
        this.entityResolver = new ResourceEntityResolver(resourceLoader);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public Iterator<Void> doInTemplateResource(Resource resource, final NamedTemplateCallback callback) throws Exception {
        InputSource inputSource = new InputSource(resource.getInputStream());
        inputSource.setEncoding(this.encoding);
        Document doc = this.documentLoader.loadDocument(inputSource, this.entityResolver, this.errorHandler, 3, false);
        final List sqes = DomUtils.getChildElementsByTagName((Element)doc.getDocumentElement(), (String)"sql");
        return new Iterator<Void>(){
            int index = 0;
            int total = sqes.size();

            @Override
            public boolean hasNext() {
                return this.index < this.total;
            }

            @Override
            public Void next() {
                Element sqle = (Element)sqes.get(this.index);
                callback.process(sqle.getAttribute("name"), sqle.getTextContent());
                ++this.index;
                return null;
            }

            @Override
            public void remove() {
            }
        };
    }
}

